/*
 * Decompiled with CFR 0.152.
 */
package com.assembla.jenkinsci.plugin.api;

import com.assembla.jenkinsci.plugin.api.RefreshTokenResponse;
import com.assembla.jenkinsci.plugin.api.SpaceAssembla;
import com.assembla.jenkinsci.plugin.api.TokenAssembla;
import com.assembla.jenkinsci.plugin.api.UserAssembla;
import com.assembla.jenkinsci.plugin.api.UserRoleAssembla;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class ApiService {
    public static final String ASSEMBLA_ROLE_OWNER = "owner";
    public static final String ASSEMBLA_ROLE_MEMBER = "member";
    public static final String ASSEMBLA_ROLE_WATCHER = "watcher";
    private static final Logger LOGGER = Logger.getLogger(ApiService.class.getName());
    private static final String API_HOST_ASSEMBLA = "https://api.assembla.com";
    private static final String API_VERSION = "v1";
    private static final String URL_ASSEMBLA_API_VERSION = "https://api.assembla.com/v1";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String URL_COMMENCE_LOGIN = "https://api.assembla.com/authorization?response_type=code&client_id=";
    private static final String URL_POST_TOKEN_BY_AUTHORIZATION_CODE = "https://api.assembla.com/token?grant_type=authorization_code&code=";
    private static final String URL_POST_REFRESH_TOKEN = "https://api.assembla.com/token?grant_type=refresh_token&refresh_token=%s";
    private static final String URL_GET_USER_BY_TOKEN = "https://api.assembla.com/v1/user.json";
    private static final String URL_GET_SPACE_USERS = "https://api.assembla.com/v1/spaces/%s/users.json";
    private static final String URL_GET_SPACE_USER_ROLES = "https://api.assembla.com/v1/spaces/%s/user_roles.json";
    private static final String URL_GET_SPACE = "https://api.assembla.com/v1/spaces/%s.json";

    public static String createAuthorizationCodeURL(String clientId) {
        LOGGER.log(Level.FINER, "getCommencLoginUrl() clientId = " + clientId);
        return URL_COMMENCE_LOGIN + clientId;
    }

    private static String httpPostAuthenticated(String url, String clientId, String clientSecret) throws IOException, AuthenticationException {
        String result = null;
        HttpPost httpost = new HttpPost(url);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(clientId, clientSecret);
        Header authenticateHeader = new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)httpost);
        httpost.addHeader(authenticateHeader);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpost);
        HttpEntity entity = response.getEntity();
        result = EntityUtils.toString((HttpEntity)entity);
        httpclient.getConnectionManager().shutdown();
        LOGGER.log(Level.FINER, "HTTP POST  content = " + result);
        return result;
    }

    public static TokenAssembla getTokenByAuthorizationCode(String code, String clientId, String clientSecret) {
        TokenAssembla result = null;
        String url = URL_POST_TOKEN_BY_AUTHORIZATION_CODE + code;
        LOGGER.log(Level.FINER, "finishLoginGetAccessToken() URL = " + url);
        try {
            String content = ApiService.httpPostAuthenticated(url, clientId, clientSecret);
            Gson gson = new Gson();
            result = (TokenAssembla)gson.fromJson(content, TokenAssembla.class);
            result.clientId = clientId;
            result.clientSecret = clientSecret;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public static String postRefreshAccessToken(String refresh_token, String clientId, String clientSecret) {
        String url = String.format(URL_POST_REFRESH_TOKEN, refresh_token);
        String accessToken = null;
        LOGGER.log(Level.FINER, "postRefreshAccessToken() URL = " + url);
        try {
            String content = ApiService.httpPostAuthenticated(url, clientId, clientSecret);
            Gson gson = new Gson();
            RefreshTokenResponse refreshTokenresponse = (RefreshTokenResponse)gson.fromJson(content, RefreshTokenResponse.class);
            accessToken = refreshTokenresponse.access_token;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return accessToken;
    }

    public static UserAssembla getUserByToken(String access_token) {
        LOGGER.log(Level.FINER, "getUserByToken() URL = https://api.assembla.com/v1/user.json");
        UserAssembla user = null;
        try {
            String content = ApiService.httpGet(URL_GET_USER_BY_TOKEN, access_token);
            LOGGER.log(Level.FINER, "content = {0}", content);
            Gson gson = new Gson();
            user = (UserAssembla)gson.fromJson(content, UserAssembla.class);
        }
        catch (Exception ex) {
            Logger.getLogger(ApiService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return user;
    }

    public static UserAssembla[] getSpaceUsers(String access_token, String spaceId) {
        String url = String.format(URL_GET_SPACE_USERS, spaceId);
        LOGGER.log(Level.FINER, "getSpaceUsers() URL = {0}", url);
        UserAssembla[] users = null;
        try {
            String content = ApiService.httpGet(url, access_token);
            Gson gson = new Gson();
            users = (UserAssembla[])gson.fromJson(content, UserAssembla[].class);
            LOGGER.log(Level.FINER, "content users count: {0}", users.length);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return users;
    }

    public static SpaceAssembla getSpace(String access_token, String spaceId) {
        String url = String.format(URL_GET_SPACE, spaceId);
        LOGGER.log(Level.FINER, "getSpace() URL = {0}", url);
        SpaceAssembla result = null;
        try {
            String content = ApiService.httpGet(url, access_token);
            LOGGER.log(Level.FINER, "getSpace() content = {0}", content);
            Gson gson = new Gson();
            result = (SpaceAssembla)gson.fromJson(content, SpaceAssembla.class);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public static UserRoleAssembla[] getUserRoles(String access_token, String spaceId) {
        String url = String.format(URL_GET_SPACE_USER_ROLES, spaceId);
        LOGGER.log(Level.FINER, "getUserRoles() URL = {0}", url);
        UserRoleAssembla[] result = null;
        String content = null;
        try {
            content = ApiService.httpGet(url, access_token);
            LOGGER.log(Level.FINER, "getUserRoles() content = {0}", content);
            Gson gson = new Gson();
            result = (UserRoleAssembla[])gson.fromJson(content, UserRoleAssembla[].class);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "getUserRoles() content = " + content + "\n" + ex.toString());
        }
        return result;
    }

    private static String httpGet(String url, String access_token) throws IOException {
        String result = null;
        HttpGet httpGet = new HttpGet(url);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpGet.addHeader("Authorization", "Bearer " + access_token);
        httpGet.addHeader("Content-type", CONTENT_TYPE_JSON);
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        HttpEntity httpEntity = httpResponse.getEntity();
        result = EntityUtils.toString((HttpEntity)httpEntity);
        httpClient.getConnectionManager().shutdown();
        return result;
    }
}

