/*
 * Decompiled with CFR 0.152.
 */
package com.assembla.jenkinsci.plugin;

import com.assembla.jenkinsci.plugin.AssemblaAuthenticationToken;
import com.assembla.jenkinsci.plugin.OAuthUserAssembla;
import com.assembla.jenkinsci.plugin.api.ApiService;
import com.assembla.jenkinsci.plugin.api.TokenAssembla;
import com.assembla.jenkinsci.plugin.api.UserAssembla;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.dao.DataAccessException;

public class AssemblaSecurityRealm
extends SecurityRealm
implements UserDetailsService {
    private static final String REFERER_ATTRIBUTE = AssemblaSecurityRealm.class.getName() + ".referer";
    private static final Logger LOGGER = Logger.getLogger(AssemblaSecurityRealm.class.getName());
    private String apiUri;
    private String clientID;
    private Secret clientSecret;
    private String spaceId;

    @DataBoundConstructor
    public AssemblaSecurityRealm(String apiUri, String clientID, String clientSecret, String spaceId) {
        LOGGER.log(Level.FINE, "AssemblaSecurityRealm(apiUri, clientID, clientSecret, spaceId) ");
        this.apiUri = Util.fixEmptyAndTrim((String)apiUri);
        this.clientID = Util.fixEmptyAndTrim((String)clientID);
        this.setClientSecret(Util.fixEmptyAndTrim((String)clientSecret));
        this.spaceId = Util.fixEmptyAndTrim((String)spaceId);
    }

    private AssemblaSecurityRealm() {
        LOGGER.log(Level.FINE, "AssemblaSecurityRealm()");
    }

    private void setApiUri(String apiUri) {
        this.apiUri = apiUri;
    }

    private void setClientID(String clientID) {
        this.clientID = clientID;
    }

    private void setClientSecret(String clientSecret) {
        this.clientSecret = Secret.fromString((String)clientSecret);
    }

    private void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public String getClientID() {
        return this.clientID;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public HttpResponse doCommenceLogin(StaplerRequest request, @Header(value="Referer") String referer) throws IOException {
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)referer);
        return new HttpRedirect(ApiService.createAuthorizationCodeURL(this.clientID));
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        String code = request.getParameter("code");
        if (code == null || code.trim().length() == 0) {
            LOGGER.log(Level.SEVERE, "doFinishLogin() code = null");
            return HttpResponses.redirectToContextRoot();
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            LOGGER.log(Level.FINEST, "Invalidate previous session");
            session.invalidate();
        }
        request.getSession(true);
        TokenAssembla tokensAssembla = ApiService.getTokenByAuthorizationCode(code, this.clientID, this.clientSecret.getPlainText());
        if (tokensAssembla != null && tokensAssembla.access_token != null && tokensAssembla.access_token.trim().length() > 0) {
            AssemblaAuthenticationToken auth = new AssemblaAuthenticationToken(tokensAssembla, this.spaceId);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            String username = auth.getName();
            if (username != null && User.current() != null) {
                SecurityListener.fireAuthenticated((UserDetails)new OAuthUserAssembla(username, auth.getAuthorities()));
            }
        } else {
            LOGGER.log(Level.SEVERE, "doFinishLogin() accessToken = null");
        }
        String referer = (String)request.getSession().getAttribute(REFERER_ATTRIBUTE);
        if (referer != null) {
            LOGGER.log(Level.FINEST, "doFinishLogin() redirecting to referer " + referer);
            return HttpResponses.redirectTo((String)referer);
        }
        LOGGER.log(Level.FINEST, "doFinishLogin() redirecting to root");
        return HttpResponses.redirectToContextRoot();
    }

    public boolean allowsSignup() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AssemblaAuthenticationToken) {
                    return authentication;
                }
                LOGGER.log(Level.FINEST, "Unexpected authentication type: " + authentication);
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        }, new UserDetailsService(){

            public UserDetails loadUserByUsername(String username) throws UserMayOrMayNotExistException, UsernameNotFoundException, DataAccessException {
                return AssemblaSecurityRealm.this.loadUserByUsername(username);
            }
        });
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public UserDetails loadUserByUsername(String username) {
        Authentication token = SecurityContextHolder.getContext().getAuthentication();
        if (token == null) {
            throw new UserMayOrMayNotExistException("Could not get auth token.");
        }
        if (!(token instanceof AssemblaAuthenticationToken)) {
            throw new UserMayOrMayNotExistException("Unexpected authentication type: " + token);
        }
        AssemblaAuthenticationToken authToken = (AssemblaAuthenticationToken)token;
        UserAssembla result = authToken.getUserByUsername(username);
        if (result == null) {
            throw new UsernameNotFoundException("User does not exist for login: " + username);
        }
        return result;
    }

    public GroupDetails loadGroupByGroupname(String groupName) {
        throw new UsernameNotFoundException("groups not supported");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getHelpFile() {
            return "/plugin/assembla-oauth/help/help-security-realm.html";
        }

        public String getDisplayName() {
            return "Assembla Auth Plugin";
        }

        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == AssemblaSecurityRealm.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            AssemblaSecurityRealm realm = (AssemblaSecurityRealm)((Object)source);
            writer.startNode("apiUri");
            writer.setValue(realm.getApiUri());
            writer.endNode();
            writer.startNode("clientID");
            writer.setValue(realm.getClientID());
            writer.endNode();
            writer.startNode("clientSecret");
            writer.setValue(realm.getClientSecret().getEncryptedValue());
            writer.endNode();
            writer.startNode("spaceId");
            writer.setValue(realm.getSpaceId());
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String node = reader.getNodeName();
            reader.moveDown();
            AssemblaSecurityRealm realm = new AssemblaSecurityRealm();
            node = reader.getNodeName();
            String value = reader.getValue();
            this.setValue(realm, node, value);
            reader.moveUp();
            reader.moveDown();
            node = reader.getNodeName();
            value = reader.getValue();
            this.setValue(realm, node, value);
            reader.moveUp();
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                node = reader.getNodeName();
                value = reader.getValue();
                this.setValue(realm, node, value);
                reader.moveUp();
            }
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                node = reader.getNodeName();
                value = reader.getValue();
                this.setValue(realm, node, value);
                reader.moveUp();
            }
            return realm;
        }

        private void setValue(AssemblaSecurityRealm realm, String node, String value) {
            if (node.equalsIgnoreCase("clientid")) {
                realm.setClientID(value);
            } else if (node.equalsIgnoreCase("clientsecret")) {
                realm.setClientSecret(value);
            } else if (node.equalsIgnoreCase("apiUri")) {
                realm.setApiUri(value);
            } else if (node.equalsIgnoreCase("spaceid")) {
                realm.setSpaceId(value);
            } else {
                throw new ConversionException("invalid node value = " + node);
            }
        }
    }
}

