/*
 * Decompiled with CFR 0.152.
 */
package com.assembla.jenkinsci.plugin;

import com.assembla.jenkinsci.plugin.AssemblaACL;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class AssemblaAuthorizationStrategy
extends AuthorizationStrategy {
    private final AssemblaACL rootACL;

    @DataBoundConstructor
    public AssemblaAuthorizationStrategy(String adminUserNames) {
        this.rootACL = new AssemblaACL(adminUserNames);
    }

    public ACL getRootACL() {
        return this.rootACL;
    }

    public Collection<String> getGroups() {
        return new ArrayList<String>(0);
    }

    public String getAdminUserNames() {
        return StringUtils.join(this.rootACL.getAdminUserNameList().iterator(), (String)", ");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        public String getDisplayName() {
            return "Assembla Authorization Strategy";
        }

        public String getHelpFile() {
            return "/plugin/assembla-oauth/help/help-authorization-strategy.html";
        }
    }
}

