/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.converters;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.util.XStream2;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Logger;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.maven3.ArtifactoryMaven3NativeConfigurator;
import org.jfrog.hudson.util.Credentials;

public class DeployerResolverOverriderConverter<T>
extends XStream2.PassthruConverter<T> {
    Logger logger = Logger.getLogger(DeployerResolverOverriderConverter.class.getName());
    List<String> converterErrors = Lists.newArrayList();

    public DeployerResolverOverriderConverter(XStream2 xstream) {
        super(xstream);
    }

    protected void callback(T overrider, UnmarshallingContext context) {
        Class<?> overriderClass = overrider.getClass();
        this.overrideResolverDetails(overrider, overriderClass);
        this.credentialsMigration(overrider, overriderClass);
        if (!this.converterErrors.isEmpty()) {
            this.logger.info(this.converterErrors.toString());
        }
    }

    public void credentialsMigration(T overrider, Class overriderClass) {
        try {
            this.deployerMigration(overrider, overriderClass);
            this.resolverMigration(overrider, overriderClass);
        }
        catch (NoSuchFieldException e) {
            this.converterErrors.add(this.getConversionErrorMessage(overrider, e));
        }
        catch (IllegalAccessException e) {
            this.converterErrors.add(this.getConversionErrorMessage(overrider, e));
        }
        catch (IOException e) {
            this.converterErrors.add(this.getConversionErrorMessage(overrider, e));
        }
    }

    private void deployerMigration(T overrider, Class overriderClass) throws NoSuchFieldException, IllegalAccessException, IOException {
        if (overrider instanceof DeployerOverrider) {
            Field overridingDeployerCredentialsField = overriderClass.getDeclaredField("overridingDeployerCredentials");
            overridingDeployerCredentialsField.setAccessible(true);
            Object overridingDeployerCredentials = overridingDeployerCredentialsField.get(overrider);
            Field deployerCredentialsConfigField = overriderClass.getDeclaredField("deployerCredentialsConfig");
            deployerCredentialsConfigField.setAccessible(true);
            if (overridingDeployerCredentials != null) {
                boolean shouldOverride = ((DeployerOverrider)overrider).getOverridingDeployerCredentials() != null;
                deployerCredentialsConfigField.set(overrider, new CredentialsConfig((Credentials)overridingDeployerCredentials, "", shouldOverride));
            } else if (deployerCredentialsConfigField.get(overrider) == null) {
                deployerCredentialsConfigField.set(overrider, CredentialsConfig.EMPTY_CREDENTIALS_CONFIG);
            }
        }
    }

    private void resolverMigration(T overrider, Class overriderClass) throws NoSuchFieldException, IllegalAccessException, IOException {
        if (overrider instanceof ResolverOverrider) {
            Field resolverCredentialsField = overriderClass.getDeclaredField("overridingResolverCredentials");
            resolverCredentialsField.setAccessible(true);
            Object resolverCredentials = resolverCredentialsField.get(overrider);
            Field resolverCredentialsConfigField = overriderClass.getDeclaredField("resolverCredentialsConfig");
            resolverCredentialsConfigField.setAccessible(true);
            if (resolverCredentials != null) {
                boolean shouldOverride = ((ResolverOverrider)overrider).getOverridingResolverCredentials() != null;
                CredentialsConfig credentialsConfig = new CredentialsConfig((Credentials)resolverCredentials, "", shouldOverride);
                resolverCredentialsConfigField.set(overrider, credentialsConfig);
            } else if (resolverCredentialsConfigField.get(overrider) == null) {
                resolverCredentialsConfigField.set(overrider, CredentialsConfig.EMPTY_CREDENTIALS_CONFIG);
            }
        }
    }

    private void overrideResolverDetails(T overrider, Class overriderClass) {
        if (overrider instanceof ResolverOverrider && !overriderClass.getSimpleName().equals(ArtifactoryMaven3NativeConfigurator.class.getSimpleName())) {
            try {
                Field resolverDetailsField = overriderClass.getDeclaredField("resolverDetails");
                resolverDetailsField.setAccessible(true);
                Object resolverDetails = resolverDetailsField.get(overrider);
                if (resolverDetails == null) {
                    Field deployerDetailsField = overriderClass.getDeclaredField("details");
                    deployerDetailsField.setAccessible(true);
                    Object deployerDetails = deployerDetailsField.get(overrider);
                    if (deployerDetails != null) {
                        ServerDetails resolverServerDetails = this.createInitialResolveDetailsFromDeployDetails((ServerDetails)deployerDetails);
                        resolverDetailsField.set(overrider, resolverServerDetails);
                    }
                }
            }
            catch (NoSuchFieldException e) {
                this.converterErrors.add(this.getConversionErrorMessage(overrider, e));
            }
            catch (IllegalAccessException e) {
                this.converterErrors.add(this.getConversionErrorMessage(overrider, e));
            }
        }
    }

    private ServerDetails createInitialResolveDetailsFromDeployDetails(ServerDetails deployerDetails) {
        RepositoryConf oldResolveRepositoryConfig = deployerDetails.getResolveReleaseRepository();
        RepositoryConf oldSnapshotResolveRepositoryConfig = deployerDetails.getResolveSnapshotRepository();
        RepositoryConf resolverReleaseRepos = oldResolveRepositoryConfig == null ? RepositoryConf.emptyRepositoryConfig : oldResolveRepositoryConfig;
        RepositoryConf resolveSnapshotRepos = oldSnapshotResolveRepositoryConfig == null ? RepositoryConf.emptyRepositoryConfig : oldSnapshotResolveRepositoryConfig;
        return new ServerDetails(deployerDetails.getArtifactoryName(), deployerDetails.getArtifactoryUrl(), null, null, resolverReleaseRepos, resolveSnapshotRepos, null, null);
    }

    private String getConversionErrorMessage(T deployerOverrider, Exception e) {
        return String.format("Could not convert the class '%s' to use the new overridingformat. Cause: %s", deployerOverrider.getClass().getName(), e.getCause());
    }
}

