/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.SpecConfiguration;

public class SpecUtils {
    public static String getSpecStringFromSpecConf(SpecConfiguration specConfiguration, EnvVars env, FilePath workspace, PrintStream logger) throws IOException, InterruptedException {
        if (StringUtils.isNotBlank((String)specConfiguration.getFilePath())) {
            String filePath = specConfiguration.getFilePath().trim();
            filePath = Util.replaceMacro((String)filePath, (Map)env);
            String spec = SpecUtils.buildDownloadSpecPath(filePath, workspace, logger).readToString();
            return Util.replaceMacro((String)spec.trim(), (Map)env);
        }
        if (StringUtils.isNotBlank((String)specConfiguration.getSpec())) {
            return Util.replaceMacro((String)specConfiguration.getSpec().trim(), (Map)env);
        }
        return "";
    }

    private static FilePath buildDownloadSpecPath(String providedPath, FilePath workingDir, PrintStream logger) throws IOException, InterruptedException {
        FilePath relativeFile = new FilePath(workingDir, providedPath);
        if (relativeFile.exists() && !relativeFile.isDirectory()) {
            logger.println(String.format("Using spec file: %s", relativeFile.getRemote()));
            return relativeFile;
        }
        throw new IOException(String.format("Could not find spec file in the provided path: %s", relativeFile.getRemote()));
    }
}

