/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.action.ActionableHelper;

public class PluginDependencyHelper {
    public static FilePath getActualDependencyDirectory(File localDependencyFile, FilePath rootPath) throws IOException, InterruptedException {
        FilePath remoteDependencyMark;
        FilePath remoteDependencyDir;
        File localDependencyDir = localDependencyFile.getParentFile();
        String pluginVersion = Hudson.getInstance().getPluginManager().getPlugin("artifactory").getVersion();
        if (pluginVersion.contains(" ")) {
            pluginVersion = StringUtils.split((String)pluginVersion, (String)" ")[0];
        }
        if (!(remoteDependencyDir = new FilePath(rootPath, "cache/artifactory-plugin/" + pluginVersion)).exists()) {
            remoteDependencyDir.mkdirs();
        }
        if (!(remoteDependencyMark = new FilePath(remoteDependencyDir, "ok")).exists()) {
            File[] localDependencies;
            for (File localDependency : localDependencies = localDependencyDir.listFiles()) {
                FilePath remoteDependencyFilePath;
                if (localDependency.getName().equals("classes.jar") || (remoteDependencyFilePath = new FilePath(remoteDependencyDir, localDependency.getName())).exists()) continue;
                FilePath localDependencyFilePath = new FilePath(localDependency);
                localDependencyFilePath.copyTo(remoteDependencyFilePath);
            }
            remoteDependencyMark.touch(System.currentTimeMillis());
        }
        return remoteDependencyDir;
    }

    private static FilePath getRootPath(Run build, Launcher launcher) {
        if (build instanceof AbstractBuild) {
            return ((AbstractBuild)build).getBuiltOn().getRootPath();
        }
        return ActionableHelper.getNode(launcher).getRootPath();
    }
}

