/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedMapDifference;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.SlaveComputer;
import hudson.util.IOUtils;
import hudson.util.RunList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.maven3.ArtifactoryMaven3Configurator;
import org.jfrog.hudson.maven3.ArtifactoryMaven3NativeConfigurator;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.resolvers.MavenResolver;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.util.BuildRetentionFactory;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.IssuesTrackerHelper;
import org.jfrog.hudson.util.ResolverContext;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;

public class ExtractorUtils {
    public static final String EXTRACTOR_USED = "extractor.used";
    public static final String GIT_COMMIT = "GIT_COMMIT";

    private ExtractorUtils() {
        throw new IllegalAccessError();
    }

    public static String getVcsRevision(Map<String, String> env) {
        String revision = env.get("SVN_REVISION");
        if (StringUtils.isBlank((String)revision)) {
            revision = env.get(GIT_COMMIT);
        }
        if (StringUtils.isBlank((String)revision)) {
            revision = env.get("P4_CHANGELIST");
        }
        return revision;
    }

    public static String getVcsUrl(Map<String, String> env) {
        String url = env.get("SVN_URL");
        if (StringUtils.isBlank((String)url)) {
            url = ExtractorUtils.publicGitUrl(env.get("GIT_URL"));
        }
        if (StringUtils.isBlank((String)url)) {
            url = env.get("P4PORT");
        }
        return url;
    }

    private static String publicGitUrl(String gitUrl) {
        if (gitUrl != null && gitUrl.contains("https://") && gitUrl.contains("@")) {
            StringBuilder sb = new StringBuilder(gitUrl);
            int start = sb.indexOf("https://");
            int end = sb.indexOf("@") + 1;
            sb = sb.replace(start, end, "");
            return "https://" + sb.toString();
        }
        return gitUrl;
    }

    public static ArtifactoryClientConfiguration addBuilderInfoArguments(Map<String, String> env, Run build, TaskListener listener, PublisherContext publisherContext, ResolverContext resolverContext, FilePath ws, Launcher launcher) throws Exception {
        ArtifactoryClientConfiguration configuration = ExtractorUtils.getArtifactoryClientConfiguration(env, build, null, listener, publisherContext, resolverContext);
        if (ExtractorUtils.isMavenResolutionConfigured(resolverContext)) {
            env.put("buildInfoConfig.artifactoryResolutionEnabled", Boolean.TRUE.toString());
        }
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(launcher, ws);
        ExtractorUtils.persistConfiguration(configuration, env, tempDir, launcher);
        return configuration;
    }

    public static ArtifactoryClientConfiguration getArtifactoryClientConfiguration(Map<String, String> env, Run build, BuildInfo pipelineBuildInfo, TaskListener listener, PublisherContext publisherContext, ResolverContext resolverContext) throws UnsupportedEncodingException {
        ArtifactoryClientConfiguration configuration = new ArtifactoryClientConfiguration((Log)new NullLog());
        if (build instanceof AbstractBuild) {
            ExtractorUtils.addBuildRootIfNeeded((AbstractBuild)build, configuration);
        }
        if (publisherContext != null) {
            ExtractorUtils.setPublisherInfo(env, build, pipelineBuildInfo, publisherContext, configuration);
            publisherContext.setArtifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion());
        }
        if (resolverContext != null) {
            ExtractorUtils.setResolverInfo(configuration, build, resolverContext, env);
        }
        if (!ExtractorUtils.shouldBypassProxy(resolverContext, publisherContext)) {
            ExtractorUtils.setProxy(configuration);
        }
        if (Jenkins.getInstance().getPlugin("jira") != null && publisherContext != null && publisherContext.isEnableIssueTrackerIntegration()) {
            new IssuesTrackerHelper(build, listener, publisherContext.isAggregateBuildIssues(), publisherContext.getAggregationBuildStatus()).setIssueTrackerInfo(configuration);
        }
        IncludesExcludes envVarsPatterns = new IncludesExcludes("", "");
        if (publisherContext != null && publisherContext.getEnvVarsPatterns() != null) {
            envVarsPatterns = publisherContext.getEnvVarsPatterns();
        }
        ExtractorUtils.addEnvVars(env, build, configuration, envVarsPatterns, listener);
        return configuration;
    }

    private static boolean shouldBypassProxy(ResolverContext resolverContext, PublisherContext publisherContext) {
        boolean bypass = resolverContext != null && resolverContext.getServer() != null && resolverContext.getServer().isBypassProxy();
        return bypass || publisherContext != null && publisherContext.getArtifactoryServer() != null && publisherContext.getArtifactoryServer().isBypassProxy();
    }

    private static void setProxy(ArtifactoryClientConfiguration configuration) {
        Jenkins j = Jenkins.getInstance();
        if (j.proxy != null) {
            configuration.proxy.setHost(j.proxy.name);
            configuration.proxy.setPort(Integer.valueOf(j.proxy.port));
            configuration.proxy.setUsername(j.proxy.getUserName());
            configuration.proxy.setPassword(j.proxy.getPassword());
        }
    }

    private static void setResolverInfo(ArtifactoryClientConfiguration configuration, Run build, ResolverContext context, Map<String, String> env) {
        configuration.setTimeout(Integer.valueOf(context.getServer().getTimeout()));
        ExtractorUtils.setRetryParams(configuration, context.getServer());
        configuration.resolver.setContextUrl(context.getServerDetails().getArtifactoryUrl());
        String inputDownloadReleaseKey = context.getServerDetails().getResolveReleaseRepository().getRepoKey();
        String inputDownloadSnapshotKey = context.getServerDetails().getResolveSnapshotRepository().getRepoKey();
        ExtractorUtils.replaceRepositoryInputForValues(configuration, build, inputDownloadReleaseKey, inputDownloadSnapshotKey, env);
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(context.getResolverOverrider(), context.getServer());
        if (StringUtils.isNotBlank((String)preferredResolver.provideUsername((Item)build.getParent()))) {
            configuration.resolver.setUsername(preferredResolver.provideUsername((Item)build.getParent()));
            configuration.resolver.setPassword(preferredResolver.providePassword((Item)build.getParent()));
        }
    }

    private static void replaceRepositoryInputForValues(ArtifactoryClientConfiguration configuration, Run build, String resolverReleaseInput, String resolverSnapshotInput, Map<String, String> env) {
        if (StringUtils.isBlank((String)resolverReleaseInput) || StringUtils.isBlank((String)resolverSnapshotInput)) {
            build.setResult(Result.FAILURE);
            throw new IllegalStateException("Input for resolve repositories cannot be empty.");
        }
        String resolveReleaseRepo = Util.replaceMacro((String)resolverReleaseInput, env);
        String resolveSnapshotRepo = Util.replaceMacro((String)resolverSnapshotInput, env);
        if (StringUtils.isBlank((String)resolveReleaseRepo) || StringUtils.isBlank((String)resolveSnapshotRepo)) {
            build.setResult(Result.FAILURE);
            throw new IllegalStateException("Resolver repository variable cannot be replaces with empty value.");
        }
        configuration.resolver.setDownloadSnapshotRepoKey(resolveSnapshotRepo);
        configuration.resolver.setRepoKey(resolveReleaseRepo);
    }

    private static void setPublisherInfo(Map<String, String> env, Run build, BuildInfo pipelineBuildInfo, PublisherContext context, ArtifactoryClientConfiguration configuration) {
        ReleaseAction releaseAction;
        IncludesExcludes deploymentPatterns;
        ServerDetails serverDetails;
        String vcsUrl;
        String buildNumber;
        String buildName;
        configuration.setActivateRecorder(Boolean.TRUE);
        if (pipelineBuildInfo != null) {
            buildName = pipelineBuildInfo.getName();
            buildNumber = pipelineBuildInfo.getNumber();
        } else {
            buildName = context.isOverrideBuildName() ? context.getCustomBuildName() : BuildUniqueIdentifierHelper.getBuildName(build);
            buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        }
        configuration.info.setBuildName(buildName);
        configuration.publisher.addMatrixParam("build.name", buildName);
        configuration.info.setBuildNumber(buildNumber);
        configuration.publisher.addMatrixParam("build.number", buildNumber);
        configuration.info.setArtifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion());
        Date buildStartDate = build.getTimestamp().getTime();
        configuration.info.setBuildStarted(buildStartDate.getTime());
        configuration.info.setBuildTimestamp(String.valueOf(build.getStartTimeInMillis()));
        configuration.publisher.addMatrixParam("build.timestamp", String.valueOf(build.getStartTimeInMillis()));
        String vcsRevision = ExtractorUtils.getVcsRevision(env);
        if (StringUtils.isNotBlank((String)vcsRevision)) {
            configuration.info.setVcsRevision(vcsRevision);
            configuration.publisher.addMatrixParam("vcs.revision", vcsRevision);
        }
        if (StringUtils.isNotBlank((String)(vcsUrl = ExtractorUtils.getVcsUrl(env)))) {
            configuration.info.setVcsUrl(vcsUrl);
        }
        if (StringUtils.isNotBlank((String)context.getArtifactsPattern())) {
            configuration.publisher.setIvyArtifactPattern(Util.replaceMacro((String)context.getArtifactsPattern(), env));
        }
        if (StringUtils.isNotBlank((String)context.getIvyPattern())) {
            configuration.publisher.setIvyPattern(Util.replaceMacro((String)context.getIvyPattern(), env));
        }
        configuration.publisher.setM2Compatible(Boolean.valueOf(context.isMaven2Compatible()));
        String buildUrl = ActionableHelper.getBuildUrl(build);
        if (StringUtils.isNotBlank((String)buildUrl)) {
            configuration.info.setBuildUrl(buildUrl);
        }
        String userName = null;
        Cause.UpstreamCause parent = ActionableHelper.getUpstreamCause(build);
        if (parent != null) {
            String parentProject = ExtractorUtils.sanitizeBuildName(parent.getUpstreamProject());
            configuration.info.setParentBuildName(parentProject);
            configuration.publisher.addMatrixParam("build.parentName", parentProject);
            String parentBuildNumber = parent.getUpstreamBuild() + "";
            configuration.info.setParentBuildNumber(parentBuildNumber);
            configuration.publisher.addMatrixParam("build.parentNumber", parentBuildNumber);
            userName = "auto";
        }
        userName = ActionableHelper.getUserCausePrincipal(build, userName);
        configuration.info.setPrincipal(userName);
        configuration.info.setAgentName("Jenkins");
        configuration.info.setAgentVersion(Jenkins.VERSION);
        ArtifactoryServer artifactoryServer = context.getArtifactoryServer();
        if (artifactoryServer != null) {
            CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(context.getDeployerOverrider(), artifactoryServer);
            if (StringUtils.isNotBlank((String)preferredDeployer.provideUsername((Item)build.getParent()))) {
                configuration.publisher.setUsername(preferredDeployer.provideUsername((Item)build.getParent()));
                configuration.publisher.setPassword(preferredDeployer.providePassword((Item)build.getParent()));
            }
            configuration.setTimeout(Integer.valueOf(artifactoryServer.getTimeout()));
            ExtractorUtils.setRetryParams(configuration, artifactoryServer);
            configuration.publisher.setContextUrl(artifactoryServer.getUrl());
        }
        if ((serverDetails = context.getServerDetails()) != null) {
            String inputRepKey = serverDetails.getDeployReleaseRepositoryKey();
            String repoKEy = Util.replaceMacro((String)inputRepKey, env);
            configuration.publisher.setRepoKey(repoKEy);
            String inputSnapshotRepKey = serverDetails.getDeploySnapshotRepositoryKey();
            String snapshotRepoKey = Util.replaceMacro((String)inputSnapshotRepKey, env);
            configuration.publisher.setSnapshotRepoKey(snapshotRepoKey);
        }
        configuration.info.licenseControl.setRunChecks(Boolean.valueOf(context.isRunChecks()));
        configuration.info.licenseControl.setIncludePublishedArtifacts(Boolean.valueOf(context.isIncludePublishArtifacts()));
        configuration.info.licenseControl.setAutoDiscover(Boolean.valueOf(context.isLicenseAutoDiscovery()));
        if (context.isRunChecks()) {
            if (StringUtils.isNotBlank((String)context.getViolationRecipients())) {
                configuration.info.licenseControl.setViolationRecipients(Util.replaceMacro((String)context.getViolationRecipients(), env));
            }
            if (StringUtils.isNotBlank((String)context.getScopes())) {
                configuration.info.licenseControl.setScopes(Util.replaceMacro((String)context.getScopes(), env));
            }
        }
        configuration.info.blackDuckProperties.setRunChecks(context.isBlackDuckRunChecks());
        configuration.info.blackDuckProperties.setAppName(Util.replaceMacro((String)context.getBlackDuckAppName(), env));
        configuration.info.blackDuckProperties.setAppVersion(Util.replaceMacro((String)context.getBlackDuckAppVersion(), env));
        configuration.info.blackDuckProperties.setReportRecipients(Util.replaceMacro((String)context.getBlackDuckReportRecipients(), env));
        configuration.info.blackDuckProperties.setScopes(Util.replaceMacro((String)context.getBlackDuckScopes(), env));
        configuration.info.blackDuckProperties.setIncludePublishedArtifacts(context.isBlackDuckIncludePublishedArtifacts());
        configuration.info.blackDuckProperties.setAutoCreateMissingComponentRequests(context.isAutoCreateMissingComponentRequests());
        configuration.info.blackDuckProperties.setAutoDiscardStaleComponentRequests(context.isAutoDiscardStaleComponentRequests());
        if (context.isDiscardOldBuilds()) {
            BuildRetention buildRetention = BuildRetentionFactory.createBuildRetention(build, context.isDiscardBuildArtifacts());
            if (buildRetention.getCount() > -1) {
                configuration.info.setBuildRetentionCount(Integer.valueOf(buildRetention.getCount()));
            }
            if (buildRetention.getMinimumBuildDate() != null) {
                long days = ExtractorUtils.daysBetween(buildRetention.getMinimumBuildDate(), new Date());
                configuration.info.setBuildRetentionMinimumDate(String.valueOf(days));
            }
            configuration.info.setDeleteBuildArtifacts(Boolean.valueOf(context.isDiscardBuildArtifacts()));
            configuration.info.setAsyncBuildRetention(Boolean.valueOf(context.isAsyncBuildRetention()));
            configuration.info.setBuildNumbersNotToDelete(ExtractorUtils.getBuildNumbersNotToBeDeletedAsString(build));
        }
        configuration.publisher.setPublishArtifacts(Boolean.valueOf(context.isDeployArtifacts()));
        configuration.publisher.setEvenUnstable(Boolean.valueOf(context.isEvenIfUnstable()));
        if (context.isDeployIvy() != null) {
            configuration.publisher.setIvy(context.isDeployIvy());
        }
        if (context.isDeployMaven() != null) {
            configuration.publisher.setMaven(context.isDeployMaven().booleanValue());
        }
        if ((deploymentPatterns = context.getIncludesExcludes()) != null) {
            String excludePatterns;
            String includePatterns = deploymentPatterns.getIncludePatterns();
            if (StringUtils.isNotBlank((String)includePatterns)) {
                configuration.publisher.setIncludePatterns(Util.replaceMacro((String)includePatterns, env));
            }
            if (StringUtils.isNotBlank((String)(excludePatterns = deploymentPatterns.getExcludePatterns()))) {
                configuration.publisher.setExcludePatterns(Util.replaceMacro((String)excludePatterns, env));
            }
        }
        if ((releaseAction = ActionableHelper.getLatestAction(build, ReleaseAction.class)) != null) {
            configuration.info.setReleaseEnabled(Boolean.valueOf(true));
            String comment = releaseAction.getStagingComment();
            if (StringUtils.isNotBlank((String)comment)) {
                configuration.info.setReleaseComment(comment);
            }
        }
        configuration.publisher.setFilterExcludedArtifactsFromBuild(context.isFilterExcludedArtifactsFromBuild());
        configuration.publisher.setPublishBuildInfo(Boolean.valueOf(!context.isSkipBuildInfoDeploy()));
        configuration.publisher.setRecordAllDependencies(Boolean.valueOf(context.isRecordAllDependencies()));
        configuration.setIncludeEnvVars(Boolean.valueOf(context.isIncludeEnvVars()));
        IncludesExcludes envVarsPatterns = context.getEnvVarsPatterns();
        if (envVarsPatterns != null) {
            configuration.setEnvVarsIncludePatterns(Util.replaceMacro((String)envVarsPatterns.getIncludePatterns(), env));
            configuration.setEnvVarsExcludePatterns(Util.replaceMacro((String)envVarsPatterns.getExcludePatterns(), env));
        }
        ExtractorUtils.addDeploymentProperties(context, configuration.publisher, env);
    }

    private static void setRetryParams(ArtifactoryClientConfiguration configuration, ArtifactoryServer artifactoryServer) {
        configuration.setConnectionRetries(Integer.valueOf(artifactoryServer.getConnectionRetry()));
    }

    private static long daysBetween(Date date1, Date date2) {
        long diff = date2.after(date1) ? date2.getTime() - date1.getTime() : date1.getTime() - date2.getTime();
        return diff / 86400000L;
    }

    public static String sanitizeBuildName(String buildName) {
        String s = StringUtils.replace((String)buildName, (String)"/", (String)" :: ");
        return StringUtils.replace((String)s, (String)"%2F", (String)" :: ");
    }

    public static List<String> getBuildNumbersNotToBeDeleted(Run build) {
        ArrayList notToDelete = Lists.newArrayList();
        RunList builds = build.getParent().getBuilds();
        for (Run run : builds) {
            if (!run.isKeepLog()) continue;
            notToDelete.add(String.valueOf(run.getNumber()));
        }
        return notToDelete;
    }

    private static String getBuildNumbersNotToBeDeletedAsString(Run build) {
        StringBuilder builder = new StringBuilder();
        List<String> notToBeDeleted = ExtractorUtils.getBuildNumbersNotToBeDeleted(build);
        for (String notToDelete : notToBeDeleted) {
            builder.append(notToDelete).append(",");
        }
        return builder.toString();
    }

    public static void addBuildRootIfNeeded(AbstractBuild build, ArtifactoryClientConfiguration configuration) throws UnsupportedEncodingException {
        AbstractBuild<?, ?> rootBuild = BuildUniqueIdentifierHelper.getRootBuild(build);
        if (rootBuild != null) {
            String identifier = BuildUniqueIdentifierHelper.getUpstreamIdentifier(rootBuild);
            configuration.info.setBuildRoot(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistConfiguration(ArtifactoryClientConfiguration configuration, Map<String, String> env, FilePath ws, Launcher launcher) throws IOException, InterruptedException {
        FilePath propertiesFile = ws.createTextTempFile("buildInfo", ".properties", "");
        ActionableHelper.deleteFilePathOnExit(propertiesFile);
        configuration.setPropertiesFile(propertiesFile.getRemote());
        env.put("BUILDINFO_PROPFILE", propertiesFile.getRemote());
        env.put("buildInfoConfig.propertiesFile", propertiesFile.getRemote());
        System.setProperty("buildInfoConfig.propertiesFile", propertiesFile.getRemote());
        if (!(ExtractorUtils.getComputer(launcher) instanceof SlaveComputer)) {
            configuration.persistToPropertiesFile();
        } else {
            try {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)configuration.getAllRootConfig());
                properties.putAll((Map<?, ?>)configuration.getAllProperties());
                OutputStream os = propertiesFile.write();
                try {
                    properties.store(os, "");
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String buildPropertiesString(ArrayListMultimap<String, String> properties) {
        StringBuilder props = new StringBuilder();
        ArrayList keys = new ArrayList(properties.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            props.append((String)keys.get(i)).append("=");
            List values = properties.get(keys.get(i));
            for (int j = 0; j < values.size(); ++j) {
                props.append((String)values.get(j));
                if (j == values.size() - 1) continue;
                props.append(",");
            }
            if (i == keys.size() - 1) continue;
            props.append(";");
        }
        return props.toString();
    }

    private static Computer getComputer(Launcher launcher) {
        Computer computer = Computer.currentComputer();
        if (computer != null) {
            return computer;
        }
        return Utils.getCurrentComputer(launcher);
    }

    private static void addDeploymentProperties(PublisherContext context, ArtifactoryClientConfiguration.PublisherHandler publisher, Map<String, String> env) {
        String deploymentProperties = Util.replaceMacro((String)context.getDeploymentProperties(), env);
        ArrayListMultimap params = ArrayListMultimap.create();
        SpecsHelper.fillPropertiesMap((String)deploymentProperties, (ArrayListMultimap)params);
        publisher.addMatrixParams(params);
    }

    private static void addEnvVars(Map<String, String> env, Run<?, ?> build, ArtifactoryClientConfiguration configuration, IncludesExcludes envVarsPatterns, TaskListener listener) {
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(Util.replaceMacro((String)envVarsPatterns.getIncludePatterns(), env), Util.replaceMacro((String)envVarsPatterns.getExcludePatterns(), env));
        MapDifference envDifference = Maps.difference(env, System.getenv());
        Map filteredEnvDifference = envDifference.entriesOnlyOnLeft();
        configuration.info.addBuildVariables(filteredEnvDifference, patterns);
        EnvVars buildVariables = ExtractorUtils.getEnvVars(build, listener);
        SortedMapDifference buildVarDifference = Maps.difference((SortedMap)buildVariables, System.getenv());
        Map filteredBuildVarDifferences = buildVarDifference.entriesOnlyOnLeft();
        configuration.info.addBuildVariables(filteredBuildVarDifferences, patterns);
        configuration.fillFromProperties((Map)buildVariables, patterns);
        for (Map.Entry entry : buildVariables.entrySet()) {
            if (!((String)entry.getKey()).startsWith("artifactory.deploy.")) continue;
            configuration.publisher.addMatrixParam((String)entry.getKey(), (String)entry.getValue());
        }
        MultiConfigurationUtils.addMatrixCombination(build, configuration);
    }

    private static EnvVars getEnvVars(Run<?, ?> build, TaskListener listener) {
        EnvVars buildVariables;
        if (build instanceof AbstractBuild) {
            buildVariables = new EnvVars();
            buildVariables.putAll(((AbstractBuild)build).getBuildVariables());
        } else {
            buildVariables = Utils.extractBuildParameters(build, listener);
        }
        return buildVariables;
    }

    public static String entityToString(HttpEntity entity) throws IOException {
        if (entity != null) {
            InputStream is = entity.getContent();
            return IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        return "";
    }

    public static void validateStringNotBlank(String content) throws IOException {
        if (StringUtils.isBlank((String)content)) {
            throw new IOException("Received empty String.");
        }
    }

    private static boolean isMavenResolutionConfigured(ResolverContext resolverContext) {
        return resolverContext != null && resolverContext.getResolverOverrider() != null && (resolverContext.getResolverOverrider() instanceof ArtifactoryMaven3Configurator || resolverContext.getResolverOverrider() instanceof ArtifactoryMaven3NativeConfigurator || resolverContext.getResolverOverrider() instanceof MavenResolver);
    }

    public static FilePath createAndGetTempDir(Launcher launcher, FilePath ws) throws Exception {
        final FilePath tempDirPath = new FilePath(ws.getParent(), ws.getBaseName() + "@tmp");
        launcher.getChannel().call((Callable)new MasterToSlaveCallable<Boolean, IOException>(){

            public Boolean call() {
                File tempDirFile = new File(tempDirPath.getRemote());
                tempDirFile.mkdir();
                tempDirFile.deleteOnExit();
                return true;
            }
        });
        return tempDirPath;
    }
}

