/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm.perforce;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import java.io.File;
import java.io.IOException;
import org.jfrog.build.vcs.perforce.PerforceClient;
import org.jfrog.hudson.release.scm.AbstractScmManager;

public abstract class AbstractPerforceManager<T extends SCM>
extends AbstractScmManager<T> {
    protected PerforceClient perforce;

    public AbstractPerforceManager(AbstractBuild<?, ?> build, TaskListener buildListener) {
        super(build, buildListener);
    }

    public abstract void prepare() throws IOException, InterruptedException;

    public void commitWorkingCopy(int changeListId, String commitMessage) throws Exception {
        FilePath workspace = this.build.getWorkspace();
        if (workspace == null) {
            throw new IOException("Workspace is null, cannot commit changes");
        }
        this.establishConnection().commitWorkingCopy(changeListId, commitMessage);
    }

    public void createTag(String label, String commitMessage, String changeListId) throws IOException {
        this.perforce.createLabel(label, commitMessage, changeListId);
    }

    public void revertWorkingCopy(int changeListId) throws IOException {
        this.perforce.revertWorkingCopy(changeListId);
    }

    public void deleteLabel(String tagUrl) throws IOException {
        this.perforce.deleteLabel(tagUrl);
    }

    public int createNewChangeList() throws IOException {
        return this.perforce.createNewChangeList();
    }

    public void deleteChangeList(int changeListId) throws IOException {
        this.perforce.deleteChangeList(changeListId);
    }

    public int getDefaultChangeListId() throws IOException {
        return this.perforce.getDefaultChangeListId();
    }

    @Override
    public void commitWorkingCopy(String commitMessage) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Use the overloaded method");
    }

    @Override
    public void createTag(String tagUrl, String commitMessage) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Use the overloaded method");
    }

    @Override
    public String getRemoteUrl(String defaultRemoteUrl) {
        throw new UnsupportedOperationException("Remote URL not supported");
    }

    public void edit(int currentChangeListId, FilePath filePath) throws Exception {
        this.establishConnection().editFile(currentChangeListId, new File(filePath.getRemote()));
    }

    public abstract PerforceClient establishConnection() throws Exception;

    public void closeConnection() throws IOException {
        this.perforce.closeConnection();
    }
}

