/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.promotion;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hudson.model.BuildBadgeAction;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.jfrog.build.api.builder.PromotionBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryPlugin;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.release.PromotionUtils;
import org.jfrog.hudson.release.promotion.LoadBuildsResponse;
import org.jfrog.hudson.release.promotion.PromotionConfig;
import org.jfrog.hudson.release.promotion.PromotionInfo;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class UnifiedPromoteBuildAction
extends TaskAction
implements BuildBadgeAction {
    private final Run build;
    private Map<String, PromotionInfo> promotionCandidates = new HashMap<String, PromotionInfo>();
    private PromotionInfo currentPromotionCandidate;
    private String targetStatus;
    private String targetRepositoryKey;
    private String sourceRepositoryKey;
    private String comment;
    private boolean useCopy;
    private boolean failFast = true;
    private boolean includeDependencies;
    private PluginSettings promotionPlugin;

    public UnifiedPromoteBuildAction(Run build) {
        this.build = build;
    }

    public UnifiedPromoteBuildAction(Run build, BuildInfoAwareConfigurator configurator) {
        this(build);
        String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(configurator, build);
        String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        PromotionConfig promotionConfig = new PromotionConfig();
        promotionConfig.setBuildName(buildName);
        promotionConfig.setBuildNumber(buildNumber);
        this.addPromotionCandidate(promotionConfig, configurator, null);
    }

    public void addPromotionCandidate(PromotionConfig promotionConfig, BuildInfoAwareConfigurator configurator, String displayName) {
        PromotionInfo promotionCandidate = new PromotionInfo(promotionConfig, configurator, this.promotionCandidates.size(), displayName);
        if (this.currentPromotionCandidate == null) {
            this.currentPromotionCandidate = promotionCandidate;
        }
        this.promotionCandidates.put(promotionCandidate.getId(), promotionCandidate);
    }

    private String getCurrentBuildName() {
        return this.currentPromotionCandidate.getBuildName();
    }

    private String getCurrentBuildNumber() {
        return this.currentPromotionCandidate.getBuildNumber();
    }

    private BuildInfoAwareConfigurator getCurrentConfigurator() {
        return this.currentPromotionCandidate.getConfigurator();
    }

    private String getDefaultPromotionTargetRepository() {
        BuildInfoAwareConfigurator configurator = this.getCurrentConfigurator();
        return configurator != null ? configurator.getDefaultPromotionTargetRepository() : "";
    }

    public List<PromotionInfo> getPromotionCandidates() {
        return new ArrayList<PromotionInfo>(this.promotionCandidates.values());
    }

    @JavaScriptMethod
    public LoadBuildsResponse loadBuild(String buildId) {
        LoadBuildsResponse response = new LoadBuildsResponse();
        this.setPromotionPlugin(null);
        try {
            this.currentPromotionCandidate = this.promotionCandidates.get(buildId);
            if (this.currentPromotionCandidate == null) {
                throw new IllegalArgumentException("Can't find build by ID: " + buildId);
            }
            List<String> repositoryKeys = this.getRepositoryKeys();
            List<UserPluginInfo> plugins = this.getPromotionsUserPluginInfo();
            PromotionConfig promotionConfig = this.getPromotionConfig();
            String defaultTargetRepository = this.getDefaultPromotionTargetRepository();
            if (StringUtils.isNotBlank((String)defaultTargetRepository) && repositoryKeys.contains(defaultTargetRepository)) {
                promotionConfig.setTargetRepo(defaultTargetRepository);
            }
            response.addRepositories(repositoryKeys);
            response.setPlugins(plugins);
            response.setPromotionConfig(promotionConfig);
            response.setSuccess(true);
        }
        catch (Exception e) {
            response.setResponseMessage(e.getMessage());
        }
        return response;
    }

    protected Permission getPermission() {
        return ArtifactoryPlugin.PROMOTE;
    }

    public String getIconFileName() {
        return "/plugin/artifactory/images/artifactory-promote.png";
    }

    public String getDisplayName() {
        return "Artifactory Release Promotion";
    }

    public String getUrlName() {
        if (this.hasPromotionPermission()) {
            return "promote";
        }
        return null;
    }

    public boolean hasPromotionPermission() {
        return this.getACL().hasPermission(this.getPermission());
    }

    public Run getBuild() {
        return this.build;
    }

    public void setTargetStatus(String targetStatus) {
        this.targetStatus = targetStatus;
    }

    public void setTargetRepositoryKey(String targetRepositoryKey) {
        this.targetRepositoryKey = targetRepositoryKey;
    }

    public String getSourceRepositoryKey() {
        return this.sourceRepositoryKey;
    }

    public void setSourceRepositoryKey(String sourceRepositoryKey) {
        this.sourceRepositoryKey = sourceRepositoryKey;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setUseCopy(boolean useCopy) {
        this.useCopy = useCopy;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public String getPromotionPluginName() {
        return this.promotionPlugin != null ? this.promotionPlugin.getPluginName() : null;
    }

    public void setPromotionPlugin(PluginSettings promotionPlugin) {
        this.promotionPlugin = promotionPlugin;
    }

    public String getPluginParamValue(String pluginName, String paramKey) {
        return this.promotionPlugin != null ? this.promotionPlugin.getPluginParamValue(pluginName, paramKey) : null;
    }

    public List<String> getTargetStatuses() {
        return Lists.newArrayList((Object[])new String[]{"Released", "Rolled-back"});
    }

    public List<String> getRepositoryKeys() throws IOException {
        BuildInfoAwareConfigurator configurator = this.getCurrentConfigurator();
        if (configurator == null) {
            return Lists.newArrayList();
        }
        ArtifactoryServer artifactoryServer = configurator.getArtifactoryServer();
        if (artifactoryServer == null) {
            return Lists.newArrayList();
        }
        List<String> repos = artifactoryServer.getReleaseRepositoryKeysFirst((DeployerOverrider)((Object)configurator), (Item)this.build.getParent());
        repos.add(0, "");
        return repos;
    }

    public PromotionConfig getPromotionConfig() {
        return this.currentPromotionCandidate.getPromotionConfig();
    }

    public int getPromoteInfoListSize() {
        return this.promotionCandidates.size();
    }

    public String lastPromotionSourceRepository() {
        return this.sourceRepositoryKey;
    }

    public void doIndex(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        req.getView((Object)this, this.chooseAction()).forward((ServletRequest)req, (ServletResponse)resp);
    }

    public void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        String pluginName;
        JSONObject pluginSettings;
        this.getACL().checkPermission(this.getPermission());
        this.bindParameters(req);
        User user = User.current();
        String ciUser = user == null ? "anonymous" : user.getId();
        JSONObject formData = req.getSubmittedForm();
        if (formData.has("promotionPlugin") && (pluginSettings = formData.getJSONObject("promotionPlugin")).has("pluginName") && !"None".equals(pluginName = pluginSettings.getString("pluginName"))) {
            PluginSettings settings = new PluginSettings();
            HashMap paramMap = Maps.newHashMap();
            settings.setPluginName(pluginName);
            Map filteredPluginSettings = Maps.filterKeys((Map)pluginSettings, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return StringUtils.isNotBlank((String)input) && !"pluginName".equals(input);
                }
            });
            for (Map.Entry settingsEntry : filteredPluginSettings.entrySet()) {
                String key = (String)settingsEntry.getKey();
                paramMap.put(key, pluginSettings.getString(key));
            }
            paramMap.put("ciUser", ciUser);
            if (!paramMap.isEmpty()) {
                settings.setParamMap(paramMap);
            }
            this.setPromotionPlugin(settings);
        }
        BuildInfoAwareConfigurator configurator = this.getCurrentConfigurator();
        ArtifactoryServer server = configurator.getArtifactoryServer();
        new PromoteWorkerThread(server, CredentialManager.getPreferredDeployer((DeployerOverrider)((Object)configurator), server), ciUser).start();
        resp.sendRedirect(".");
    }

    private void bindParameters(StaplerRequest req) throws ServletException {
        req.bindParameters((Object)this);
        JSONObject formData = req.getSubmittedForm();
        JSONObject pluginSettings = formData.getJSONObject("promotionPlugin");
        if (pluginSettings.get("includeDependencies") != null) {
            this.setIncludeDependencies(pluginSettings.getBoolean("includeDependencies"));
        }
        if (pluginSettings.get("useCopy") != null) {
            this.setUseCopy(pluginSettings.getBoolean("useCopy"));
        }
        if (pluginSettings.get("failFast") != null) {
            this.setFailFast(pluginSettings.getBoolean("failFast"));
        }
    }

    private List<UserPluginInfo> getPromotionsUserPluginInfo() {
        BuildInfoAwareConfigurator configurator = this.getCurrentConfigurator();
        if (configurator == null) {
            return Lists.newArrayList((Object[])new UserPluginInfo[]{UserPluginInfo.NO_PLUGIN});
        }
        ArtifactoryServer artifactoryServer = configurator.getArtifactoryServer();
        if (artifactoryServer == null) {
            return Lists.newArrayList((Object[])new UserPluginInfo[]{UserPluginInfo.NO_PLUGIN});
        }
        return artifactoryServer.getPromotionsUserPluginInfo((DeployerOverrider)((Object)configurator), (Item)this.build.getParent());
    }

    protected ACL getACL() {
        return this.build.getACL();
    }

    private synchronized String chooseAction() {
        return this.workerThread == null ? "form.jelly" : "progress.jelly";
    }

    public final class PromoteWorkerThread
    extends TaskThread {
        private final ArtifactoryServer artifactoryServer;
        private final CredentialsConfig deployerConfig;
        private final String ciUser;

        PromoteWorkerThread(ArtifactoryServer artifactoryServer, CredentialsConfig deployerConfig, String ciUser) {
            super((TaskAction)UnifiedPromoteBuildAction.this, TaskThread.ListenerAndText.forMemory(null));
            this.artifactoryServer = artifactoryServer;
            this.deployerConfig = deployerConfig;
            this.ciUser = ciUser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void perform(TaskListener listener) {
            try (ArtifactoryBuildInfoClient client = null;){
                long started = System.currentTimeMillis();
                listener.getLogger().println("Promoting build ....");
                client = this.artifactoryServer.createArtifactoryClient(this.deployerConfig.provideUsername((Item)UnifiedPromoteBuildAction.this.build.getParent()), this.deployerConfig.providePassword((Item)UnifiedPromoteBuildAction.this.build.getParent()), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));
                if (UnifiedPromoteBuildAction.this.promotionPlugin != null && !"None".equals(UnifiedPromoteBuildAction.this.promotionPlugin.getPluginName())) {
                    this.handlePluginPromotion(listener, client);
                } else {
                    PromotionBuilder promotionBuilder = new PromotionBuilder().status(UnifiedPromoteBuildAction.this.targetStatus).comment(UnifiedPromoteBuildAction.this.comment).ciUser(this.ciUser).targetRepo(UnifiedPromoteBuildAction.this.targetRepositoryKey).sourceRepo(UnifiedPromoteBuildAction.this.sourceRepositoryKey).dependencies(UnifiedPromoteBuildAction.this.includeDependencies).copy(UnifiedPromoteBuildAction.this.useCopy).failFast(UnifiedPromoteBuildAction.this.failFast);
                    String buildName = UnifiedPromoteBuildAction.this.getCurrentBuildName();
                    String buildNumber = UnifiedPromoteBuildAction.this.getCurrentBuildNumber();
                    PromotionUtils.promoteAndCheckResponse(promotionBuilder.build(), client, listener, buildName, buildNumber);
                }
                UnifiedPromoteBuildAction.this.build.save();
                long timeToWait = 2000L - (System.currentTimeMillis() - started);
                if (timeToWait > 0L) {
                    Thread.sleep(timeToWait);
                }
                UnifiedPromoteBuildAction.this.workerThread = null;
            }
        }

        private void handlePluginPromotion(TaskListener listener, ArtifactoryBuildInfoClient client) throws IOException {
            String buildName = UnifiedPromoteBuildAction.this.getCurrentBuildName();
            String buildNumber = UnifiedPromoteBuildAction.this.getCurrentBuildNumber();
            HttpResponse pluginPromotionResponse = client.executePromotionUserPlugin(UnifiedPromoteBuildAction.this.promotionPlugin.getPluginName(), buildName, buildNumber, UnifiedPromoteBuildAction.this.promotionPlugin.getParamMap());
            if (PromotionUtils.checkSuccess(pluginPromotionResponse, false, UnifiedPromoteBuildAction.this.failFast, false, listener)) {
                listener.getLogger().println("Promotion completed successfully!");
            }
        }
    }
}

