/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types.deployers;

import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.pipeline.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.types.deployers.Deployer;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;

public class MavenDeployer
extends Deployer {
    private String snapshotRepo;
    private String releaseRepo;
    private boolean deployEvenIfUnstable = false;
    public static final MavenDeployer EMPTY_DEPLOYER = MavenDeployer.createEmptyDeployer();

    @Whitelisted
    public String getReleaseRepo() {
        return this.releaseRepo;
    }

    @Whitelisted
    public Deployer setReleaseRepo(String releaseRepo) {
        this.releaseRepo = releaseRepo;
        return this;
    }

    @Whitelisted
    public Deployer setSnapshotRepo(String snapshotRepo) {
        this.snapshotRepo = snapshotRepo;
        return this;
    }

    @Whitelisted
    public String getSnapshotRepo() {
        return this.snapshotRepo;
    }

    @Whitelisted
    public Deployer setDeployEvenIfUnstable(boolean deployEvenIfUnstable) {
        this.deployEvenIfUnstable = deployEvenIfUnstable;
        return this;
    }

    @Whitelisted
    public boolean isDeployEvenIfUnstable() {
        return this.deployEvenIfUnstable;
    }

    @Override
    public ServerDetails getDetails() {
        RepositoryConf snapshotRepositoryConf = new RepositoryConf(this.snapshotRepo, this.snapshotRepo, false);
        RepositoryConf releaesRepositoryConf = new RepositoryConf(this.releaseRepo, this.releaseRepo, false);
        return new ServerDetails(this.server.getServerName(), this.server.getUrl(), releaesRepositoryConf, snapshotRepositoryConf, releaesRepositoryConf, snapshotRepositoryConf, "", "");
    }

    @Override
    public PublisherContext.Builder getContextBuilder() {
        return new PublisherContext.Builder().artifactoryServer(this.getArtifactoryServer()).deployerOverrider(this).serverDetails(this.getDetails()).deployArtifacts(this.isDeployArtifacts()).evenIfUnstable(this.isDeployEvenIfUnstable()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).includeEnvVars(this.isIncludeEnvVars()).skipBuildInfoDeploy(!this.isDeployBuildInfo()).deploymentProperties(ExtractorUtils.buildPropertiesString(this.getProperties())).includesExcludes(this.getArtifactsIncludeExcludeForDeyployment());
    }

    @Override
    public boolean isEmpty() {
        return this.server == null || StringUtils.isEmpty((String)this.releaseRepo) && StringUtils.isEmpty((String)this.snapshotRepo);
    }

    @Override
    public String getTargetRepository(String deployPath) {
        return StringUtils.isNotBlank((String)this.snapshotRepo) && deployPath.contains("-SNAPSHOT") ? this.snapshotRepo : this.releaseRepo;
    }

    private static MavenDeployer createEmptyDeployer() {
        MavenDeployer dummy = new MavenDeployer();
        ArtifactoryServer server = new ArtifactoryServer("http://empty_url", "user", "password");
        dummy.setServer(server);
        dummy.setReleaseRepo("empty_repo");
        dummy.setSnapshotRepo("empty_repo");
        dummy.setDeployArtifacts(false);
        dummy.setDeployEvenIfUnstable(false);
        return dummy;
    }
}

