/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types.deployers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.generic.GenericArtifactsDeployer;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.Filter;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.buildInfo.Env;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;

public abstract class Deployer
implements DeployerOverrider,
Serializable {
    private boolean deployArtifacts = true;
    private boolean includeEnvVars;
    private ArrayListMultimap<String, String> properties = ArrayListMultimap.create();
    private Filter artifactDeploymentPatterns = new Filter();
    private String customBuildName = "";
    private transient CpsScript cpsScript;
    protected transient org.jfrog.hudson.pipeline.types.ArtifactoryServer server;

    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    public Deployer setIncludeEnvVars(boolean includeEnvVars) {
        this.includeEnvVars = includeEnvVars;
        return this;
    }

    public ArtifactoryServer getArtifactoryServer() {
        return Utils.prepareArtifactoryServer(null, this.server);
    }

    @Whitelisted
    public org.jfrog.hudson.pipeline.types.ArtifactoryServer getServer() {
        return this.server;
    }

    @Whitelisted
    public Deployer setServer(org.jfrog.hudson.pipeline.types.ArtifactoryServer server) {
        this.server = server;
        return this;
    }

    @Whitelisted
    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    @Whitelisted
    public Deployer setDeployArtifacts(boolean deployArtifacts) {
        this.deployArtifacts = deployArtifacts;
        return this;
    }

    @Whitelisted
    public Deployer addProperty(String key, String ... values) {
        this.properties.putAll((Object)key, Arrays.asList(values));
        return this;
    }

    public ArrayListMultimap<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return false;
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return null;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        try {
            return this.getArtifactoryServer().getDeployerCredentialsConfig();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Artifactory server is missing.");
        }
    }

    public boolean isDeployBuildInfo() {
        return false;
    }

    @Whitelisted
    public Filter getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    public IncludesExcludes getArtifactsIncludeExcludeForDeyployment() {
        return Utils.getArtifactsIncludeExcludeForDeyployment(this.artifactDeploymentPatterns.getPatternFilter());
    }

    public void createPublisherBuildInfoDetails(BuildInfo buildInfo) {
        if (buildInfo != null) {
            Env buildInfoEnv = buildInfo.getEnv();
            this.setIncludeEnvVars(buildInfoEnv.isCapture());
            this.setCustomBuildName(buildInfo.getName());
        }
    }

    public String getCustomBuildName() {
        return this.customBuildName;
    }

    public void setCustomBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    public abstract ServerDetails getDetails();

    public abstract PublisherContext.Builder getContextBuilder();

    public abstract boolean isEmpty();

    public abstract String getTargetRepository(String var1);

    public CpsScript getCpsScript() {
        return this.cpsScript;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    @Whitelisted
    public void deployArtifacts(BuildInfo buildInfo) throws IOException, InterruptedException {
        LinkedHashMap<String, Serializable> stepVariables = new LinkedHashMap<String, Serializable>();
        stepVariables.put("deployer", this);
        stepVariables.put("buildInfo", buildInfo);
        this.cpsScript.invokeMethod("deployArtifacts", stepVariables);
    }

    public void deployArtifacts(BuildInfo buildInfo, TaskListener listener, FilePath ws) throws IOException, InterruptedException {
        if (buildInfo.getDeployableArtifacts().isEmpty()) {
            listener.getLogger().println("No artifacts for deployment were found");
            return;
        }
        String agentName = Utils.getAgentName(ws);
        if (buildInfo.getAgentName().equals(agentName)) {
            ArtifactoryServer artifactoryServer = Utils.prepareArtifactoryServer(null, this.server);
            Credentials credentials = this.getDeployerCredentialsConfig().getCredentials(null);
            ProxyConfiguration proxy = RepositoriesUtils.createProxyConfiguration(Jenkins.getInstance().proxy);
            Set deploySet = (Set)ws.act((FilePath.FileCallable)new DeployDetailsCallable(buildInfo.getDeployableArtifacts(), listener, this));
            if (deploySet != null && deploySet.size() > 0) {
                ws.act((FilePath.FileCallable)new GenericArtifactsDeployer.FilesDeployerCallable(listener, deploySet, artifactoryServer, credentials, proxy));
            } else if (deploySet == null) {
                throw new RuntimeException("Deployment failed");
            }
        } else {
            throw new RuntimeException("Cannot deploy the files from agent: " + agentName + " since they were built on agent: " + buildInfo.getAgentName());
        }
    }

    public static class DeployDetailsCallable
    extends MasterToSlaveFileCallable<Set<DeployDetails>> {
        private static final String SHA1 = "SHA1";
        private static final String MD5 = "MD5";
        private List<DeployDetails> deployableArtifactsPaths;
        private TaskListener listener;
        private Deployer deployer;

        public DeployDetailsCallable(List<DeployDetails> deployableArtifactsPaths, TaskListener listener, Deployer deployer) {
            this.deployableArtifactsPaths = deployableArtifactsPaths;
            this.listener = listener;
            this.deployer = deployer;
        }

        public Set<DeployDetails> invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            boolean isSuccess = true;
            LinkedHashSet results = Sets.newLinkedHashSet();
            try {
                for (DeployDetails artifact : this.deployableArtifactsPaths) {
                    String artifactPath = artifact.getArtifactPath();
                    if (PatternMatcher.pathConflicts((String)artifactPath, (IncludeExcludePatterns)this.deployer.getArtifactDeploymentPatterns().getPatternFilter())) {
                        this.listener.getLogger().println("Artifactory Deployer: Skipping the deployment of '" + artifactPath + "' due to the defined include-exclude patterns.");
                        continue;
                    }
                    Map checksums = FileChecksumCalculator.calculateChecksums((File)artifact.getFile(), (String[])new String[]{SHA1, MD5});
                    if (!((String)checksums.get(SHA1)).equals(artifact.getSha1())) {
                        this.listener.error("SHA1 mismatch at '" + artifactPath + "' expected: " + artifact.getSha1() + ", got " + (String)checksums.get(SHA1) + ". Make sure that the same artifacts were not built more than once.");
                        isSuccess = false;
                        continue;
                    }
                    DeployDetails.Builder builder = new DeployDetails.Builder().file(artifact.getFile()).artifactPath(artifactPath).targetRepository(this.deployer.getTargetRepository(artifactPath)).md5((String)checksums.get(MD5)).sha1(artifact.getSha1()).addProperties((Multimap)artifact.getProperties()).addProperties(this.deployer.getProperties());
                    results.add(builder.build());
                }
            }
            catch (NoSuchAlgorithmException e) {
                this.listener.error("Could not find checksum algorithm for SHA1 or MD5");
                isSuccess = false;
            }
            return isSuccess ? results : null;
        }
    }
}

