/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types.buildInfo;

import com.google.common.collect.Maps;
import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.buildInfo.EnvFilter;

public class Env
implements Serializable {
    private Map<String, String> envVars = new HashMap<String, String>();
    private Map<String, String> sysVars = new HashMap<String, String>();
    private EnvFilter filter = new EnvFilter();
    private boolean capture = false;
    private transient CpsScript cpsScript;

    public void collectVariables(EnvVars env, Run build, TaskListener listener) throws Exception {
        env.putAll((Map)Utils.extractBuildParameters(build, listener));
        this.addAllWithFilter(this.envVars, (Map<String, String>)env, this.filter.getPatternFilter());
        HashMap<String, String> sysEnv = new HashMap<String, String>();
        Properties systemProperties = System.getProperties();
        Enumeration<?> enumeration = systemProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyKey = (String)enumeration.nextElement();
            sysEnv.put(propertyKey, systemProperties.getProperty(propertyKey));
        }
        this.addAllWithFilter(this.sysVars, sysEnv, this.filter.getPatternFilter());
    }

    protected void append(Env env) {
        this.addAllWithFilter(this.envVars, env.envVars, this.filter.getPatternFilter());
        this.addAllWithFilter(this.sysVars, env.sysVars, this.filter.getPatternFilter());
    }

    private void addAllWithFilter(Map<String, String> toMap, Map<String, String> fromMap, IncludeExcludePatterns pattern) {
        for (Map.Entry<String, String> entry : fromMap.entrySet()) {
            String key = entry.getKey();
            if (PatternMatcher.pathConflicts((String)key, (IncludeExcludePatterns)pattern)) continue;
            toMap.put(key, entry.getValue());
        }
    }

    @Whitelisted
    public Map<String, String> getVars() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.putAll(this.envVars);
        vars.putAll(this.sysVars);
        return vars;
    }

    @Whitelisted
    public void setCapture(boolean capture) {
        this.capture = capture;
    }

    @Whitelisted
    public boolean isCapture() {
        return this.capture;
    }

    @Whitelisted
    public void collect() {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("env", this);
        this.cpsScript.invokeMethod("collectEnv", (Object)stepVariables);
    }

    @Whitelisted
    public EnvFilter getFilter() {
        return this.filter;
    }

    protected Map<String, String> getEnvVars() {
        return this.envVars;
    }

    protected Map<String, String> getSysVars() {
        return this.sysVars;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }
}

