/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types.buildInfo;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class BuildRetention
implements Serializable {
    private boolean deleteBuildArtifacts;
    private int maxBuilds = -1;
    private List<String> doNotDiscardBuilds = Lists.newArrayList();
    private int maxDays = -1;
    private boolean async;

    public org.jfrog.build.api.BuildRetention createBuildRetention() {
        org.jfrog.build.api.BuildRetention buildRetention = new org.jfrog.build.api.BuildRetention();
        buildRetention.setCount(Math.max(this.maxBuilds, -1));
        if (this.maxDays > -1) {
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(5, -1 * this.maxDays);
            buildRetention.setMinimumBuildDate(cal.getTime());
        } else {
            buildRetention.setMinimumBuildDate(null);
        }
        buildRetention.setBuildNumbersNotToBeDiscarded(this.getDoNotDiscardBuilds());
        buildRetention.setDeleteBuildArtifacts(this.deleteBuildArtifacts);
        return buildRetention;
    }

    @Whitelisted
    public void clear() {
        this.maxDays = -1;
        this.deleteBuildArtifacts = false;
        this.maxBuilds = -1;
        this.doNotDiscardBuilds = Lists.newArrayList();
        this.async = false;
    }

    @Whitelisted
    public int getMaxBuilds() {
        return this.maxBuilds;
    }

    @Whitelisted
    public void setMaxBuilds(int maxBuilds) {
        this.maxBuilds = maxBuilds;
    }

    @Whitelisted
    public int getMaxDays() {
        return this.maxDays;
    }

    @Whitelisted
    public void setMaxDays(int days) {
        this.maxDays = days;
    }

    @Whitelisted
    public void setDeleteBuildArtifacts(boolean deleteBuildArtifacts) {
        this.deleteBuildArtifacts = deleteBuildArtifacts;
    }

    @Whitelisted
    public boolean isDeleteBuildArtifacts() {
        return this.deleteBuildArtifacts;
    }

    @Whitelisted
    public void setDoNotDiscardBuilds(List<String> buildNumbersNotToBeDiscarded) {
        if (buildNumbersNotToBeDiscarded == null) {
            this.doNotDiscardBuilds = Lists.newArrayList();
            return;
        }
        this.doNotDiscardBuilds = buildNumbersNotToBeDiscarded;
    }

    @Whitelisted
    public List<String> getDoNotDiscardBuilds() {
        return this.doNotDiscardBuilds;
    }

    @Whitelisted
    public void setAsync(boolean async) {
        this.async = async;
    }

    @Whitelisted
    public boolean isAsync() {
        return this.async;
    }
}

