/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types.buildInfo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.client.DeployableArtifactDetail;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployableArtifactsUtils;
import org.jfrog.hudson.pipeline.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.BuildInfoDeployer;
import org.jfrog.hudson.pipeline.docker.proxy.BuildInfoProxy;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfoAccessor;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildRetention;
import org.jfrog.hudson.pipeline.types.buildInfo.DockerBuildInfoHelper;
import org.jfrog.hudson.pipeline.types.buildInfo.Env;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;

public class BuildInfo
implements Serializable {
    private String buildName;
    private String buildNumber;
    private Date startDate;
    private BuildRetention retention;
    private List<BuildDependency> buildDependencies = Collections.synchronizedList(new ArrayList());
    private List<Artifact> deployedArtifacts = Collections.synchronizedList(new ArrayList());
    private List<DeployDetails> deployableArtifacts = Collections.synchronizedList(new ArrayList());
    private List<Dependency> publishedDependencies = Collections.synchronizedList(new ArrayList());
    private List<Module> modules = Collections.synchronizedList(new ArrayList());
    private Env env = new Env();
    private String agentName;
    private DockerBuildInfoHelper dockerBuildInfoHelper = new DockerBuildInfoHelper(this);

    public BuildInfo(Run build) {
        this.buildName = BuildUniqueIdentifierHelper.getBuildName(build);
        this.buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        this.startDate = Calendar.getInstance().getTime();
        this.retention = new BuildRetention();
    }

    @Whitelisted
    public void setName(String name) {
        this.buildName = name;
    }

    @Whitelisted
    public void setNumber(String number) {
        this.buildNumber = number;
    }

    @Whitelisted
    public String getName() {
        return this.buildName;
    }

    @Whitelisted
    public String getNumber() {
        return this.buildNumber;
    }

    @Whitelisted
    public Date getStartDate() {
        return this.startDate;
    }

    @Whitelisted
    public void setStartDate(Date date) {
        this.startDate = date;
    }

    @Whitelisted
    public void append(BuildInfo other) {
        this.modules.addAll(other.modules);
        this.deployedArtifacts.addAll(other.deployedArtifacts);
        this.deployableArtifacts.addAll(other.deployableArtifacts);
        this.publishedDependencies.addAll(other.publishedDependencies);
        this.buildDependencies.addAll(other.buildDependencies);
        this.dockerBuildInfoHelper.append(other.dockerBuildInfoHelper);
        Env tempEnv = new Env();
        tempEnv.append(this.env);
        tempEnv.append(other.env);
        this.env = tempEnv;
    }

    public void append(Build other) {
        Properties properties = other.getProperties();
        Env otherEnv = new Env();
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                boolean isEnvVar = StringUtils.startsWith((String)key, (String)"buildInfo.env.");
                if (isEnvVar) {
                    otherEnv.getEnvVars().put(StringUtils.substringAfter((String)key, (String)"buildInfo.env."), properties.getProperty(key));
                    continue;
                }
                otherEnv.getSysVars().put(key, properties.getProperty(key));
            }
            this.env.append(otherEnv);
        }
        if (other.getModules() != null) {
            this.modules.addAll(other.getModules());
        }
        if (other.getBuildDependencies() != null) {
            this.buildDependencies.addAll(other.getBuildDependencies());
        }
    }

    @Whitelisted
    public Env getEnv() {
        return this.env;
    }

    @Whitelisted
    public BuildRetention getRetention() {
        return this.retention;
    }

    @Whitelisted
    public void retention(Map<String, Object> retentionArguments) throws Exception {
        Set<String> retentionArgumentsSet = retentionArguments.keySet();
        List<String> keysAsList = Arrays.asList("maxDays", "maxBuilds", "deleteBuildArtifacts", "doNotDiscardBuilds", "async");
        if (!keysAsList.containsAll(retentionArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        this.retention = (BuildRetention)mapper.convertValue(retentionArguments, BuildRetention.class);
    }

    protected void appendDeployedArtifacts(List<Artifact> artifacts) {
        if (artifacts == null) {
            return;
        }
        this.deployedArtifacts.addAll(artifacts);
    }

    public List<DeployDetails> getDeployableArtifacts() {
        return this.deployableArtifacts;
    }

    public void appendDeployableArtifacts(String deployableArtifactsPath, FilePath ws, TaskListener listener) throws IOException, InterruptedException {
        List deployableArtifacts = (List)ws.act((FilePath.FileCallable)new DeployPathsAndPropsCallable(deployableArtifactsPath, listener, this));
        this.deployableArtifacts.addAll(deployableArtifacts);
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    protected void appendBuildDependencies(List<BuildDependency> dependencies) {
        if (dependencies == null) {
            return;
        }
        this.buildDependencies.addAll(dependencies);
    }

    protected void appendPublishedDependencies(List<Dependency> dependencies) {
        if (dependencies == null) {
            return;
        }
        this.publishedDependencies.addAll(dependencies);
    }

    protected List<BuildDependency> getBuildDependencies() {
        return this.buildDependencies;
    }

    protected Map<String, String> getEnvVars() {
        return this.env.getEnvVars();
    }

    protected Map<String, String> getSysVars() {
        return this.env.getSysVars();
    }

    protected BuildInfoDeployer createDeployer(Run build, TaskListener listener, ArtifactoryConfigurator config, ArtifactoryBuildInfoClient client) throws InterruptedException, NoSuchAlgorithmException, IOException {
        if (BuildInfoProxy.isUp()) {
            List<Module> dockerModules = this.dockerBuildInfoHelper.generateBuildInfoModules(build, listener, config);
            this.addDockerBuildInfoModules(dockerModules);
        }
        this.addDefaultModuleToModules(this.buildName);
        return new BuildInfoDeployer(config, client, build, listener, new BuildInfoAccessor(this));
    }

    private void addDockerBuildInfoModules(List<Module> dockerModules) {
        this.modules.addAll(dockerModules);
    }

    private void addDefaultModuleToModules(String moduleId) {
        if (this.deployedArtifacts.isEmpty() && this.publishedDependencies.isEmpty()) {
            return;
        }
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(moduleId).artifacts(this.deployedArtifacts).dependencies(this.publishedDependencies);
        this.modules.add(moduleBuilder.build());
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.env.setCpsScript(cpsScript);
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public static class DeployPathsAndPropsCallable
    extends MasterToSlaveFileCallable<List<DeployDetails>> {
        private String deployableArtifactsPath;
        private TaskListener listener;
        private ArrayListMultimap<String, String> propertiesMap;

        public DeployPathsAndPropsCallable(String deployableArtifactsPath, TaskListener listener, BuildInfo buildInfo) {
            this.deployableArtifactsPath = deployableArtifactsPath;
            this.listener = listener;
            this.propertiesMap = this.getbuildPropertiesMap(buildInfo);
        }

        public List<DeployDetails> invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            try {
                ArrayList<DeployDetails> results = new ArrayList<DeployDetails>();
                ArrayList deployableArtifacts = new ArrayList();
                File deployableArtifactsFile = new File(this.deployableArtifactsPath);
                deployableArtifacts.addAll(DeployableArtifactsUtils.loadDeployableArtifactsFromFile((File)deployableArtifactsFile));
                deployableArtifactsFile.delete();
                for (DeployableArtifactDetail artifact : deployableArtifacts) {
                    DeployDetails.Builder builder = new DeployDetails.Builder().file(new File(artifact.getSourcePath())).artifactPath(artifact.getArtifactDest()).addProperties(this.propertiesMap).targetRepository("empty_repo").sha1(artifact.getSha1());
                    results.add(builder.build());
                }
                return results;
            }
            catch (ClassNotFoundException e) {
                this.listener.getLogger().println(e.getMessage());
                return new ArrayList<DeployDetails>();
            }
        }

        private ArrayListMultimap<String, String> getbuildPropertiesMap(BuildInfo buildInfo) {
            ArrayListMultimap properties = ArrayListMultimap.create();
            properties.put((Object)"build.name", (Object)buildInfo.getName());
            properties.put((Object)"build.number", (Object)buildInfo.getNumber());
            properties.put((Object)"build.timestamp", (Object)(buildInfo.getStartDate().getTime() + ""));
            return properties;
        }
    }
}

