/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.types.deployers.MavenDeployer;
import org.jfrog.hudson.pipeline.types.resolvers.MavenResolver;

public class MavenBuild
implements Serializable {
    private transient CpsScript cpsScript;
    private MavenDeployer deployer = new MavenDeployer();
    private MavenResolver resolver = new MavenResolver();
    private String tool = "";
    private String opts = "";

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    @Whitelisted
    public Deployer getDeployer() {
        return this.deployer;
    }

    @Whitelisted
    public MavenResolver getResolver() {
        return this.resolver;
    }

    @Whitelisted
    public String getTool() {
        return this.tool;
    }

    @Whitelisted
    public void setTool(String tool) {
        this.tool = tool;
    }

    @Whitelisted
    public String getOpts() {
        return this.opts;
    }

    @Whitelisted
    public void setOpts(String opts) {
        this.opts = opts;
    }

    @Whitelisted
    public void run(Map<String, Object> args) {
        if (!args.containsKey("goals") || !args.containsKey("pom")) {
            throw new IllegalArgumentException("pom and goals are mandatory arguments.");
        }
        this.deployer.setCpsScript(this.cpsScript);
        Map<String, Object> stepVariables = this.getExecutionArguments((String)args.get("pom"), (String)args.get("goals"), (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("artifactoryMavenBuild", stepVariables);
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        Set<String> resolverArgumentsSet = resolverArguments.keySet();
        List<String> keysAsList = Arrays.asList("releaseRepo", "snapshotRepo", "server");
        if (!keysAsList.containsAll(resolverArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        Object server = resolverArguments.remove("server");
        JSONObject json = new JSONObject();
        json.putAll(resolverArguments);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readerForUpdating((Object)this.resolver).readValue(json.toString());
        if (server != null) {
            this.resolver.setServer((ArtifactoryServer)server);
        }
    }

    @Whitelisted
    public void deployer(Map<String, Object> deployerArguments) throws Exception {
        Set<String> resolverArgumentsSet = deployerArguments.keySet();
        List<String> keysAsList = Arrays.asList("releaseRepo", "snapshotRepo", "server", "evenIfUnstable", "deployArtifacts", "includeEnvVars");
        if (!keysAsList.containsAll(resolverArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        Object server = deployerArguments.remove("server");
        JSONObject json = new JSONObject();
        json.putAll(deployerArguments);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readerForUpdating((Object)this.deployer).readValue(json.toString());
        if (server != null) {
            this.deployer.setServer((ArtifactoryServer)server);
        }
    }

    private Map<String, Object> getExecutionArguments(String pom, String goals, BuildInfo buildInfo) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("mavenBuild", this);
        stepVariables.put("pom", pom);
        stepVariables.put("goals", goals);
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

