/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.deployers.GradleDeployer;
import org.jfrog.hudson.pipeline.types.resolvers.GradleResolver;

public class GradleBuild
implements Serializable {
    private transient CpsScript cpsScript;
    private GradleDeployer deployer = new GradleDeployer();
    private GradleResolver resolver = new GradleResolver();
    private String tool = "";
    private boolean useWrapper;
    private boolean usesPlugin;

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    @Whitelisted
    public boolean isUsesPlugin() {
        return this.usesPlugin;
    }

    @Whitelisted
    public void setUsesPlugin(boolean usesPlugin) {
        this.usesPlugin = usesPlugin;
    }

    @Whitelisted
    public GradleDeployer getDeployer() {
        return this.deployer;
    }

    @Whitelisted
    public GradleResolver getResolver() {
        return this.resolver;
    }

    @Whitelisted
    public String getTool() {
        return this.tool;
    }

    @Whitelisted
    public void setTool(String tool) {
        this.tool = tool;
    }

    @Whitelisted
    public boolean isUseWrapper() {
        return this.useWrapper;
    }

    @Whitelisted
    public void setUseWrapper(boolean useWrapper) {
        this.useWrapper = useWrapper;
    }

    @Whitelisted
    public void run(Map<String, Object> args) {
        if (!args.containsKey("tasks")) {
            throw new IllegalArgumentException("tasks is a mandatory argument.");
        }
        this.deployer.setCpsScript(this.cpsScript);
        Map<String, Object> stepVariables = this.getRunArguments((String)args.get("buildFile"), (String)args.get("tasks"), (String)args.get("switches"), (String)args.get("rootDir"), (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("ArtifactoryGradleBuild", stepVariables);
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        Set<String> resolverArgumentsSet = resolverArguments.keySet();
        List<String> keysAsList = Arrays.asList("repo", "server");
        if (!keysAsList.containsAll(resolverArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        Object server = resolverArguments.remove("server");
        JSONObject json = new JSONObject();
        json.putAll(resolverArguments);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readerForUpdating((Object)this.resolver).readValue(json.toString());
        if (server != null) {
            this.resolver.setServer((ArtifactoryServer)server);
        }
    }

    @Whitelisted
    public void deployer(Map<String, Object> deployerArguments) throws Exception {
        Set<String> resolverArgumentsSet = deployerArguments.keySet();
        List<String> keysAsList = Arrays.asList("repo", "server", "deployArtifacts", "includeEnvVars", "usesPlugin", "deployMaven", "deployIvy", "ivyPattern", "artifactPattern");
        if (!keysAsList.containsAll(resolverArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        Object server = deployerArguments.remove("server");
        JSONObject json = new JSONObject();
        json.putAll(deployerArguments);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readerForUpdating((Object)this.deployer).readValue(json.toString());
        if (server != null) {
            this.deployer.setServer((ArtifactoryServer)server);
        }
    }

    private Map<String, Object> getRunArguments(String buildFile, String tasks, String switches, String rootDir, BuildInfo buildInfo) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("gradleBuild", this);
        stepVariables.put("rootDir", rootDir);
        stepVariables.put("buildFile", buildFile);
        stepVariables.put("tasks", tasks);
        stepVariables.put("switches", switches);
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

