/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;

public class Docker
implements Serializable {
    private transient CpsScript cpsScript;
    private String username;
    private String password;
    private String credentialsId;
    private String host;
    private ArrayListMultimap<String, String> properties = ArrayListMultimap.create();
    private ArtifactoryServer server;

    public Docker() {
    }

    public Docker(CpsScript script, String username, String password, String credentialsId, String host) {
        this.cpsScript = script;
        this.username = username;
        this.password = password;
        this.credentialsId = credentialsId;
        this.host = host;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setServer(ArtifactoryServer server) {
        this.server = server;
    }

    @Whitelisted
    public Docker addProperty(String key, String ... values) {
        this.properties.putAll((Object)key, Arrays.asList(values));
        return this;
    }

    @Whitelisted
    public void push(String imageTag, String targetRepository) {
        this.push(imageTag, targetRepository, null);
    }

    @Whitelisted
    public void push(String imageTag, String targetRepository, BuildInfo providedBuildInfo) {
        LinkedHashMap dockerArguments = Maps.newLinkedHashMap();
        dockerArguments.put("image", imageTag);
        dockerArguments.put("targetRepo", targetRepository);
        dockerArguments.put("buildInfo", providedBuildInfo);
        this.push(dockerArguments);
    }

    @Whitelisted
    public void push(Map<String, Object> dockerArguments) {
        CredentialsConfig credentialsConfig = new CredentialsConfig(this.username, this.password, this.credentialsId);
        dockerArguments.put("credentialsConfig", credentialsConfig);
        dockerArguments.put("host", this.host);
        dockerArguments.put("properties", this.properties);
        dockerArguments.put("server", this.server);
        Utils.appendBuildInfo(this.cpsScript, dockerArguments);
        if (this.server != null) {
            this.cpsScript.invokeMethod("dockerPushStep", dockerArguments);
        } else {
            this.cpsScript.invokeMethod("dockerPushWithProxyStep", dockerArguments);
        }
    }

    @Whitelisted
    public void pull(String imageTag) {
        this.pull(imageTag, null);
    }

    @Whitelisted
    public void pull(String imageTag, BuildInfo providedBuildInfo) {
        LinkedHashMap pullVariables = Maps.newLinkedHashMap();
        pullVariables.put("image", imageTag);
        pullVariables.put("buildInfo", providedBuildInfo);
        this.pull(pullVariables);
    }

    @Whitelisted
    public void pull(Map<String, Object> dockerArguments) {
        CredentialsConfig credentialsConfig = new CredentialsConfig(this.username, this.password, this.credentialsId);
        dockerArguments.put("credentialsConfig", credentialsConfig);
        dockerArguments.put("host", this.host);
        Utils.appendBuildInfo(this.cpsScript, dockerArguments);
        this.cpsScript.invokeMethod("dockerPullStep", dockerArguments);
    }
}

