/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.Connection;
import org.jfrog.hudson.pipeline.types.XrayScanConfig;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;

public class ArtifactoryServer
implements Serializable {
    public static final String SPEC = "spec";
    public static final String SERVER = "server";
    public static final String BUILD_NAME = "buildName";
    public static final String BUILD_NUMBER = "buildNumber";
    private String serverName;
    private String url;
    private String username;
    private String password;
    private String credentialsId;
    private boolean bypassProxy;
    private transient CpsScript cpsScript;
    private boolean usesCredentialsId;
    private Connection connection = new Connection();

    public ArtifactoryServer() {
    }

    public ArtifactoryServer(String artifactoryServerName, String url, String username, String password) {
        this.serverName = artifactoryServerName;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public ArtifactoryServer(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public ArtifactoryServer(String url, String credentialsId) {
        this.url = url;
        this.credentialsId = credentialsId;
        this.usesCredentialsId = true;
    }

    public CredentialsConfig createCredentialsConfig() {
        CredentialsConfig credentialsConfig = new CredentialsConfig(this.username, this.password, this.credentialsId, null);
        credentialsConfig.setIgnoreCredentialPluginDisabled(this.usesCredentialsId);
        return credentialsConfig;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    @Whitelisted
    public void download(String spec) {
        this.download(spec, null);
    }

    private Map<String, Object> getDownloadUploadObjectMap(Map<String, Object> arguments) {
        if (!arguments.containsKey(SPEC)) {
            throw new IllegalArgumentException("spec is a mandatory arguments");
        }
        List<String> keysAsList = Arrays.asList(SPEC, "buildInfo");
        if (!keysAsList.containsAll(arguments.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed, " + keysAsList.toString());
        }
        LinkedHashMap stepVariables = Maps.newLinkedHashMap(arguments);
        stepVariables.put(SERVER, this);
        return stepVariables;
    }

    @Whitelisted
    public void download(String spec, BuildInfo providedBuildInfo) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(SPEC, spec);
        stepVariables.put("buildInfo", providedBuildInfo);
        stepVariables.put(SERVER, this);
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("artifactoryDownload", (Object)stepVariables);
    }

    @Whitelisted
    public void download(Map<String, Object> downloadArguments) {
        Map<String, Object> stepVariables = this.getDownloadUploadObjectMap(downloadArguments);
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("artifactoryDownload", stepVariables);
    }

    @Whitelisted
    public void upload(String spec) {
        this.upload(spec, null);
    }

    @Whitelisted
    public void upload(Map<String, Object> uploadArguments) {
        Map<String, Object> stepVariables = this.getDownloadUploadObjectMap(uploadArguments);
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("artifactoryUpload", stepVariables);
    }

    @Whitelisted
    public void upload(String spec, BuildInfo buildInfo) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(SPEC, spec);
        stepVariables.put("buildInfo", buildInfo);
        stepVariables.put(SERVER, this);
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("artifactoryUpload", (Object)stepVariables);
    }

    @Whitelisted
    public void publishBuildInfo(BuildInfo buildInfo) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("buildInfo", buildInfo);
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("publishBuildInfo", (Object)stepVariables);
    }

    @Whitelisted
    public void promote(Map<String, Object> promotionParams) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("promotionConfig", Utils.createPromotionConfig(promotionParams, true));
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("artifactoryPromoteBuild", (Object)stepVariables);
    }

    @Whitelisted
    public void distribute(Map<String, Object> distributionParams) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("distributionConfig", Utils.createDistributionConfig(distributionParams));
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("artifactoryDistributeBuild", (Object)stepVariables);
    }

    @Whitelisted
    public void xrayScan(Map<String, Object> xrayScanParams) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("xrayScanConfig", this.createXrayScanConfig(xrayScanParams));
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("xrayScanBuild", (Object)stepVariables);
    }

    private XrayScanConfig createXrayScanConfig(Map<String, Object> xrayScanParams) {
        String failBuild = "failBuild";
        List<String> mandatoryArgumentsAsList = Arrays.asList(BUILD_NAME, BUILD_NAME);
        if (!xrayScanParams.keySet().containsAll(mandatoryArgumentsAsList)) {
            throw new IllegalArgumentException(mandatoryArgumentsAsList.toString() + " are mandatory arguments");
        }
        Set<String> xrayScanParamsSet = xrayScanParams.keySet();
        List<String> keysAsList = Arrays.asList(BUILD_NAME, BUILD_NUMBER, "failBuild");
        if (!keysAsList.containsAll(xrayScanParamsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        return new XrayScanConfig((String)xrayScanParams.get(BUILD_NAME), (String)xrayScanParams.get(BUILD_NUMBER), (Boolean)xrayScanParams.get("failBuild"));
    }

    public String getServerName() {
        return this.serverName;
    }

    @Whitelisted
    public String getUrl() {
        return this.url;
    }

    @Whitelisted
    public void setUrl(String url) {
        this.url = url;
    }

    @Whitelisted
    public String getUsername() {
        return this.username;
    }

    @Whitelisted
    public void setUsername(String username) {
        this.username = username;
        this.credentialsId = "";
        this.usesCredentialsId = false;
    }

    @Whitelisted
    public void setPassword(String password) {
        this.password = password;
        this.credentialsId = "";
        this.usesCredentialsId = false;
    }

    public String getPassword() {
        return this.password;
    }

    @Whitelisted
    public void setBypassProxy(boolean bypassProxy) {
        this.bypassProxy = bypassProxy;
    }

    @Whitelisted
    public boolean isBypassProxy() {
        return this.bypassProxy;
    }

    @Whitelisted
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Whitelisted
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
        this.password = "";
        this.username = "";
        this.usesCredentialsId = true;
    }

    @Whitelisted
    public Connection getConnection() {
        return this.connection;
    }
}

