/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps.conan;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.build.api.Build;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.ExtractorUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunCommandStep
extends AbstractStepImpl {
    private String command;
    private String conanHome;
    private String buildLogPath;
    private BuildInfo buildInfo;

    @DataBoundConstructor
    public RunCommandStep(String command, String conanHome, String buildLogPath, BuildInfo buildInfo) {
        this.command = command;
        this.conanHome = conanHome;
        this.buildInfo = buildInfo;
        this.buildLogPath = buildLogPath;
    }

    public String getCommand() {
        return this.command;
    }

    public String getConanHome() {
        return this.conanHome;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getBuildLogPath() {
        return this.buildLogPath;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "runConanCommand";
        }

        public String getDisplayName() {
            return "Run a Conan command";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @Inject(optional=true)
        private transient RunCommandStep step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;

        protected BuildInfo run() throws Exception {
            BuildInfo buildInfo = Utils.prepareBuildinfo(this.build, this.step.getBuildInfo());
            FilePath conanHomeDirectory = new FilePath(this.launcher.getChannel(), this.step.getConanHome());
            this.persistBuildProperties(buildInfo, conanHomeDirectory);
            EnvVars extendedEnv = new EnvVars(this.env);
            extendedEnv.put("CONAN_USER_HOME", this.step.getConanHome());
            this.execConanCommand(extendedEnv);
            FilePath logFilePath = this.execConanCollectBuildInfo(extendedEnv);
            Build regularBuildInfo = Utils.getGeneratedBuildInfo(this.build, this.listener, this.launcher, logFilePath.getRemote());
            buildInfo.append(regularBuildInfo);
            return buildInfo;
        }

        private FilePath execConanCollectBuildInfo(EnvVars extendedEnv) throws Exception {
            FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.launcher, this.ws);
            FilePath logFilePath = tempDir.createTextTempFile("conan", "build-info", "", true);
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add("conan_build_info");
            args.add(this.step.getBuildLogPath());
            args.add("--output");
            args.add(logFilePath.getRemote());
            Utils.exeConan(args, this.ws, this.launcher, this.listener, this.build, extendedEnv);
            return logFilePath;
        }

        private void execConanCommand(EnvVars extendedEnv) {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add("conan");
            args.addTokenized(this.step.getCommand());
            Utils.exeConan(args, this.ws, this.launcher, this.listener, this.build, extendedEnv);
        }

        private void persistBuildProperties(BuildInfo buildInfo, FilePath conanHomeDirectory) throws IOException, InterruptedException {
            FilePath buildProperties = new FilePath(conanHomeDirectory, ".conan").child("artifacts.properties");
            final String buildName = buildInfo.getName();
            final String buildNumber = buildInfo.getNumber();
            final String revision = Utils.extractVcsRevision(this.ws);
            final long startTime = buildInfo.getStartDate().getTime();
            buildProperties.touch(0L);
            buildProperties.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Boolean invoke(File conanProperties, VirtualChannel channel) throws IOException, InterruptedException {
                    String propsPrefix = "artifact_property_";
                    Properties props = new Properties();
                    props.setProperty("artifact_property_build.name", buildName);
                    props.setProperty("artifact_property_build.number", buildNumber);
                    props.setProperty("artifact_property_build.timestamp", String.valueOf(startTime));
                    if (StringUtils.isNotEmpty((String)revision)) {
                        props.setProperty("artifact_property_vcs.revision", revision);
                    }
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(conanProperties.getCanonicalFile());
                        props.store(fos, "Build properties");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fos);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)fos);
                    return true;
                }
            });
        }
    }
}

