/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps.conan;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.ConanClient;
import org.jfrog.hudson.util.ExtractorUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class InitConanClientStep
extends AbstractStepImpl {
    private ConanClient client;

    @DataBoundConstructor
    public InitConanClientStep(ConanClient client) {
        this.client = client;
    }

    public ConanClient getClient() {
        return this.client;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "initConanClient";
        }

        public String getDisplayName() {
            return "Create Conan Client";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @Inject(optional=true)
        private transient InitConanClientStep step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;

        protected Boolean run() throws Exception {
            ConanClient conanClient = this.getConanClient();
            EnvVars extendedEnv = new EnvVars(this.env);
            extendedEnv.put("CONAN_USER_HOME", conanClient.getUserPath());
            ArgumentListBuilder args = new ArgumentListBuilder();
            String logFilePath = conanClient.getLogFilePath();
            args.addTokenized("conan config set");
            args.add("log.trace_file=\"" + StringUtils.trim((String)logFilePath) + "\"");
            Utils.exeConan(args, this.ws, this.launcher, this.listener, this.build, extendedEnv);
            return true;
        }

        private ConanClient getConanClient() throws Exception {
            FilePath conanHomeDirectory;
            ConanClient conanClient = this.step.getClient();
            if (StringUtils.isEmpty((String)conanClient.getUserPath())) {
                conanHomeDirectory = this.env.containsKey((Object)"CONAN_USER_HOME") ? new FilePath(new File((String)this.env.get((Object)"CONAN_USER_HOME"))) : this.createConanTempHome();
            } else {
                conanHomeDirectory = new FilePath(this.launcher.getChannel(), conanClient.getUserPath());
                if (!conanHomeDirectory.exists()) {
                    conanHomeDirectory.mkdirs();
                }
            }
            conanClient.setUserPath(conanHomeDirectory.getRemote());
            conanHomeDirectory.child("conan_log.log").touch(Calendar.getInstance().getTimeInMillis());
            return conanClient;
        }

        private FilePath createConanTempHome() throws Exception {
            FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.launcher, this.ws);
            return tempDir.createTempDir("conan", "");
        }
    }
}

