/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfoAccessor;
import org.kohsuke.stapler.DataBoundConstructor;

public class PublishBuildInfoStep
extends AbstractStepImpl {
    private BuildInfo buildInfo;
    private org.jfrog.hudson.pipeline.types.ArtifactoryServer server;

    @DataBoundConstructor
    public PublishBuildInfoStep(BuildInfo buildInfo, org.jfrog.hudson.pipeline.types.ArtifactoryServer server) {
        this.buildInfo = buildInfo;
        this.server = server;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public org.jfrog.hudson.pipeline.types.ArtifactoryServer getServer() {
        return this.server;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "publishBuildInfo";
        }

        public String getDisplayName() {
            return "Publish build Info to Artifactory";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @Inject(optional=true)
        private transient PublishBuildInfoStep step;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean run() throws Exception {
            BuildInfoAccessor buildInfo = new BuildInfoAccessor(this.step.getBuildInfo());
            ArtifactoryServer server = Utils.prepareArtifactoryServer(null, this.step.getServer());
            try (ArtifactoryBuildInfoClient client = buildInfo.createArtifactoryClient(server, this.build, this.listener);){
                buildInfo.createDeployer(this.build, this.listener, server, client).deploy();
            }
            return true;
        }
    }
}

