/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.executors.PromotionExecutor;
import org.jfrog.hudson.pipeline.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.types.PromotionConfig;
import org.kohsuke.stapler.DataBoundConstructor;

public class PromoteBuildStep
extends AbstractStepImpl {
    private ArtifactoryServer server;
    private PromotionConfig promotionConfig;

    @DataBoundConstructor
    public PromoteBuildStep(PromotionConfig promotionConfig, ArtifactoryServer server) {
        this.promotionConfig = promotionConfig;
        this.server = server;
    }

    public ArtifactoryServer getServer() {
        return this.server;
    }

    public PromotionConfig getPromotionConfig() {
        return this.promotionConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "artifactoryPromoteBuild";
        }

        public String getDisplayName() {
            return "Promote build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @Inject(optional=true)
        private transient PromoteBuildStep step;

        protected Boolean run() throws Exception {
            PromotionConfig promotionConfig = this.step.getPromotionConfig();
            if (StringUtils.isEmpty((String)promotionConfig.getBuildName())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Promotion build name is mandatory"));
                return false;
            }
            if (StringUtils.isEmpty((String)promotionConfig.getBuildNumber())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Promotion build number is mandatory"));
                return false;
            }
            if (StringUtils.isEmpty((String)promotionConfig.getTargetRepo())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Promotion target repository is mandatory"));
                return false;
            }
            new PromotionExecutor(Utils.prepareArtifactoryServer(null, this.step.getServer()), this.build, this.listener, this.getContext(), promotionConfig).execution();
            return true;
        }
    }
}

