/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.remoting.Callable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.build.extractor.maven.reader.ModuleName;
import org.jfrog.build.extractor.maven.transformer.PomTransformer;
import org.kohsuke.stapler.DataBoundConstructor;

public class MavenDescriptorStep
extends AbstractStepImpl {
    private String pomFile = "pom.xml";
    private String version = "";
    private Map<String, String> versionPerModule = new HashedMap();
    private boolean failOnSnapshot;
    private boolean dryRun;

    @DataBoundConstructor
    public MavenDescriptorStep(String pomFile, String version, Map<String, String> versionPerModule, boolean failOnSnapshot, boolean dryRun) {
        this.pomFile = pomFile;
        this.version = version;
        this.versionPerModule = versionPerModule;
        this.failOnSnapshot = failOnSnapshot;
        this.dryRun = dryRun;
    }

    public String getPomFile() {
        return this.pomFile;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isFailOnSnapshot() {
        return this.failOnSnapshot;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public Map<String, String> getVersionPerModule() {
        return this.versionPerModule;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "MavenDescriptorStep";
        }

        public String getDisplayName() {
            return "Get Artifactory Maven descriptor";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient MavenDescriptorStep step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Launcher launcher;
        private String pomFile;
        private boolean failOnSnapshot;
        private boolean dryRun;
        private String version = "";
        private Map<String, String> versionPerModule = new HashedMap();

        protected Boolean run() throws Exception {
            this.pomFile = new FilePath(this.ws, this.step.getPomFile()).getRemote();
            this.failOnSnapshot = this.step.isFailOnSnapshot();
            this.dryRun = this.step.isDryRun();
            this.version = this.step.getVersion();
            this.versionPerModule = this.step.getVersionPerModule();
            Boolean call = (Boolean)this.launcher.getChannel().call((Callable)new MasterToSlaveCallable<Boolean, IOException>(){

                public Boolean call() throws IOException {
                    return Execution.this.transformPoms();
                }
            });
            return call;
        }

        public boolean transformPoms() {
            String filePath = "";
            String fileName = this.pomFile;
            int index = StringUtils.lastIndexOf((String)this.pomFile, (String)File.separator);
            if (index > 0) {
                filePath = StringUtils.substring((String)this.pomFile, (int)0, (int)(index + 1));
                fileName = StringUtils.substring((String)this.pomFile, (int)(index + 1));
            }
            HashedMap modules = new HashedMap();
            HashedMap modulesVersion = new HashedMap();
            this.findPomModules(filePath, fileName, (Map<ModuleName, String>)modules);
            return this.execTransformtion((Map<ModuleName, String>)modules, (Map<ModuleName, String>)modulesVersion);
        }

        private boolean execTransformtion(Map<ModuleName, String> modules, Map<ModuleName, String> modulesVersion) {
            boolean isTransformed = false;
            for (Map.Entry<ModuleName, String> module : modules.entrySet()) {
                modulesVersion.put(module.getKey(), this.getModuleVersion(module.getKey()));
            }
            for (Map.Entry<ModuleName, String> module : modules.entrySet()) {
                PomTransformer pomTransformer = new PomTransformer(module.getKey(), modulesVersion, null, this.failOnSnapshot, this.dryRun);
                try {
                    isTransformed |= pomTransformer.transform(new File(module.getValue())).booleanValue();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return isTransformed;
        }

        private void findPomModules(String filePath, String fileName, Map<ModuleName, String> result) {
            String artifactId;
            Model model;
            String pomPath = filePath + fileName;
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(pomPath));
                MavenXpp3Reader reader = new MavenXpp3Reader();
                model = reader.read((Reader)in);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            String parentGroupId = null;
            String parentArtifactId = null;
            if (model.getParent() != null) {
                parentArtifactId = model.getParent().getArtifactId();
                parentGroupId = model.getParent().getGroupId();
            }
            String groupId = model.getGroupId() != null ? model.getGroupId() : parentGroupId;
            String string = artifactId = model.getArtifactId() != null ? model.getArtifactId() : parentArtifactId;
            if (groupId == null || artifactId == null) {
                throw new IllegalStateException("artifactId and/or groupId could not be found in POM file: " + pomPath);
            }
            result.put(new ModuleName(groupId, artifactId), pomPath);
            List modules = model.getModules();
            for (String module : modules) {
                String tempFilePath = StringUtils.endsWith((String)filePath, (String)File.separator) ? filePath + module + File.separator : filePath + File.separator + module + File.separator;
                this.findPomModules(tempFilePath, "pom.xml", result);
            }
        }

        private String getModuleVersion(ModuleName module) {
            String moduleIdentifier = module.getGroupId() + ":" + module.getArtifactId();
            String version = this.versionPerModule.get(moduleIdentifier);
            if (StringUtils.isNotEmpty((String)version)) {
                return version;
            }
            if (StringUtils.isEmpty((String)this.version)) {
                throw new RuntimeException("Can't find version for module" + moduleIdentifier + ".");
            }
            return this.version;
        }
    }
}

