/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.acls.NotFoundException;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetArtifactoryServerStep
extends AbstractStepImpl {
    private String artifactoryServerID;

    @DataBoundConstructor
    public GetArtifactoryServerStep(String artifactoryServerID) {
        this.artifactoryServerID = artifactoryServerID;
    }

    public String getArtifactoryServerID() {
        return this.artifactoryServerID;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "getArtifactoryServer";
        }

        public String getDisplayName() {
            return "Get Artifactory server from Jenkins config";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<org.jfrog.hudson.pipeline.types.ArtifactoryServer> {
        @StepContextParameter
        private transient Run build;
        @Inject(optional=true)
        private transient GetArtifactoryServerStep step;
        private static final long serialVersionUID = 1L;

        protected org.jfrog.hudson.pipeline.types.ArtifactoryServer run() throws Exception {
            String artifactoryServerID = this.step.getArtifactoryServerID();
            if (StringUtils.isEmpty((String)artifactoryServerID)) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Artifactory server name is mandatory"));
            }
            ArrayList<ArtifactoryServer> artifactoryServers = new ArrayList<ArtifactoryServer>();
            List<ArtifactoryServer> artifactoryConfiguredServers = RepositoriesUtils.getArtifactoryServers();
            if (artifactoryConfiguredServers == null) {
                this.getContext().onFailure((Throwable)new NotFoundException("No Artifactory servers were configured"));
            }
            for (ArtifactoryServer server : artifactoryConfiguredServers) {
                if (!server.getName().equals(artifactoryServerID)) continue;
                artifactoryServers.add(server);
            }
            if (artifactoryServers.isEmpty()) {
                this.getContext().onFailure((Throwable)new NotFoundException("Couldn't find Artifactory named: " + artifactoryServerID));
            }
            if (artifactoryServers.size() > 1) {
                throw new RuntimeException("Duplicate Artifactory name: " + artifactoryServerID);
            }
            ArtifactoryServer server = (ArtifactoryServer)artifactoryServers.get(0);
            org.jfrog.hudson.pipeline.types.ArtifactoryServer artifactoryPipelineServer = new org.jfrog.hudson.pipeline.types.ArtifactoryServer(artifactoryServerID, server.getUrl(), server.getResolvingCredentialsConfig().provideUsername((Item)this.build.getParent()), server.getResolvingCredentialsConfig().providePassword((Item)this.build.getParent()));
            artifactoryPipelineServer.setBypassProxy(server.isBypassProxy());
            artifactoryPipelineServer.getConnection().setRetry(server.getConnectionRetry());
            artifactoryPipelineServer.getConnection().setTimeout(server.getTimeout());
            return artifactoryPipelineServer;
        }
    }
}

