/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.cli.MissingArgumentException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.docker.proxy.BuildInfoProxy;
import org.jfrog.hudson.pipeline.docker.utils.DockerAgentUtils;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerPushWithProxyStep
extends AbstractStepImpl {
    private final String image;
    private CredentialsConfig credentialsConfig;
    private String host;
    private BuildInfo buildInfo;
    private String targetRepo;
    private ArrayListMultimap<String, String> properties;

    @DataBoundConstructor
    public DockerPushWithProxyStep(String image, CredentialsConfig credentialsConfig, String host, String targetRepo, BuildInfo buildInfo, ArrayListMultimap<String, String> properties) {
        this.image = image;
        this.credentialsConfig = credentialsConfig;
        this.host = host;
        this.targetRepo = targetRepo;
        this.buildInfo = buildInfo;
        this.properties = properties;
    }

    public String getImage() {
        return this.image;
    }

    public ArrayListMultimap<String, String> getProperties() {
        return this.properties;
    }

    public CredentialsConfig getCredentialsConfig() {
        return this.credentialsConfig;
    }

    public String getHost() {
        return this.host;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getTargetRepo() {
        return this.targetRepo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "dockerPushWithProxyStep";
        }

        public String getDisplayName() {
            return "Artifactory docker push";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient DockerPushWithProxyStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient FilePath ws;

        protected BuildInfo run() throws Exception {
            if (!BuildInfoProxy.isUp()) {
                this.getContext().onFailure((Throwable)new RuntimeException("Build info capturing for Docker images is not available while Artifactory proxy is not running, enable the proxy in Jenkins configuration."));
                return null;
            }
            if (this.step.getImage() == null) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Missing 'image' parameter"));
                return null;
            }
            if (this.step.getTargetRepo() == null) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Missing 'targetRepo' parameter"));
                return null;
            }
            BuildInfo buildInfo = Utils.prepareBuildinfo(this.build, this.step.getBuildInfo());
            DockerAgentUtils.registerImagOnAgents(this.launcher, this.step.getImage(), this.step.getHost(), this.step.getTargetRepo(), this.step.getProperties(), buildInfo.hashCode());
            String username = this.step.getCredentialsConfig().provideUsername((Item)this.build.getParent());
            String password = this.step.getCredentialsConfig().providePassword((Item)this.build.getParent());
            JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
            String deprecationMessage = "It looks like you are using the following deprecated signature of creating Artifactory.docker instance:\n    def rtDocker = Artifactory.docker [credentialsId: 'credentialsId'], [host: 'tcp://<daemon IP>:<daemon port>']\nPlease use the following signature of the method, adding the Artifactory server as argument:\n    def rtDocker = Artifactory.docker <server: server>, [host: 'tcp://<daemon IP>:<daemon port>']\nThe new method signature does not require setting up the Build-Info Proxy.";
            log.warn(deprecationMessage);
            DockerAgentUtils.pushImage(this.launcher, log, this.step.getImage(), username, password, this.step.getHost());
            if (!DockerAgentUtils.updateImageParentOnAgents(log, this.step.getImage(), this.step.getHost(), buildInfo.hashCode())) {
                this.getContext().onFailure((Throwable)new IllegalStateException("Build info capturing failed for docker image: " + this.step.getImage() + " check build info proxy configuration."));
                return null;
            }
            log.info("Successfully pushed docker image: " + this.step.getImage());
            return buildInfo;
        }
    }
}

