/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.cli.MissingArgumentException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.docker.utils.DockerAgentUtils;
import org.jfrog.hudson.pipeline.docker.utils.DockerUtils;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerPullStep
extends AbstractStepImpl {
    private final String image;
    private CredentialsConfig credentialsConfig;
    private String host;
    private final BuildInfo buildInfo;

    @DataBoundConstructor
    public DockerPullStep(String image, CredentialsConfig credentialsConfig, String host, BuildInfo buildInfo) {
        this.image = image;
        this.credentialsConfig = credentialsConfig;
        this.host = host;
        this.buildInfo = buildInfo;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getImage() {
        return this.image;
    }

    public CredentialsConfig getCredentialsConfig() {
        return this.credentialsConfig;
    }

    public String getHost() {
        return this.host;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "dockerPullStep";
        }

        public String getDisplayName() {
            return "Artifactory docker pull";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient DockerPullStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient FilePath ws;

        protected BuildInfo run() throws Exception {
            if (this.step.getImage() == null) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Missing 'image' parameter"));
                return null;
            }
            BuildInfo buildInfo = Utils.prepareBuildinfo(this.build, this.step.getBuildInfo());
            String imageTag = this.step.getImage();
            if (!DockerUtils.isImageVersioned(imageTag).booleanValue()) {
                imageTag = imageTag + ":latest";
            }
            String username = this.step.getCredentialsConfig().provideUsername((Item)this.build.getParent());
            String password = this.step.getCredentialsConfig().providePassword((Item)this.build.getParent());
            DockerAgentUtils.pullImage(this.launcher, imageTag, username, password, this.step.getHost());
            JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
            log.info("Successfully pulled docker image: " + imageTag);
            return buildInfo;
        }
    }
}

