/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.maven3.Maven3Builder;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.executors.MavenGradleEnvExtractor;
import org.jfrog.hudson.pipeline.types.MavenBuild;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.types.deployers.MavenDeployer;
import org.jfrog.hudson.util.ExtractorUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArtifactoryMavenBuild
extends AbstractStepImpl {
    private MavenBuild mavenBuild;
    private String goal;
    private String pom;
    private BuildInfo buildInfo;

    @DataBoundConstructor
    public ArtifactoryMavenBuild(MavenBuild mavenBuild, String pom, String goals, BuildInfo buildInfo) {
        this.mavenBuild = mavenBuild;
        this.goal = goals == null ? "" : goals;
        this.pom = pom == null ? "" : pom;
        this.buildInfo = buildInfo;
    }

    public MavenBuild getMavenBuild() {
        return this.mavenBuild;
    }

    public String getGoal() {
        return this.goal;
    }

    public String getPom() {
        return this.pom;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "artifactoryMavenBuild";
        }

        public String getDisplayName() {
            return "run Artifactory maven";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @Inject(optional=true)
        private transient ArtifactoryMavenBuild step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;
        private transient EnvVars extendedEnv;

        protected BuildInfo run() throws Exception {
            BuildInfo buildInfo = Utils.prepareBuildinfo(this.build, this.step.getBuildInfo());
            Deployer deployer = this.getDeployer();
            deployer.createPublisherBuildInfoDetails(buildInfo);
            String revision = Utils.extractVcsRevision(new FilePath(this.ws, this.step.getPom()));
            this.extendedEnv = new EnvVars(this.env);
            this.extendedEnv.put("GIT_COMMIT", revision);
            MavenGradleEnvExtractor envExtractor = new MavenGradleEnvExtractor(this.build, buildInfo, deployer, this.step.getMavenBuild().getResolver(), this.listener, this.launcher);
            FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.launcher, this.ws);
            envExtractor.buildEnvVars(tempDir, this.extendedEnv);
            String stepOpts = this.step.getMavenBuild().getOpts();
            String mavenOpts = stepOpts + (this.extendedEnv.get((Object)"MAVEN_OPTS") != null ? (stepOpts.length() > 0 ? " " : "") + (String)this.extendedEnv.get((Object)"MAVEN_OPTS") : "");
            mavenOpts = mavenOpts.replaceAll("[\t\r\n]+", " ");
            if (!this.step.getMavenBuild().getResolver().isEmpty()) {
                this.extendedEnv.put("buildInfoConfig.artifactoryResolutionEnabled", Boolean.TRUE.toString());
            }
            Maven3Builder maven3Builder = new Maven3Builder(this.step.getMavenBuild().getTool(), this.step.getPom(), this.step.getGoal(), mavenOpts);
            this.convertJdkPath();
            boolean result = maven3Builder.perform(this.build, this.launcher, this.listener, this.extendedEnv, this.ws, tempDir);
            if (!result) {
                throw new RuntimeException("Maven build failed");
            }
            String generatedBuildPath = (String)this.extendedEnv.get((Object)"generated.build.info");
            buildInfo.append(Utils.getGeneratedBuildInfo(this.build, this.listener, this.launcher, generatedBuildPath));
            buildInfo.appendDeployableArtifacts((String)this.extendedEnv.get((Object)"deployable.artifacts"), tempDir, this.listener);
            buildInfo.setAgentName(Utils.getAgentName(this.ws));
            return buildInfo;
        }

        private void convertJdkPath() {
            String seperator = this.launcher.isUnix() ? "/" : "\\";
            String java_home = (String)this.extendedEnv.get((Object)"JAVA_HOME");
            if (StringUtils.isNotEmpty((String)java_home)) {
                if (!StringUtils.endsWith((String)java_home, (String)seperator)) {
                    java_home = java_home + seperator;
                }
                this.extendedEnv.put("PATH+JDK", java_home + "bin");
            }
        }

        private Deployer getDeployer() {
            Deployer deployer = this.step.getMavenBuild().getDeployer();
            if (deployer == null || deployer.isEmpty()) {
                deployer = MavenDeployer.EMPTY_DEPLOYER;
            }
            return deployer;
        }
    }
}

