/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.steps;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.gradle.Gradle;
import hudson.plugins.gradle.GradleInstallation;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.gradle.GradleInitScriptWriter;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.executors.MavenGradleEnvExtractor;
import org.jfrog.hudson.pipeline.types.GradleBuild;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.deployers.GradleDeployer;
import org.jfrog.hudson.util.ExtractorUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArtifactoryGradleBuild
extends AbstractStepImpl {
    private GradleBuild gradleBuild;
    private String tasks;
    private String buildFile;
    private String rootDir;
    private String switches;
    private BuildInfo buildInfo;

    @DataBoundConstructor
    public ArtifactoryGradleBuild(GradleBuild gradleBuild, String rootDir, String buildFile, String tasks, String switches, BuildInfo buildInfo) {
        this.gradleBuild = gradleBuild;
        this.tasks = tasks == null ? "artifactoryPublish" : tasks;
        this.rootDir = rootDir == null ? "" : rootDir;
        this.buildFile = StringUtils.isEmpty((String)buildFile) ? "build.gradle" : buildFile;
        this.switches = switches == null ? "" : switches;
        this.buildInfo = buildInfo;
    }

    public GradleBuild getGradleBuild() {
        return this.gradleBuild;
    }

    public String getSwitches() {
        return this.switches;
    }

    public String getTasks() {
        return this.tasks;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "ArtifactoryGradleBuild";
        }

        public String getDisplayName() {
            return "run Artifactory gradle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        private String initScriptPath;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @Inject(optional=true)
        private transient ArtifactoryGradleBuild step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;
        private transient EnvVars extendedEnv;
        private transient FilePath tempDir;

        protected BuildInfo run() throws Exception {
            BuildInfo buildInfo = Utils.prepareBuildinfo(this.build, this.step.getBuildInfo());
            GradleDeployer deployer = this.step.getGradleBuild().getDeployer();
            deployer.createPublisherBuildInfoDetails(buildInfo);
            String revision = Utils.extractVcsRevision(new FilePath(this.ws, this.step.getRootDir()));
            this.extendedEnv = new EnvVars(this.env);
            this.extendedEnv.put("GIT_COMMIT", revision);
            MavenGradleEnvExtractor envExtractor = new MavenGradleEnvExtractor(this.build, buildInfo, deployer, this.step.getGradleBuild().getResolver(), this.listener, this.launcher);
            this.tempDir = ExtractorUtils.createAndGetTempDir(this.launcher, this.ws);
            ArgumentListBuilder args = this.getGradleExecutor();
            envExtractor.buildEnvVars(this.tempDir, this.extendedEnv);
            this.exe(args);
            String generatedBuildPath = (String)this.extendedEnv.get((Object)"generated.build.info");
            buildInfo.append(Utils.getGeneratedBuildInfo(this.build, this.listener, this.launcher, generatedBuildPath));
            ActionableHelper.deleteFilePath(this.tempDir, this.initScriptPath);
            buildInfo.appendDeployableArtifacts((String)this.extendedEnv.get((Object)"deployable.artifacts"), this.tempDir, this.listener);
            buildInfo.setAgentName(Utils.getAgentName(this.ws));
            return buildInfo;
        }

        private ArgumentListBuilder getGradleExecutor() {
            ArgumentListBuilder args = new ArgumentListBuilder();
            if (this.step.getGradleBuild().isUseWrapper()) {
                String execName = this.launcher.isUnix() ? "gradlew" : "gradlew.bat";
                FilePath gradleWrapperFile = new FilePath(new FilePath(this.ws, this.step.getRootDir()), execName);
                args.add(gradleWrapperFile.getRemote());
            } else {
                try {
                    args.add(this.getGradleExe());
                }
                catch (Exception e) {
                    this.listener.error("Couldn't find Gradle executable.");
                    this.build.setResult(Result.FAILURE);
                    throw new Run.RunnerAbortedException();
                }
            }
            args.addTokenized(this.getSwitches());
            args.addTokenized(this.step.getTasks());
            args.add("-b");
            args.add(this.getBuildFileFullPath());
            if (!this.launcher.isUnix()) {
                args = args.toWindowsCommand();
            }
            return args;
        }

        private String getBuildFileFullPath() {
            StringBuilder buildFile = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.step.getRootDir())) {
                String pathsDelimiter = this.launcher.isUnix() ? "/" : "\\";
                buildFile.append(this.step.getRootDir());
                if (!StringUtils.endsWith((String)this.step.getRootDir(), (String)pathsDelimiter)) {
                    buildFile.append(pathsDelimiter);
                }
            }
            buildFile.append(this.step.getBuildFile());
            return buildFile.toString();
        }

        private String getSwitches() {
            String switches = this.step.getSwitches();
            if (!this.step.getGradleBuild().isUsesPlugin()) {
                try {
                    this.initScriptPath = this.createInitScript();
                    switches = switches + " --init-script " + this.initScriptPath;
                }
                catch (Exception e) {
                    this.listener.getLogger().println("Error occurred while writing Gradle Init Script: " + e.getMessage());
                    this.build.setResult(Result.FAILURE);
                }
            }
            return switches;
        }

        private void exe(ArgumentListBuilder args) {
            boolean failed;
            try {
                int exitValue = this.launcher.launch().cmds(args).envs((Map)this.extendedEnv).stdout(this.listener).pwd(this.ws).join();
                failed = exitValue != 0;
            }
            catch (Exception e) {
                this.listener.error("Couldn't execute gradle task. " + e.getMessage());
                this.build.setResult(Result.FAILURE);
                throw new Run.RunnerAbortedException();
            }
            if (failed) {
                this.build.setResult(Result.FAILURE);
                throw new Run.RunnerAbortedException();
            }
        }

        private GradleInstallation getGradleInstallation() {
            if (!StringUtils.isEmpty((String)this.step.getGradleBuild().getTool())) {
                GradleInstallation[] installations;
                for (GradleInstallation i : installations = ((Gradle.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Gradle.DescriptorImpl.class)).getInstallations()) {
                    if (!this.step.getGradleBuild().getTool().equals(i.getName())) continue;
                    return i;
                }
            }
            return null;
        }

        private String getGradleExe() throws IOException, InterruptedException {
            if (!StringUtils.isEmpty((String)this.step.getGradleBuild().getTool())) {
                GradleInstallation gi = this.getGradleInstallation();
                if (gi == null) {
                    this.listener.error("Couldn't find Gradle executable.");
                    throw new Run.RunnerAbortedException();
                }
                Node node = ActionableHelper.getNode(this.launcher);
                gi = gi.forNode(node, this.listener);
                gi = gi.forEnvironment(this.extendedEnv);
                this.extendedEnv.put("GRADLE_HOME", gi.getHome());
                String gradleExe = gi.getExecutable(this.launcher);
                if (gradleExe != null) {
                    return gradleExe;
                }
                return (String)this.extendedEnv.get((Object)"GRADLE_HOME") + "/bin/gradle";
            }
            if (this.extendedEnv.get((Object)"GRADLE_HOME") == null) {
                throw new RuntimeException("Couldn't find gradle installation");
            }
            return (String)this.extendedEnv.get((Object)"GRADLE_HOME");
        }

        private String createInitScript() throws Exception {
            GradleInitScriptWriter writer = new GradleInitScriptWriter(this.tempDir);
            FilePath initScript = this.tempDir.createTextTempFile("init-artifactory", "gradle", writer.generateInitScript());
            ActionableHelper.deleteFilePathOnExit(initScript);
            String initScriptPath = initScript.getRemote();
            initScriptPath = initScriptPath.replace('\\', '/');
            return initScriptPath;
        }
    }
}

