/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.executors;

import com.google.common.collect.ArrayListMultimap;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.generic.GenericArtifactsDeployer;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfoAccessor;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ExtractorUtils;

public class GenericUploadExecutor {
    private transient FilePath ws;
    private transient Run build;
    private transient TaskListener listener;
    private BuildInfo buildinfo;
    private ArtifactoryServer server;
    private StepContext context;

    public GenericUploadExecutor(ArtifactoryServer server, TaskListener listener, Run build, FilePath ws, BuildInfo buildInfo, StepContext context) {
        this.server = server;
        this.listener = listener;
        this.build = build;
        this.buildinfo = Utils.prepareBuildinfo(build, buildInfo);
        this.ws = ws;
        this.context = context;
    }

    public BuildInfo execution(String spec) throws IOException, InterruptedException {
        Credentials credentials = new Credentials(this.server.getDeployerCredentialsConfig().provideUsername((Item)this.build.getParent()), this.server.getDeployerCredentialsConfig().providePassword((Item)this.build.getParent()));
        ProxyConfiguration proxyConfiguration = ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy);
        List artifactsToDeploy = (List)this.ws.act((FilePath.FileCallable)new GenericArtifactsDeployer.FilesDeployerCallable(this.listener, spec, this.server, credentials, this.getPropertiesMap(), proxyConfiguration));
        new BuildInfoAccessor(this.buildinfo).appendDeployedArtifacts(artifactsToDeploy);
        return this.buildinfo;
    }

    private ArrayListMultimap<String, String> getPropertiesMap() throws IOException, InterruptedException {
        EnvVars env;
        String revision;
        ArrayListMultimap properties = ArrayListMultimap.create();
        if (this.buildinfo.getName() != null) {
            properties.put((Object)"build.name", (Object)this.buildinfo.getName());
        } else {
            properties.put((Object)"build.name", (Object)BuildUniqueIdentifierHelper.getBuildName(this.build));
        }
        if (this.buildinfo.getNumber() != null) {
            properties.put((Object)"build.number", (Object)this.buildinfo.getNumber());
        } else {
            properties.put((Object)"build.number", (Object)BuildUniqueIdentifierHelper.getBuildNumber(this.build));
        }
        properties.put((Object)"build.timestamp", (Object)(this.build.getTimestamp().getTime().getTime() + ""));
        Cause.UpstreamCause parent = ActionableHelper.getUpstreamCause(this.build);
        if (parent != null) {
            properties.put((Object)"build.parentName", (Object)ExtractorUtils.sanitizeBuildName(parent.getUpstreamProject()));
            properties.put((Object)"build.parentNumber", (Object)(parent.getUpstreamBuild() + ""));
        }
        if (StringUtils.isNotBlank((String)(revision = ExtractorUtils.getVcsRevision((Map<String, String>)(env = (EnvVars)this.context.get(EnvVars.class)))))) {
            properties.put((Object)"vcs.revision", (Object)revision);
        }
        return properties;
    }
}

