/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.executors;

import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.generic.FilesResolverCallable;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfoAccessor;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class GenericDownloadExecutor {
    private final Run build;
    private transient FilePath ws;
    private BuildInfo buildInfo;
    private ArtifactoryServer server;
    private TaskListener listener;

    public GenericDownloadExecutor(ArtifactoryServer server, TaskListener listener, Run build, FilePath ws, BuildInfo buildInfo) {
        this.build = build;
        this.server = server;
        this.listener = listener;
        this.buildInfo = Utils.prepareBuildinfo(build, buildInfo);
        this.ws = ws;
    }

    public BuildInfo execution(String spec) throws IOException, InterruptedException {
        CredentialsConfig preferredResolver = this.server.getDeployerCredentialsConfig();
        List resolvedDependencies = (List)this.ws.act((FilePath.FileCallable)new FilesResolverCallable(new JenkinsBuildInfoLog(this.listener), preferredResolver.provideUsername((Item)this.build.getParent()), preferredResolver.providePassword((Item)this.build.getParent()), this.server.getUrl(), spec, this.getProxyConfiguration()));
        new BuildInfoAccessor(this.buildInfo).appendPublishedDependencies(resolvedDependencies);
        return this.buildInfo;
    }

    private ProxyConfiguration getProxyConfiguration() {
        if (this.server.isBypassProxy()) {
            return null;
        }
        return ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy);
    }
}

