/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.executors;

import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.build.api.builder.DistributionBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.types.DistributionConfig;
import org.jfrog.hudson.release.DistributionUtils;
import org.jfrog.hudson.util.CredentialManager;

public class DistributionExecutor {
    private final ArtifactoryServer server;
    private final TaskListener listener;
    private final DistributionConfig distributionConfig;
    private final StepContext context;
    private Run build;

    public DistributionExecutor(ArtifactoryServer server, Run build, TaskListener listener, StepContext context, DistributionConfig distributionConfig) {
        this.server = server;
        this.build = build;
        this.listener = listener;
        this.context = context;
        this.distributionConfig = distributionConfig;
    }

    public void execution() throws IOException {
        ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(this.server);
        CredentialsConfig deployerConfig = CredentialManager.getPreferredDeployer(configurator, this.server);
        ArtifactoryBuildInfoClient client = this.server.createArtifactoryClient(deployerConfig.provideUsername((Item)this.build.getParent()), deployerConfig.providePassword((Item)this.build.getParent()), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));
        DistributionBuilder distributionBuilder = new DistributionBuilder().publish(this.distributionConfig.isPublish()).overrideExistingFiles(this.distributionConfig.isOverrideExistingFiles()).gpgPassphrase(this.distributionConfig.getGpgPassphrase()).async(this.distributionConfig.isAsync()).targetRepo(this.distributionConfig.getTargetRepo()).sourceRepos(this.distributionConfig.getSourceRepos()).dryRun(this.distributionConfig.isDryRun());
        this.logInfo();
        boolean status = DistributionUtils.distributeAndCheckResponse(distributionBuilder, client, this.listener, this.distributionConfig.getBuildName(), this.distributionConfig.getBuildNumber(), this.distributionConfig.isDryRun());
        if (!status) {
            this.context.onFailure((Throwable)new Exception("Build distribution failed"));
        }
    }

    private void logInfo() {
        StringBuilder strBuilder = new StringBuilder().append("Distributing '").append(this.distributionConfig.getBuildName()).append("' ").append("#").append(this.distributionConfig.getBuildNumber()).append(" to '").append(this.distributionConfig.getTargetRepo()).append("'");
        if (this.distributionConfig.getSourceRepos() != null) {
            strBuilder.append(" from '").append(JSONArray.fromObject(this.distributionConfig.getSourceRepos()).toString()).append("'");
        }
        if (this.distributionConfig.isPublish()) {
            strBuilder.append(", publishing");
        }
        if (StringUtils.isNotEmpty((String)this.distributionConfig.getGpgPassphrase())) {
            strBuilder.append(", using GPG passphrase");
        }
        if (this.distributionConfig.isOverrideExistingFiles()) {
            strBuilder.append(", overriding existing files");
        }
        if (this.distributionConfig.isAsync()) {
            strBuilder.append(", async");
        }
        if (this.distributionConfig.isDryRun()) {
            strBuilder.append(", dry run");
        }
        this.listener.getLogger().println(strBuilder.append(".").toString());
    }
}

