/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.dsl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.types.ConanClient;
import org.jfrog.hudson.pipeline.types.Docker;
import org.jfrog.hudson.pipeline.types.GradleBuild;
import org.jfrog.hudson.pipeline.types.MavenBuild;
import org.jfrog.hudson.pipeline.types.MavenDescriptor;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;

public class ArtifactoryPipelineGlobal
implements Serializable {
    private CpsScript cpsScript;

    public ArtifactoryPipelineGlobal(CpsScript script) {
        this.cpsScript = script;
    }

    @Whitelisted
    public ArtifactoryServer server(String serverName) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("artifactoryServerID", serverName);
        ArtifactoryServer server = (ArtifactoryServer)this.cpsScript.invokeMethod("getArtifactoryServer", (Object)stepVariables);
        server.setCpsScript(this.cpsScript);
        return server;
    }

    @Whitelisted
    public Docker docker(String username, String password) {
        return new Docker(this.cpsScript, username, password, null, null);
    }

    @Whitelisted
    public Docker docker(String username, String password, String host) {
        return new Docker(this.cpsScript, username, password, null, host);
    }

    @Whitelisted
    public Docker docker() {
        return new Docker(this.cpsScript, null, null, null, null);
    }

    @Whitelisted
    public Docker docker(Map<String, Object> dockerArguments) {
        List<String> keysAsList = Arrays.asList("username", "password", "credentialsId", "host", "server");
        if (!keysAsList.containsAll(dockerArguments.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList);
        }
        Object server = dockerArguments.remove("server");
        ObjectMapper mapper = new ObjectMapper();
        Docker docker = (Docker)mapper.convertValue(dockerArguments, Docker.class);
        docker.setCpsScript(this.cpsScript);
        if (server != null) {
            docker.setServer((ArtifactoryServer)server);
        }
        return docker;
    }

    @Whitelisted
    public ArtifactoryServer newServer(String url, String username, String password) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("url", url);
        stepVariables.put("username", username);
        stepVariables.put("password", password);
        ArtifactoryServer server = (ArtifactoryServer)this.cpsScript.invokeMethod("newArtifactoryServer", (Object)stepVariables);
        server.setCpsScript(this.cpsScript);
        return server;
    }

    @Whitelisted
    public ArtifactoryServer newServer(Map<String, Object> serverArguments) {
        List<String> keysAsList = Arrays.asList("url", "username", "password", "credentialsId");
        if (!keysAsList.containsAll(serverArguments.keySet())) {
            throw new IllegalArgumentException("The newServer method accepts the following arguments only: " + keysAsList);
        }
        ArtifactoryServer server = (ArtifactoryServer)this.cpsScript.invokeMethod("newArtifactoryServer", serverArguments);
        server.setCpsScript(this.cpsScript);
        return server;
    }

    @Whitelisted
    public BuildInfo newBuildInfo() {
        BuildInfo buildInfo = (BuildInfo)this.cpsScript.invokeMethod("newBuildInfo", (Object)Maps.newLinkedHashMap());
        buildInfo.setCpsScript(this.cpsScript);
        return buildInfo;
    }

    @Whitelisted
    public MavenBuild newMavenBuild() {
        MavenBuild mavenBuild = (MavenBuild)this.cpsScript.invokeMethod("newMavenBuild", (Object)Maps.newLinkedHashMap());
        mavenBuild.setCpsScript(this.cpsScript);
        return mavenBuild;
    }

    @Whitelisted
    public GradleBuild newGradleBuild() {
        GradleBuild gradleBuild = (GradleBuild)this.cpsScript.invokeMethod("newGradleBuild", (Object)Maps.newLinkedHashMap());
        gradleBuild.setCpsScript(this.cpsScript);
        return gradleBuild;
    }

    @Whitelisted
    public ConanClient newConanClient(Map<String, Object> clientArgs) {
        ConanClient client = new ConanClient();
        String userPath = (String)clientArgs.get("userHome");
        if (StringUtils.isBlank((String)userPath)) {
            throw new IllegalArgumentException("The newConanClient method expects the 'userHome' argument or no arguments.");
        }
        client.setUserPath(userPath);
        client.setCpsScript(this.cpsScript);
        LinkedHashMap args = Maps.newLinkedHashMap();
        args.put("client", client);
        this.cpsScript.invokeMethod("initConanClient", (Object)args);
        return client;
    }

    @Whitelisted
    public ConanClient newConanClient() {
        ConanClient client = new ConanClient();
        client.setCpsScript(this.cpsScript);
        LinkedHashMap args = Maps.newLinkedHashMap();
        args.put("client", client);
        this.cpsScript.invokeMethod("initConanClient", (Object)args);
        return client;
    }

    @Whitelisted
    public MavenDescriptor mavenDescriptor() {
        MavenDescriptor descriptorHandler = new MavenDescriptor();
        descriptorHandler.setCpsScript(this.cpsScript);
        return descriptorHandler;
    }

    @Whitelisted
    public void addInteractivePromotion(Map<String, Object> promotionArguments) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        List<String> mandatoryParams = Arrays.asList("server", "promotionConfig");
        List<String> allowedParams = Arrays.asList("server", "promotionConfig", "displayName");
        if (!promotionArguments.keySet().containsAll(mandatoryParams)) {
            throw new IllegalArgumentException(mandatoryParams.toString() + " are mandatory arguments");
        }
        if (!allowedParams.containsAll(promotionArguments.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + allowedParams.toString());
        }
        stepVariables.put("promotionConfig", Utils.createPromotionConfig((Map)promotionArguments.get("promotionConfig"), false));
        stepVariables.put("server", promotionArguments.get("server"));
        stepVariables.put("displayName", promotionArguments.get("displayName"));
        this.cpsScript.invokeMethod("addInteractivePromotion", (Object)stepVariables);
    }
}

