/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.docker.utils;

import com.google.common.collect.ArrayListMultimap;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.pipeline.docker.DockerImage;
import org.jfrog.hudson.pipeline.docker.proxy.BuildInfoProxy;
import org.jfrog.hudson.pipeline.docker.utils.DockerUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class DockerAgentUtils
implements Serializable {
    private static final List<DockerImage> images = Collections.synchronizedList(new ArrayList());

    public static synchronized void registerImagOnAgents(Launcher launcher, final String imageTag, String host, final String targetRepo, final ArrayListMultimap<String, String> artifactsProps, final int buildInfoId) throws IOException, InterruptedException {
        final String imageId = DockerAgentUtils.getImageIdFromAgent(launcher, imageTag, host);
        DockerAgentUtils.registerImage(imageId, imageTag, targetRepo, artifactsProps, buildInfoId);
        List nodes = Jenkins.getInstance().getNodes();
        for (Node node : nodes) {
            if (node == null || node.getChannel() == null) continue;
            try {
                node.getChannel().call((Callable)new MasterToSlaveCallable<Boolean, IOException>(){

                    public Boolean call() throws IOException {
                        DockerAgentUtils.registerImage(imageId, imageTag, targetRepo, (ArrayListMultimap<String, String>)artifactsProps, buildInfoId);
                        return true;
                    }
                });
            }
            catch (Exception e) {
                launcher.getListener().getLogger().println("Could not register docker image " + imageTag + " on Jenkins node '" + node.getDisplayName() + "' due to: " + e.getMessage() + " This could be because this node is now offline.");
            }
        }
    }

    private static void registerImage(String imageId, String imageTag, String targetRepo, ArrayListMultimap<String, String> artifactsProps, int buildInfoId) throws IOException {
        DockerImage image = new DockerImage(imageId, imageTag, targetRepo, buildInfoId, artifactsProps);
        images.add(image);
    }

    public static synchronized void captureContent(String content, Properties properties) {
        try {
            String digest = DockerUtils.getConfigDigest(content);
            for (DockerImage image : images) {
                if (!digest.equals(image.getImageId())) continue;
                image.setManifest(content);
                image.setAgentName(BuildInfoProxy.getAgentName());
                image.addBuildInfoModuleProps(properties);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<DockerImage> getImagesByBuildId(int buildInfoId) {
        ArrayList<DockerImage> list = new ArrayList<DockerImage>();
        for (DockerImage image : images) {
            if (image.getBuildInfoId() != buildInfoId || !image.hasManifest()) continue;
            list.add(image);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DockerImage> getAndDiscardImagesByBuildId(int buildInfoId) {
        ArrayList<DockerImage> list = new ArrayList<DockerImage>();
        List<DockerImage> list2 = images;
        synchronized (list2) {
            Iterator<DockerImage> it = images.iterator();
            while (it.hasNext()) {
                DockerImage image = it.next();
                if (image.getBuildInfoId() == buildInfoId) {
                    if (image.hasManifest()) {
                        list.add(image);
                    }
                    it.remove();
                    continue;
                }
                if (!image.isExpired()) continue;
                it.remove();
            }
        }
        return list;
    }

    public static List<DockerImage> getDockerImagesFromAgents(final int buildInfoId, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<DockerImage> dockerImages = new ArrayList<DockerImage>();
        dockerImages.addAll(DockerAgentUtils.getAndDiscardImagesByBuildId(buildInfoId));
        List nodes = Jenkins.getInstance().getNodes();
        for (Node node : nodes) {
            if (node == null || node.getChannel() == null) continue;
            try {
                List partialDockerImages = (List)node.getChannel().call((Callable)new MasterToSlaveCallable<List<DockerImage>, IOException>(){

                    public List<DockerImage> call() throws IOException {
                        ArrayList<DockerImage> dockerImages = new ArrayList<DockerImage>();
                        dockerImages.addAll(DockerAgentUtils.getAndDiscardImagesByBuildId(buildInfoId));
                        return dockerImages;
                    }
                });
                dockerImages.addAll(partialDockerImages);
            }
            catch (Exception e) {
                listener.getLogger().println("Could not collect docker images from Jenkins node '" + node.getDisplayName() + "' due to: " + e.getMessage());
            }
        }
        return dockerImages;
    }

    public static boolean pushImage(Launcher launcher, final JenkinsBuildInfoLog log, final String imageTag, final String username, final String password, final String host) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new MasterToSlaveCallable<Boolean, IOException>(){

            public Boolean call() throws IOException {
                String message = "Pushing image: " + imageTag;
                if (StringUtils.isNotEmpty((String)host)) {
                    message = message + " using docker daemon host: " + host;
                }
                log.info(message);
                DockerUtils.pushImage(imageTag, username, password, host);
                return true;
            }
        });
    }

    public static boolean pullImage(Launcher launcher, final String imageTag, final String username, final String password, final String host) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new MasterToSlaveCallable<Boolean, IOException>(){

            public Boolean call() throws IOException {
                DockerUtils.pullImage(imageTag, username, password, host);
                return true;
            }
        });
    }

    public static boolean updateImageParentOnAgents(final JenkinsBuildInfoLog log, final String imageTag, final String host, final int buildInfoId) throws IOException, InterruptedException {
        boolean parentUpdated = DockerAgentUtils.updateImageParent(log, imageTag, host, buildInfoId);
        List nodes = Jenkins.getInstance().getNodes();
        for (Node node : nodes) {
            if (node == null || node.getChannel() == null) continue;
            boolean parentNodeUpdated = (Boolean)node.getChannel().call((Callable)new MasterToSlaveCallable<Boolean, IOException>(){

                public Boolean call() throws IOException {
                    return DockerAgentUtils.updateImageParent(log, imageTag, host, buildInfoId);
                }
            });
            parentUpdated = parentUpdated ? parentUpdated : parentNodeUpdated;
        }
        return parentUpdated;
    }

    private static boolean updateImageParent(JenkinsBuildInfoLog log, String imageTag, String host, int buildInfoId) throws IOException {
        boolean parentUpdated = false;
        for (DockerImage image : DockerAgentUtils.getImagesByBuildId(buildInfoId)) {
            if (!image.getImageTag().equals(imageTag)) continue;
            String parentId = DockerUtils.getParentId(image.getImageId(), host);
            if (StringUtils.isNotEmpty((String)parentId)) {
                Properties properties = new Properties();
                properties.setProperty("docker.image.parent", DockerUtils.getShaValue(parentId));
                image.addBuildInfoModuleProps(properties);
            }
            log.info("Docker build-info captured on '" + image.getAgentName() + "' agent.");
            parentUpdated = true;
        }
        return parentUpdated;
    }

    public static String getImageIdFromAgent(Launcher launcher, final String imageTag, final String host) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new MasterToSlaveCallable<String, IOException>(){

            public String call() throws IOException {
                return DockerUtils.getImageIdFromTag(imageTag, host);
            }
        });
    }

    public static String getParentIdFromAgent(Launcher launcher, final String imageID, final String host) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new MasterToSlaveCallable<String, IOException>(){

            public String call() throws IOException {
                return DockerUtils.getParentId(imageID, host);
            }
        });
    }
}

