/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.docker.proxy;

import java.io.File;
import java.util.Date;
import net.lightbody.bmp.mitm.CertificateInfo;
import net.lightbody.bmp.mitm.PemFileCertificateSource;
import net.lightbody.bmp.mitm.RootCertificateGenerator;

public class CertManager {
    private static final String DEFAULT_PEM_ENCRYPTION_ALGORITHM = "AES-128-CBC";
    public static String DEFAULT_RELATIVE_CERT_PATH = "secrets/jfrog/certs/jfrog.proxy.crt";
    public static String DEFAULT_RELATIVE_KEY_PATH = "secrets/jfrog/certs/jfrog.proxy.key";

    public static PemFileCertificateSource getCertificateSource(String proxyPublicKeyFilePath, String proxyPrivateKeyFilePath) {
        return new PemFileCertificateSource(new File(proxyPublicKeyFilePath), new File(proxyPrivateKeyFilePath), DEFAULT_PEM_ENCRYPTION_ALGORITHM);
    }

    public static void createCertificateSource(String proxyPublicKeyFilePath, String proxyPrivateKeyFilePath) {
        CertificateInfo certificateInfo = new CertificateInfo().commonName("localhost").organization("Jfrog Ltd").notBefore(new Date(System.currentTimeMillis() - 31536000000L)).notAfter(new Date(System.currentTimeMillis() + 31536000000L));
        RootCertificateGenerator rootCertificateGenerator = RootCertificateGenerator.builder().certificateInfo(certificateInfo).build();
        File certFile = new File(proxyPublicKeyFilePath);
        certFile.getParentFile().mkdirs();
        File keyFile = new File(proxyPrivateKeyFilePath);
        keyFile.getParentFile().mkdirs();
        rootCertificateGenerator.saveRootCertificateAsPemFile(certFile);
        rootCertificateGenerator.savePrivateKeyAsPemFile(keyFile, DEFAULT_PEM_ENCRYPTION_ALGORITHM);
    }
}

