/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.docker.proxy;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.io.Serializable;
import jenkins.security.MasterToSlaveCallable;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.docker.proxy.BuildInfoProxy;
import org.jfrog.hudson.pipeline.docker.proxy.CertManager;
import org.jfrog.hudson.util.plugins.PluginsUtils;

@Extension
public class BuildInfoProxyListener
extends ComputerListener
implements Serializable {
    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        boolean proxyEnabled = PluginsUtils.isProxyEnabled();
        final int port = PluginsUtils.getProxyPort();
        if (proxyEnabled && c.getChannel() != null) {
            Utils.copyCertsToAgent(c);
            final String publicKey = c.getNode().getRootPath() + "/" + CertManager.DEFAULT_RELATIVE_CERT_PATH;
            final String privateKey = c.getNode().getRootPath() + "/" + CertManager.DEFAULT_RELATIVE_KEY_PATH;
            final String agentName = c.getNode().getDisplayName();
            c.getChannel().call((Callable)new MasterToSlaveCallable<Boolean, IOException>(){

                public Boolean call() throws IOException {
                    BuildInfoProxy.start(port, publicKey, privateKey, agentName);
                    return true;
                }
            });
        }
        super.onOnline(c, listener);
    }
}

