/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.docker.proxy;

import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.CharsetUtil;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.pipeline.docker.utils.DockerAgentUtils;
import org.littleshoot.proxy.HttpFiltersAdapter;

public class BuildInfoFilterAdapter
extends HttpFiltersAdapter {
    private static ConcurrentMap<Integer, String> partialManifestString = new ConcurrentHashMap<Integer, String>();

    public BuildInfoFilterAdapter(HttpRequest originalRequest, ChannelHandlerContext ctx) {
        super(originalRequest, ctx);
    }

    public BuildInfoFilterAdapter(HttpRequest originalRequest) {
        super(originalRequest);
    }

    public HttpResponse proxyToServerRequest(HttpObject httpObject) {
        if (httpObject instanceof ByteBufHolder && this.originalRequest.getMethod() == HttpMethod.PUT && this.originalRequest.getUri().contains("manifest") && StringUtils.contains((String)this.originalRequest.headers().get("Content-Type"), (String)"manifest.v2")) {
            int origRequestContentLength = Integer.parseInt(this.originalRequest.headers().get("Content-Length"));
            String contentStr = ((ByteBufHolder)httpObject).content().toString(CharsetUtil.UTF_8);
            if (contentStr.length() >= origRequestContentLength) {
                Properties properties = new Properties();
                properties.put("User-Agent", this.originalRequest.headers().get("User-Agent"));
                DockerAgentUtils.captureContent(contentStr, properties);
                return null;
            }
            if (!partialManifestString.containsKey(this.ctx.hashCode())) {
                partialManifestString.put(this.ctx.hashCode(), contentStr);
                return null;
            }
            String aggregatedString = (String)partialManifestString.get(this.ctx.hashCode());
            if ((aggregatedString = aggregatedString + contentStr).length() >= origRequestContentLength) {
                Properties properties = new Properties();
                properties.put("User-Agent", this.originalRequest.headers().get("User-Agent"));
                DockerAgentUtils.captureContent(aggregatedString, properties);
                partialManifestString.remove(this.ctx.hashCode());
                return null;
            }
            partialManifestString.put(this.ctx.hashCode(), aggregatedString);
        }
        return null;
    }
}

