/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.docker;

import java.io.Serializable;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.hudson.pipeline.docker.utils.DockerUtils;

public class DockerLayer
implements Serializable {
    private String repo;
    private String path;
    private String fileName;
    private String sha1;
    private String digest;

    public DockerLayer(AqlSearchResult.SearchEntry entry) {
        this.repo = entry.getRepo();
        this.path = entry.getPath();
        this.fileName = entry.getName();
        this.sha1 = entry.getActualSha1();
        this.digest = !this.fileName.equals("manifest.json") ? DockerUtils.fileNameToDigest(this.fileName) : "sha1:" + this.sha1;
    }

    public String getFullPath() {
        return this.repo + "/" + this.path + "/" + this.fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getDigest() {
        return this.digest;
    }
}

