/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.docker;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.docker.DockerLayer;
import org.jfrog.hudson.pipeline.docker.DockerLayers;
import org.jfrog.hudson.pipeline.docker.utils.DockerUtils;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.ExtractorUtils;

public class DockerImage
implements Serializable {
    private static final long MAX_AGE_MILLI = 43200000L;
    private final long createdTime = System.currentTimeMillis();
    private final String imageId;
    private final String imageTag;
    private final String targetRepo;
    private int buildInfoId;
    private String manifest;
    private String agentName = "";
    private Properties buildInfoModuleProps = new Properties();
    private ArrayListMultimap<String, String> artifactsProps;
    private final ArtifactoryVersion VIRTUAL_REPOS_SUPPORTED_VERSION = new ArtifactoryVersion("4.8.1");
    private String imagePath;

    public DockerImage(String imageId, String imageTag, String targetRepo, int buildInfoId, ArrayListMultimap<String, String> artifactsProps) {
        this.imageId = imageId;
        this.imageTag = imageTag;
        this.targetRepo = targetRepo;
        this.buildInfoId = buildInfoId;
        this.artifactsProps = artifactsProps;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.createdTime > 43200000L;
    }

    public int getBuildInfoId() {
        return this.buildInfoId;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public boolean hasManifest() {
        return StringUtils.isNotBlank((String)this.manifest);
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Module generateBuildInfoModule(Run build, TaskListener listener, ArtifactoryConfigurator config, String buildName, String buildNumber, String timestamp) throws IOException {
        if (this.artifactsProps == null) {
            this.artifactsProps = ArrayListMultimap.create();
        }
        this.artifactsProps.put((Object)"build.name", (Object)buildName);
        this.artifactsProps.put((Object)"build.number", (Object)buildNumber);
        this.artifactsProps.put((Object)"build.timestamp", (Object)timestamp);
        String artifactsPropsStr = ExtractorUtils.buildPropertiesString(this.artifactsProps);
        Properties buildInfoItemsProps = new Properties();
        buildInfoItemsProps.setProperty("build.name", buildName);
        buildInfoItemsProps.setProperty("build.number", buildNumber);
        buildInfoItemsProps.setProperty("build.timestamp", timestamp);
        ArtifactoryServer server = config.getArtifactoryServer();
        CredentialsConfig preferredResolver = server.getDeployerCredentialsConfig();
        ArtifactoryDependenciesClient dependenciesClient = server.createArtifactoryDependenciesClient(preferredResolver.provideUsername((Item)build.getParent()), preferredResolver.providePassword((Item)build.getParent()), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy), listener);
        CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(config, server);
        ArtifactoryBuildInfoClient propertyChangeClient = server.createArtifactoryClient(preferredDeployer.provideUsername((Item)build.getParent()), preferredDeployer.providePassword((Item)build.getParent()), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));
        Module buildInfoModule = new Module();
        buildInfoModule.setId(this.imageTag.substring(this.imageTag.indexOf("/") + 1));
        if ((StringUtils.isEmpty((String)this.manifest) || StringUtils.isEmpty((String)this.imagePath)) && !this.findAndSetManifestFromArtifactory(server, dependenciesClient, listener)) {
            return buildInfoModule;
        }
        boolean includeVirtualReposSupported = propertyChangeClient.getArtifactoryVersion().isAtLeast(this.VIRTUAL_REPOS_SUPPORTED_VERSION);
        DockerLayers layers = this.createLayers(dependenciesClient, includeVirtualReposSupported);
        this.setDependenciesAndArtifacts(buildInfoModule, layers, artifactsPropsStr, buildInfoItemsProps, dependenciesClient, propertyChangeClient, server);
        this.setBuildInfoModuleProps(buildInfoModule);
        return buildInfoModule;
    }

    private boolean findAndSetManifestFromArtifactory(ArtifactoryServer server, ArtifactoryDependenciesClient dependenciesClient, TaskListener listener) throws IOException {
        String candidateImagePath = DockerUtils.getImagePath(this.imageTag);
        String manifestPath = StringUtils.join((Object[])new String[]{server.getUrl(), this.targetRepo, candidateImagePath, "manifest.json"}, (String)"/");
        if (this.checkAndSetManifestAndImagePathCandidates(manifestPath, candidateImagePath, dependenciesClient, listener)) {
            return true;
        }
        candidateImagePath = candidateImagePath.substring(candidateImagePath.indexOf("/") + 1);
        manifestPath = StringUtils.join((Object[])new String[]{server.getUrl(), this.targetRepo, candidateImagePath, "manifest.json"}, (String)"/");
        if (this.checkAndSetManifestAndImagePathCandidates(manifestPath, candidateImagePath, dependenciesClient, listener)) {
            return true;
        }
        listener.getLogger().println("Could not find corresponding manifest.json file in Artifactory.");
        return false;
    }

    private boolean checkAndSetManifestAndImagePathCandidates(String manifestPath, String candidateImagePath, ArtifactoryDependenciesClient dependenciesClient, TaskListener listener) throws IOException {
        String candidateManifest = this.getManifestFromArtifactory(dependenciesClient, manifestPath);
        if (candidateManifest == null) {
            return false;
        }
        String imageDigest = DockerUtils.getConfigDigest(candidateManifest);
        if (imageDigest.equals(this.imageId)) {
            this.manifest = candidateManifest;
            this.imagePath = candidateImagePath;
            return true;
        }
        listener.getLogger().println(String.format("Found incorrect manifest.json file in Artifactory in the following path: %s\nExpecting: %s got: %s", manifestPath, this.imageId, imageDigest));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getManifestFromArtifactory(ArtifactoryDependenciesClient dependenciesClient, String manifestPath) throws IOException {
        HttpResponse res = null;
        try {
            res = dependenciesClient.downloadArtifact(manifestPath);
            String string = IOUtils.toString((InputStream)res.getEntity().getContent());
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (res != null) {
                EntityUtils.consume((HttpEntity)res.getEntity());
            }
        }
        return null;
    }

    private void setBuildInfoModuleProps(Module buildInfoModule) {
        this.buildInfoModuleProps.setProperty("docker.image.id", DockerUtils.getShaValue(this.imageId));
        this.buildInfoModuleProps.setProperty("docker.captured.image", this.imageTag);
        buildInfoModule.setProperties(this.buildInfoModuleProps);
    }

    public void addBuildInfoModuleProps(Properties props) {
        this.buildInfoModuleProps.putAll((Map<?, ?>)props);
    }

    private DockerLayers createLayers(ArtifactoryDependenciesClient dependenciesClient, boolean includeVirtualReposSupported) throws IOException {
        String queryStr = this.getAqlQuery(includeVirtualReposSupported);
        AqlSearchResult result = dependenciesClient.searchArtifactsByAql(queryStr);
        DockerLayers layers = new DockerLayers();
        for (AqlSearchResult.SearchEntry entry : result.getResults()) {
            if (!StringUtils.equals((String)entry.getPath(), (String)this.imagePath)) continue;
            HashSet virtual_repos = Sets.newHashSet((Object[])entry.getVirtualRepos());
            if (!StringUtils.equals((String)entry.getRepo(), (String)this.targetRepo) && !virtual_repos.contains(this.targetRepo)) continue;
            DockerLayer layer = new DockerLayer(entry);
            layers.addLayer(layer);
        }
        return layers;
    }

    private void setDependenciesAndArtifacts(Module buildInfoModule, DockerLayers layers, String artifactsProps, Properties buildInfoItemsProps, ArtifactoryDependenciesClient dependenciesClient, ArtifactoryBuildInfoClient propertyChangeClient, ArtifactoryServer server) throws IOException {
        DockerLayer historyLayer = layers.getByDigest(this.imageId);
        if (historyLayer == null) {
            throw new IllegalStateException("Could not find the history docker layer: " + this.imageId + " for image: " + this.imageTag + " in Artifactory.");
        }
        HttpResponse res = dependenciesClient.downloadArtifact(server.getUrl() + "/" + historyLayer.getFullPath());
        int dependencyLayerNum = DockerUtils.getNumberOfDependentLayers(ExtractorUtils.entityToString(res.getEntity()));
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Iterator<String> it = DockerUtils.getLayersDigests(this.manifest).iterator();
        for (int i = 0; i < dependencyLayerNum; ++i) {
            String digest = it.next();
            DockerLayer layer = layers.getByDigest(digest);
            HttpResponse httpResponse = propertyChangeClient.executeUpdateFileProperty(layer.getFullPath(), artifactsProps);
            this.validateResponse(httpResponse);
            Dependency dependency = new DependencyBuilder().id(layer.getFileName()).sha1(layer.getSha1()).properties(buildInfoItemsProps).build();
            dependencies.add(dependency);
            Artifact artifact = new ArtifactBuilder(layer.getFileName()).sha1(layer.getSha1()).properties(buildInfoItemsProps).build();
            artifacts.add(artifact);
        }
        buildInfoModule.setDependencies(dependencies);
        while (it.hasNext()) {
            String digest = it.next();
            DockerLayer layer = layers.getByDigest(digest);
            if (layer == null) continue;
            HttpResponse httpResponse = propertyChangeClient.executeUpdateFileProperty(layer.getFullPath(), artifactsProps);
            this.validateResponse(httpResponse);
            Artifact artifact = new ArtifactBuilder(layer.getFileName()).sha1(layer.getSha1()).properties(buildInfoItemsProps).build();
            artifacts.add(artifact);
        }
        buildInfoModule.setArtifacts(artifacts);
    }

    private String getAqlQuery(boolean includeVirtualRepos) throws IOException {
        List<String> layersDigest = DockerUtils.getLayersDigests(this.manifest);
        StringBuilder aqlRequestForDockerSha = new StringBuilder("items.find({\"$or\":[ ");
        ArrayList<String> layersQuery = new ArrayList<String>();
        for (String digest : layersDigest) {
            String shaVersion = DockerUtils.getShaVersion(digest);
            String shaValue = DockerUtils.getShaValue(digest);
            String singleFileQuery = String.format("{\"name\": \"%s\"}", DockerUtils.digestToFileName(digest));
            if (StringUtils.equalsIgnoreCase((String)shaVersion, (String)"sha1")) {
                singleFileQuery = String.format("{\"actual_sha1\": \"%s\"}", shaValue);
            }
            layersQuery.add(singleFileQuery);
        }
        aqlRequestForDockerSha.append(StringUtils.join(layersQuery, (String)","));
        if (includeVirtualRepos) {
            aqlRequestForDockerSha.append("]}).include(\"name\",\"repo\",\"path\",\"actual_sha1\",\"virtual_repos\")");
        } else {
            aqlRequestForDockerSha.append("]}).include(\"name\",\"repo\",\"path\",\"actual_sha1\")");
        }
        return aqlRequestForDockerSha.toString();
    }

    private void validateResponse(HttpResponse httpResponse) throws IOException {
        int code = httpResponse.getStatusLine().getStatusCode();
        if (code != 204) {
            String response = ExtractorUtils.entityToString(httpResponse.getEntity());
            throw new IOException("Failed while trying to set properties on docker layer: " + response);
        }
    }
}

