/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.util.BuildData;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.LocalChannel;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Ref;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.docker.proxy.CertManager;
import org.jfrog.hudson.pipeline.types.DistributionConfig;
import org.jfrog.hudson.pipeline.types.PromotionConfig;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.RepositoriesUtils;

public class Utils {
    public static final String CONAN_USER_HOME = "CONAN_USER_HOME";
    public static final String BUILD_INFO = "buildInfo";
    private static final String UNIX_SPECIAL_CHARS = "`^<>| ,;!?'\"()[]{}$*\\&#";

    public static ArtifactoryServer prepareArtifactoryServer(String artifactoryServerID, org.jfrog.hudson.pipeline.types.ArtifactoryServer pipelineServer) {
        if (artifactoryServerID == null && pipelineServer == null) {
            return null;
        }
        if (artifactoryServerID != null && pipelineServer != null) {
            return null;
        }
        if (pipelineServer != null) {
            CredentialsConfig credentials = pipelineServer.createCredentialsConfig();
            return new ArtifactoryServer(null, pipelineServer.getUrl(), credentials, credentials, pipelineServer.getConnection().getTimeout(), pipelineServer.isBypassProxy(), pipelineServer.getConnection().getRetry());
        }
        ArtifactoryServer server = RepositoriesUtils.getArtifactoryServer(artifactoryServerID, RepositoriesUtils.getArtifactoryServers());
        if (server == null) {
            return null;
        }
        return server;
    }

    public static BuildInfo prepareBuildinfo(Run build, BuildInfo buildinfo) {
        if (buildinfo == null) {
            return new BuildInfo(build);
        }
        return buildinfo;
    }

    public static ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static EnvVars extractBuildParameters(Run build, TaskListener listener) {
        EnvVars buildVariables = new EnvVars();
        try {
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                for (ParameterValue p : parameters) {
                    String v;
                    if (p.isSensitive() || (v = (String)p.createVariableResolver(null).resolve(p.getName())) == null) continue;
                    buildVariables.put(p.getName(), v);
                }
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Can't get build variables");
            return null;
        }
        return buildVariables;
    }

    public static List<Vcs> extractVcsBuildData(Run build) {
        ArrayList<Vcs> result = new ArrayList<Vcs>();
        List buildData = build.getActions(BuildData.class);
        if (buildData != null) {
            for (BuildData data : buildData) {
                String sha1 = data.getLastBuiltRevision().getSha1String();
                Iterator iterator = data.getRemoteUrls().iterator();
                if (!iterator.hasNext()) continue;
                result.add(new Vcs((String)iterator.next(), sha1));
            }
        }
        return result;
    }

    public static String extractVcsRevision(FilePath filePath) throws IOException, InterruptedException {
        if (filePath == null) {
            return "";
        }
        FilePath dotGitPath = new FilePath(filePath, ".git");
        if (dotGitPath.exists()) {
            return (String)dotGitPath.act((FilePath.FileCallable)new MasterToSlaveFileCallable<String>(){

                public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    FileRepository repository = new FileRepository(f);
                    Ref head = repository.getRef("HEAD");
                    return head.getObjectId().getName();
                }
            });
        }
        return Utils.extractVcsRevision(filePath.getParent());
    }

    public static Computer getCurrentComputer(Launcher launcher) {
        Jenkins j = Jenkins.getInstance();
        for (Computer c : j.getComputers()) {
            if (c.getChannel() != launcher.getChannel()) continue;
            return c;
        }
        return null;
    }

    public static IncludesExcludes getArtifactsIncludeExcludeForDeyployment(IncludeExcludePatterns patternFilter) {
        int i;
        if (patternFilter == null) {
            return new IncludesExcludes("", "");
        }
        String[] excludePatterns = patternFilter.getExcludePatterns();
        String[] includePatterns = patternFilter.getIncludePatterns();
        StringBuilder include = new StringBuilder();
        StringBuilder exclude = new StringBuilder();
        for (i = 0; i < includePatterns.length; ++i) {
            if (include.length() > 0) {
                include.append(", ");
            }
            include.append(includePatterns[i]);
        }
        for (i = 0; i < excludePatterns.length; ++i) {
            if (exclude.length() > 0) {
                exclude.append(", ");
            }
            exclude.append(excludePatterns[i]);
        }
        IncludesExcludes result = new IncludesExcludes(include.toString(), exclude.toString());
        return result;
    }

    public static Build getGeneratedBuildInfo(Run build, TaskListener listener, Launcher launcher, String jsonBuildPath) {
        Build build2;
        FilePath generatedBuildInfoFilePath;
        block8: {
            String buildInfoFileContent;
            InputStream inputStream;
            ObjectMapper mapper;
            block6: {
                Build build3;
                block7: {
                    mapper = new ObjectMapper();
                    generatedBuildInfoFilePath = null;
                    inputStream = null;
                    StringWriter writer = new StringWriter();
                    generatedBuildInfoFilePath = new FilePath(launcher.getChannel(), jsonBuildPath);
                    inputStream = generatedBuildInfoFilePath.read();
                    IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)"UTF-8");
                    buildInfoFileContent = writer.toString();
                    if (!StringUtils.isBlank((String)buildInfoFileContent)) break block6;
                    build3 = new Build();
                    if (inputStream == null) break block7;
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                Utils.deleteFilePathQuietly(generatedBuildInfoFilePath);
                return build3;
            }
            try {
                build2 = (Build)mapper.readValue(buildInfoFileContent, Build.class);
                if (inputStream == null) break block8;
            }
            catch (Exception e) {
                try {
                    listener.error("Couldn't read generated build info at : " + jsonBuildPath);
                    build.setResult(Result.FAILURE);
                    throw new Run.RunnerAbortedException();
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        IOUtils.closeQuietly(inputStream);
                    }
                    Utils.deleteFilePathQuietly(generatedBuildInfoFilePath);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        Utils.deleteFilePathQuietly(generatedBuildInfoFilePath);
        return build2;
    }

    private static void deleteFilePathQuietly(FilePath filePath) {
        try {
            if (filePath != null && filePath.exists()) {
                filePath.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyCertsToAgent(Computer c) throws IOException, InterruptedException {
        if (!(c instanceof Jenkins.MasterComputer)) {
            String certPath = CertManager.DEFAULT_RELATIVE_CERT_PATH;
            FilePath remotePublicKey = new FilePath(c.getChannel(), c.getNode().getRootPath() + "/" + certPath);
            FilePath localPublicKey = new FilePath(Jenkins.getInstance().getRootPath(), certPath);
            localPublicKey.copyTo(remotePublicKey);
            String keyPath = CertManager.DEFAULT_RELATIVE_KEY_PATH;
            FilePath remotePrivateKey = new FilePath(c.getChannel(), c.getNode().getRootPath() + "/" + keyPath);
            FilePath localPrivateKey = new FilePath(Jenkins.getInstance().getRootPath(), keyPath);
            localPrivateKey.copyTo(remotePrivateKey);
        }
    }

    public static String createTempJsonFile(Launcher launcher, final String name, final String dir) throws Exception {
        return (String)launcher.getChannel().call((Callable)new MasterToSlaveCallable<String, Exception>(){

            public String call() throws IOException {
                File tempFile = File.createTempFile(name, ".json", new File(dir));
                tempFile.deleteOnExit();
                return tempFile.getAbsolutePath();
            }
        });
    }

    public static void exeConan(ArgumentListBuilder args, FilePath pwd, Launcher launcher, TaskListener listener, Run build, EnvVars env) {
        boolean failed;
        try {
            if (!pwd.exists()) {
                pwd.mkdirs();
            }
            if (launcher.isUnix()) {
                boolean hasMaskedArguments = args.hasMaskedArguments();
                StringBuilder sb = new StringBuilder();
                for (String arg : args.toList()) {
                    sb.append(Utils.escapeUnixArgument(arg)).append(" ");
                }
                args.clear();
                args.add(new String[]{"sh", "-c"});
                if (hasMaskedArguments) {
                    args.addMasked(sb.toString());
                } else {
                    args.add(sb.toString());
                }
            } else {
                args = args.toWindowsCommand();
            }
            int exitValue = launcher.launch().cmds(args).envs((Map)env).stdout(listener).pwd(pwd).join();
            failed = exitValue != 0;
        }
        catch (Exception e) {
            listener.error("Couldn't execute the conan client executable. " + e.getMessage());
            build.setResult(Result.FAILURE);
            throw new Run.RunnerAbortedException();
        }
        if (failed) {
            build.setResult(Result.FAILURE);
            throw new Run.RunnerAbortedException();
        }
    }

    static String escapeUnixArgument(String arg) {
        StringBuilder res = new StringBuilder();
        for (char c : arg.toCharArray()) {
            if (UNIX_SPECIAL_CHARS.indexOf(c) >= 0) {
                res.append("\\");
            }
            res.append(c);
        }
        return res.toString();
    }

    public static PromotionConfig createPromotionConfig(Map<String, Object> promotionParams, boolean isTargetRepositoryMandatory) {
        String targetRepository = "targetRepo";
        ArrayList<String> mandatoryParams = new ArrayList<String>(Arrays.asList("buildName", "buildNumber"));
        List<String> allowedParams = Arrays.asList("buildName", "buildNumber", "targetRepo", "sourceRepo", "status", "comment", "includeDependencies", "copy", "failFast");
        if (isTargetRepositoryMandatory) {
            mandatoryParams.add("targetRepo");
        }
        if (!promotionParams.keySet().containsAll(mandatoryParams)) {
            throw new IllegalArgumentException(((Object)mandatoryParams).toString() + " are mandatory arguments");
        }
        if (!allowedParams.containsAll(promotionParams.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + allowedParams.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        PromotionConfig config = (PromotionConfig)mapper.convertValue(promotionParams, PromotionConfig.class);
        return config;
    }

    public static org.jfrog.hudson.release.promotion.PromotionConfig convertPromotionConfig(PromotionConfig pipelinePromotionConfig) {
        org.jfrog.hudson.release.promotion.PromotionConfig promotionConfig = new org.jfrog.hudson.release.promotion.PromotionConfig();
        promotionConfig.setBuildName(pipelinePromotionConfig.getBuildName());
        promotionConfig.setBuildNumber(pipelinePromotionConfig.getBuildNumber());
        promotionConfig.setTargetRepo(pipelinePromotionConfig.getTargetRepo());
        promotionConfig.setSourceRepo(pipelinePromotionConfig.getSourceRepo());
        promotionConfig.setStatus(pipelinePromotionConfig.getStatus());
        promotionConfig.setComment(pipelinePromotionConfig.getComment());
        promotionConfig.setIncludeDependencies(pipelinePromotionConfig.isIncludeDependencies());
        promotionConfig.setCopy(pipelinePromotionConfig.isCopy());
        promotionConfig.setFailFast(pipelinePromotionConfig.isFailFast());
        return promotionConfig;
    }

    public static DistributionConfig createDistributionConfig(Map<String, Object> promotionParams) {
        ArrayList<String> mandatoryParams = new ArrayList<String>(Arrays.asList("buildName", "buildNumber", "targetRepo"));
        List<String> allowedParams = Arrays.asList("buildName", "buildNumber", "publish", "overrideExistingFiles", "gpgPassphrase", "async", "targetRepo", "sourceRepos", "dryRun");
        if (!promotionParams.keySet().containsAll(mandatoryParams)) {
            throw new IllegalArgumentException(((Object)mandatoryParams).toString() + " are mandatory arguments");
        }
        if (!allowedParams.containsAll(promotionParams.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + allowedParams.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        DistributionConfig config = (DistributionConfig)mapper.convertValue(promotionParams, DistributionConfig.class);
        return config;
    }

    public static String getAgentName(FilePath ws) {
        if (ws.getChannel() != null) {
            return ws.getChannel() instanceof LocalChannel ? "Master" : ((Channel)ws.getChannel()).getName();
        }
        return "Unknown";
    }

    public static BuildInfo appendBuildInfo(CpsScript cpsScript, Map<String, Object> stepVariables) {
        BuildInfo buildInfo = (BuildInfo)stepVariables.get(BUILD_INFO);
        if (buildInfo == null) {
            buildInfo = (BuildInfo)cpsScript.invokeMethod("newBuildInfo", (Object)Maps.newLinkedHashMap());
            stepVariables.put(BUILD_INFO, buildInfo);
        }
        buildInfo.setCpsScript(cpsScript);
        return buildInfo;
    }
}

