/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline;

import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.builder.BuildInfoBuilder;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.AbstractBuildInfoDeployer;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.pipeline.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.Utils;
import org.jfrog.hudson.pipeline.types.buildInfo.BuildInfoAccessor;

public class BuildInfoDeployer
extends AbstractBuildInfoDeployer {
    private final Run build;
    private final Map<String, String> sysVars;
    private final Map<String, String> envVars;
    private ArtifactoryConfigurator configurator;
    private Build buildInfo;
    private boolean asyncBuildRetention;

    public BuildInfoDeployer(ArtifactoryConfigurator configurator, ArtifactoryBuildInfoClient client, Run build, TaskListener listener, BuildInfoAccessor buildinfoAccessor) throws IOException, InterruptedException, NoSuchAlgorithmException {
        super(configurator, build, listener, client);
        this.configurator = configurator;
        this.build = build;
        this.envVars = buildinfoAccessor.getEnvVars();
        this.sysVars = buildinfoAccessor.getSysVars();
        this.buildInfo = this.createBuildInfo("Pipeline", "", BuildType.GENERIC);
        this.buildInfo.setBuildRetention(buildinfoAccessor.getRetention().createBuildRetention());
        this.asyncBuildRetention = buildinfoAccessor.getRetention().isAsync();
        if (buildinfoAccessor.getStartDate() != null) {
            this.buildInfo.setStartedDate(buildinfoAccessor.getStartDate());
        }
        this.buildInfo.setModules(new ArrayList<Module>(buildinfoAccessor.getModules()));
        this.buildInfo.setBuildDependencies(new ArrayList<BuildDependency>(buildinfoAccessor.getBuildDependencies()));
        if (StringUtils.isNotEmpty((String)buildinfoAccessor.getBuildName())) {
            this.buildInfo.setName(buildinfoAccessor.getBuildName());
        }
        if (StringUtils.isNotEmpty((String)buildinfoAccessor.getBuildNumber())) {
            this.buildInfo.setNumber(buildinfoAccessor.getBuildNumber());
        }
        this.addVcsDataToBuild(build);
    }

    private void addVcsDataToBuild(Run build) {
        if (Jenkins.getInstance().getPlugin("git") == null) {
            return;
        }
        List<Vcs> vcsList = Utils.extractVcsBuildData(build);
        this.buildInfo.setVcs(vcsList);
        if (!vcsList.isEmpty()) {
            Vcs lastVcs = vcsList.get(vcsList.size() - 1);
            this.buildInfo.setVcsUrl(lastVcs.getUrl());
            this.buildInfo.setVcsRevision(lastVcs.getRevision());
        }
    }

    public void deploy() throws IOException {
        String artifactoryUrl = this.configurator.getArtifactoryServer().getUrl();
        this.listener.getLogger().println("Deploying build info to: " + artifactoryUrl + "/api/build");
        BuildRetention retention = this.buildInfo.getBuildRetention();
        this.buildInfo.setBuildRetention(null);
        org.jfrog.build.extractor.retention.Utils.sendBuildAndBuildRetention((ArtifactoryBuildInfoClient)this.client, (Build)this.buildInfo, (BuildRetention)retention, (boolean)this.asyncBuildRetention);
        this.addBuildInfoResultAction(artifactoryUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuildInfoResultAction(String artifactoryUrl) {
        List list = this.build.getActions();
        synchronized (list) {
            BuildInfoResultAction action = (BuildInfoResultAction)this.build.getAction(BuildInfoResultAction.class);
            if (action == null) {
                action = new BuildInfoResultAction(this.build);
                this.build.getActions().add(action);
            }
            action.addBuildInfoResults(artifactoryUrl, this.buildInfo);
        }
    }

    @Override
    protected void addBuildInfoProperties(BuildInfoBuilder builder) {
        if (this.envVars != null) {
            for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
                builder.addProperty((Object)("buildInfo.env." + entry.getKey()), (Object)entry.getValue());
            }
        }
        if (this.sysVars != null) {
            for (Map.Entry<String, String> entry : this.sysVars.entrySet()) {
                builder.addProperty((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

