/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven3;

import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BintrayPublish.BintrayPublishAction;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.MultiConfigurationAware;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.VirtualRepository;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.FormValidations;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.ResolverContext;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ArtifactoryMaven3Configurator
extends BuildWrapper
implements DeployerOverrider,
ResolverOverrider,
BuildInfoAwareConfigurator,
MultiConfigurationAware {
    @Deprecated
    private ServerDetails details = null;
    private final ServerDetails deployerDetails;
    private final ServerDetails resolverDetails;
    private final CredentialsConfig deployerCredentialsConfig;
    private final CredentialsConfig resolverCredentialsConfig;
    private final boolean deployArtifacts;
    private final IncludesExcludes artifactDeploymentPatterns;
    private final boolean includeEnvVars;
    private final boolean deployBuildInfo;
    private final boolean runChecks;
    private final String violationRecipients;
    private final boolean includePublishArtifacts;
    private final String scopes;
    private final boolean discardOldBuilds;
    private final boolean discardBuildArtifacts;
    private final boolean asyncBuildRetention;
    @Deprecated
    private final String matrixParams;
    private final String deploymentProperties;
    private final boolean enableIssueTrackerIntegration;
    private final boolean filterExcludedArtifactsFromBuild;
    private final boolean enableResolveArtifacts;
    private IncludesExcludes envVarsPatterns;
    private boolean licenseAutoDiscovery;
    private boolean disableLicenseAutoDiscovery;
    private boolean aggregateBuildIssues;
    private String aggregationBuildStatus;
    private boolean recordAllDependencies;
    private boolean blackDuckRunChecks;
    private String blackDuckAppName;
    private String blackDuckAppVersion;
    private String blackDuckReportRecipients;
    private String blackDuckScopes;
    private boolean blackDuckIncludePublishedArtifacts;
    private boolean autoCreateMissingComponentRequests;
    private boolean autoDiscardStaleComponentRequests;
    private String artifactoryCombinationFilter;
    private String customBuildName;
    private boolean overrideBuildName;
    @Deprecated
    private transient boolean skipBuildInfoDeploy;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private Credentials overridingResolverCredentials;

    @DataBoundConstructor
    public ArtifactoryMaven3Configurator(ServerDetails details, ServerDetails deployerDetails, ServerDetails resolverDetails, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, boolean enableResolveArtifacts, IncludesExcludes artifactDeploymentPatterns, boolean deployArtifacts, boolean deployBuildInfo, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean runChecks, String violationRecipients, boolean includePublishArtifacts, String scopes, boolean disableLicenseAutoDiscovery, boolean discardOldBuilds, boolean discardBuildArtifacts, boolean asyncBuildRetention, String matrixParams, String deploymentProperties, boolean enableIssueTrackerIntegration, boolean aggregateBuildIssues, String aggregationBuildStatus, boolean recordAllDependencies, boolean blackDuckRunChecks, String blackDuckAppName, String blackDuckAppVersion, String blackDuckReportRecipients, String blackDuckScopes, boolean blackDuckIncludePublishedArtifacts, boolean autoCreateMissingComponentRequests, boolean autoDiscardStaleComponentRequests, boolean filterExcludedArtifactsFromBuild, String customBuildName, boolean overrideBuildName, String artifactoryCombinationFilter) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails != null ? deployerDetails : details;
        this.resolverDetails = resolverDetails;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
        this.envVarsPatterns = envVarsPatterns;
        this.runChecks = runChecks;
        this.violationRecipients = violationRecipients;
        this.includePublishArtifacts = includePublishArtifacts;
        this.scopes = scopes;
        this.discardOldBuilds = discardOldBuilds;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.asyncBuildRetention = asyncBuildRetention;
        this.deploymentProperties = deploymentProperties != null ? deploymentProperties : matrixParams;
        this.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.recordAllDependencies = recordAllDependencies;
        this.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
        this.licenseAutoDiscovery = !disableLicenseAutoDiscovery;
        this.deployBuildInfo = deployBuildInfo;
        this.deployArtifacts = deployArtifacts;
        this.includeEnvVars = includeEnvVars;
        this.blackDuckRunChecks = blackDuckRunChecks;
        this.blackDuckAppName = blackDuckAppName;
        this.blackDuckAppVersion = blackDuckAppVersion;
        this.blackDuckReportRecipients = blackDuckReportRecipients;
        this.blackDuckScopes = blackDuckScopes;
        this.blackDuckIncludePublishedArtifacts = blackDuckIncludePublishedArtifacts;
        this.autoCreateMissingComponentRequests = autoCreateMissingComponentRequests;
        this.autoDiscardStaleComponentRequests = autoDiscardStaleComponentRequests;
        this.artifactoryCombinationFilter = artifactoryCombinationFilter;
        this.enableResolveArtifacts = enableResolveArtifacts;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails != null ? this.deployerDetails : this.details;
    }

    public ServerDetails getResolverDetails() {
        return this.resolverDetails;
    }

    public String getDownloadReleaseRepositoryKey() {
        return this.resolverDetails != null ? this.resolverDetails.getResolveReleaseRepositoryKey() : null;
    }

    public String getDownloadSnapshotRepositoryKey() {
        return this.resolverDetails != null ? this.resolverDetails.getResolveReleaseRepositoryKey() : null;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    @Override
    public boolean isOverridingDefaultResolver() {
        return this.resolverCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingResolverCredentials() {
        return this.overridingResolverCredentials;
    }

    @Override
    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public boolean isOverridingResolverCredentials() {
        return this.resolverCredentialsConfig.isCredentialsProvided();
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties != null ? this.deploymentProperties : this.matrixParams;
    }

    public IncludesExcludes getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    public boolean isRecordAllDependencies() {
        return this.recordAllDependencies;
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName(), this.getDescriptor().getArtifactoryServers());
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeployReleaseRepositoryKey() : null;
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return null;
    }

    @Override
    public boolean isIncludePublishArtifacts() {
        return this.includePublishArtifacts;
    }

    public String getSnapshotsRepositoryKey() {
        return this.getDeployerDetails() != null ? (this.getDeployerDetails().getDeploySnapshotRepository() != null ? this.getDeployerDetails().getDeploySnapshotRepository().getRepoKey() : this.getDeployerDetails().getDeployReleaseRepository().getRepoKey()) : null;
    }

    @Override
    public boolean isLicenseAutoDiscovery() {
        return this.licenseAutoDiscovery;
    }

    public boolean isDisableLicenseAutoDiscovery() {
        return this.disableLicenseAutoDiscovery;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getUrl() : null;
    }

    @Override
    public String getScopes() {
        return this.scopes;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    @Override
    public String getViolationRecipients() {
        return this.violationRecipients;
    }

    @Override
    public boolean isRunChecks() {
        return this.runChecks;
    }

    @Override
    public boolean isBlackDuckRunChecks() {
        return this.blackDuckRunChecks;
    }

    @Override
    public String getBlackDuckAppName() {
        return this.blackDuckAppName;
    }

    @Override
    public String getBlackDuckAppVersion() {
        return this.blackDuckAppVersion;
    }

    @Override
    public String getBlackDuckReportRecipients() {
        return this.blackDuckReportRecipients;
    }

    @Override
    public String getBlackDuckScopes() {
        return this.blackDuckScopes;
    }

    @Override
    public boolean isBlackDuckIncludePublishedArtifacts() {
        return this.blackDuckIncludePublishedArtifacts;
    }

    @Override
    public boolean isAutoCreateMissingComponentRequests() {
        return this.autoCreateMissingComponentRequests;
    }

    @Override
    public boolean isAutoDiscardStaleComponentRequests() {
        return this.autoDiscardStaleComponentRequests;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    public boolean isEnableResolveArtifacts() {
        return this.enableResolveArtifacts;
    }

    @Override
    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    @Override
    public String getArtifactoryCombinationFilter() {
        return this.artifactoryCombinationFilter;
    }

    @Override
    public boolean isMultiConfProject() {
        return this.getDescriptor().isMultiConfProject();
    }

    public ArtifactoryServer getArtifactoryServer(String artifactoryServerName) {
        return RepositoriesUtils.getArtifactoryServer(artifactoryServerName, this.getDescriptor().getArtifactoryServers());
    }

    public List<Repository> getReleaseRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeployReleaseRepository().getKeyFromSelect());
    }

    public List<Repository> getSnapshotRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeploySnapshotRepository().getKeyFromSelect());
    }

    public List<VirtualRepository> getResolveReleaseRepositoryList() {
        return RepositoriesUtils.collectVirtualRepositories(null, this.resolverDetails.getResolveReleaseRepository().getKeyFromSelect());
    }

    public List<VirtualRepository> getResolveSnapshotRepositoryList() {
        return RepositoriesUtils.collectVirtualRepositories(null, this.resolverDetails.getResolveSnapshotRepository().getKeyFromSelect());
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        if (this.isOverrideBuildName()) {
            return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project, this.getCustomBuildName());
        }
        return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project);
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, final Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        String artifactoryServerName = this.getArtifactoryName();
        if (StringUtils.isBlank((String)artifactoryServerName)) {
            return super.setUp(build, launcher, listener);
        }
        ArtifactoryServer artifactoryServer = this.getArtifactoryServer(artifactoryServerName);
        if (artifactoryServer == null) {
            listener.getLogger().format("No Artifactory server configured for %s. Please check your configuration.", artifactoryServerName).println();
            build.setResult(Result.FAILURE);
            throw new IllegalArgumentException("No Artifactory server configured for " + artifactoryServerName);
        }
        PublisherContext.Builder publisherBuilder = new PublisherContext.Builder().artifactoryServer(artifactoryServer).serverDetails(this.getDeployerDetails()).deployerOverrider(this).runChecks(this.isRunChecks()).includePublishArtifacts(this.isIncludePublishArtifacts()).violationRecipients(this.getViolationRecipients()).scopes(this.getScopes()).licenseAutoDiscovery(this.isLicenseAutoDiscovery()).discardOldBuilds(this.isDiscardOldBuilds()).deployArtifacts(this.isDeployArtifacts()).includesExcludes(this.getArtifactDeploymentPatterns()).skipBuildInfoDeploy(!this.deployBuildInfo).recordAllDependencies(this.isRecordAllDependencies()).includeEnvVars(this.isIncludeEnvVars()).envVarsPatterns(this.getEnvVarsPatterns()).discardBuildArtifacts(this.isDiscardBuildArtifacts()).asyncBuildRetention(this.isAsyncBuildRetention()).deploymentProperties(this.getDeploymentProperties()).enableIssueTrackerIntegration(this.isEnableIssueTrackerIntegration()).aggregateBuildIssues(this.isAggregateBuildIssues()).aggregationBuildStatus(this.getAggregationBuildStatus()).integrateBlackDuck(this.isBlackDuckRunChecks(), this.getBlackDuckAppName(), this.getBlackDuckAppVersion(), this.getBlackDuckReportRecipients(), this.getBlackDuckScopes(), this.isBlackDuckIncludePublishedArtifacts(), this.isAutoCreateMissingComponentRequests(), this.isAutoDiscardStaleComponentRequests()).filterExcludedArtifactsFromBuild(this.isFilterExcludedArtifactsFromBuild()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).overrideBuildName(this.isOverrideBuildName()).customBuildName(this.getCustomBuildName());
        if (this.isMultiConfProject(build) && this.isDeployArtifacts()) {
            if (StringUtils.isBlank((String)this.getArtifactoryCombinationFilter())) {
                String error = "The field \"Combination Matches\" is empty, but is defined as mandatory!";
                listener.getLogger().println(error);
                build.setResult(Result.FAILURE);
                throw new IllegalArgumentException(error);
            }
            boolean isFiltered = MultiConfigurationUtils.isfiltrated(build, this.getArtifactoryCombinationFilter());
            if (isFiltered) {
                publisherBuilder.skipBuildInfoDeploy(true).deployArtifacts(false);
            }
        }
        ResolverContext resolver = null;
        if (this.isEnableResolveArtifacts()) {
            CredentialsConfig credentialResolver = CredentialManager.getPreferredResolver(this, this.getArtifactoryServer());
            resolver = new ResolverContext(this.getArtifactoryServer(), this.getResolverDetails(), credentialResolver.getCredentials((Item)build.getProject()), this);
        }
        final ResolverContext resolverContext = resolver;
        final PublisherContext publisherContext = publisherBuilder.build();
        build.setResult(Result.SUCCESS);
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                try {
                    ExtractorUtils.addBuilderInfoArguments(env, (Run)build, (TaskListener)listener, publisherContext, resolverContext, build.getWorkspace(), launcher);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean tearDown(AbstractBuild build2, BuildListener listener2) {
                Result result = build2.getResult();
                if (ArtifactoryMaven3Configurator.this.deployBuildInfo && result != null && result.isBetterOrEqualTo(Result.SUCCESS)) {
                    String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(ArtifactoryMaven3Configurator.this, (Run)build2);
                    build2.getActions().add(new BuildInfoResultAction(ArtifactoryMaven3Configurator.this.getArtifactoryUrl(), (Run)build2, buildName));
                    build2.getActions().add(new UnifiedPromoteBuildAction((Run)build2, ArtifactoryMaven3Configurator.this));
                    if (PluginsUtils.isPushToBintrayEnabled()) {
                        build2.getActions().add(new BintrayPublishAction<ArtifactoryMaven3Configurator>(build2, ArtifactoryMaven3Configurator.this));
                    }
                }
                return true;
            }
        };
    }

    private boolean isMultiConfProject(AbstractBuild build) {
        return build.getProject().getClass().equals(MatrixConfiguration.class);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        private AbstractProject<?, ?> item;

        public DescriptorImpl() {
            super(ArtifactoryMaven3Configurator.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            this.item = item;
            return item.getClass().isAssignableFrom(FreeStyleProject.class) || item.getClass().isAssignableFrom(MatrixProject.class) || Jenkins.getInstance().getPlugin("jenkins-multijob-plugin") != null && item.getClass().isAssignableFrom(MultiJobProject.class);
        }

        private List<VirtualRepository> refreshVirtualRepositories(ArtifactoryServer artifactoryServer, CredentialsConfig credentialsConfig, Item item) throws IOException {
            List<VirtualRepository> virtualRepositoryList = RepositoriesUtils.getVirtualRepositoryKeys(artifactoryServer.getUrl(), credentialsConfig, artifactoryServer, item);
            Collections.sort(virtualRepositoryList);
            return virtualRepositoryList;
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            RefreshServerResponse response = new RefreshServerResponse();
            CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
            ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url, this.getArtifactoryServers());
            try {
                List<String> releaseRepositoryKeysFirst = RepositoriesUtils.getLocalRepositories(url, credentialsConfig, artifactoryServer, this.item);
                Collections.sort(releaseRepositoryKeysFirst);
                List<Repository> releaseRepositoryList = RepositoriesUtils.createRepositoriesList(releaseRepositoryKeysFirst);
                response.setRepositories(releaseRepositoryList);
                response.setSuccess(true);
                return response;
            }
            catch (Exception e) {
                response.setResponseMessage(e.getMessage());
                response.setSuccess(false);
                return response;
            }
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshResolversFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            RefreshServerResponse response = new RefreshServerResponse();
            CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
            ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url, this.getArtifactoryServers());
            try {
                List<VirtualRepository> virtualRepositoryList = this.refreshVirtualRepositories(artifactoryServer, credentialsConfig, (Item)this.item);
                response.setVirtualRepositories(virtualRepositoryList);
                response.setSuccess(true);
            }
            catch (Exception e) {
                response.setResponseMessage(e.getMessage());
                response.setSuccess(false);
            }
            return response;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginCredentials(project);
        }

        public String getDisplayName() {
            return "Maven3-Artifactory Integration";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this, "maven3");
            this.save();
            return true;
        }

        public boolean isMultiConfProject() {
            return this.item.getClass().isAssignableFrom(MatrixProject.class);
        }

        public FormValidation doCheckViolationRecipients(@QueryParameter String value) {
            return FormValidations.validateEmails(value);
        }

        public FormValidation doCheckArtifactoryCombinationFilter(@QueryParameter String value) throws IOException, InterruptedException {
            return FormValidations.validateArtifactoryCombinationFilter(value);
        }

        public List<ArtifactoryServer> getArtifactoryServers() {
            return RepositoriesUtils.getArtifactoryServers();
        }

        public boolean isJiraPluginEnabled() {
            return Jenkins.getInstance().getPlugin("jira") != null;
        }

        public boolean isUseCredentialsPlugin() {
            return PluginsUtils.isUseCredentialsPlugin();
        }
    }
}

