/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven2;

import hudson.Extension;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.BuildListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.jfrog.hudson.MavenDependenciesRecord;
import org.jfrog.hudson.MavenDependency;

public class MavenDependenciesRecorder
extends MavenReporter {
    private transient Set<MavenDependency> dependencies;
    private static final long serialVersionUID = 1L;

    public boolean preBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) {
        listener.getLogger().println("[HUDSON] Collecting dependencies info");
        this.dependencies = new HashSet<MavenDependency>();
        return true;
    }

    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) {
        this.recordMavenDependencies(pom.getArtifacts());
        return true;
    }

    public boolean postBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        build.executeAsync((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Void, IOException>(){
            private final Set<MavenDependency> d;
            {
                this.d = MavenDependenciesRecorder.this.dependencies;
            }

            public Void call(MavenBuild build) throws IOException, InterruptedException {
                build.getActions().add(new MavenDependenciesRecord(build, this.d));
                return null;
            }
        });
        return true;
    }

    private void recordMavenDependencies(Set<Artifact> artifacts) {
        if (artifacts != null) {
            for (Artifact dependency : artifacts) {
                if (!dependency.isResolved() || dependency.getFile() == null) continue;
                this.dependencies.add(new MavenDependency(dependency));
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return "Record Maven Dependencies";
        }

        public MavenReporter newAutoInstance(MavenModule module) {
            return new MavenDependenciesRecorder();
        }
    }
}

