/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.ivy;

import com.google.common.collect.Iterables;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Which;
import hudson.tasks.Ant;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.listener.ArtifactoryBuildListener;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BintrayPublish.BintrayPublishAction;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.MultiConfigurationAware;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ConcurrentJobsHelper;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.FormValidations;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.PluginDependencyHelper;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ArtifactoryIvyFreeStyleConfigurator
extends BuildWrapper
implements DeployerOverrider,
BuildInfoAwareConfigurator,
MultiConfigurationAware {
    public final String remotePluginLocation;
    public final boolean deployBuildInfo;
    public final boolean includeEnvVars;
    private final CredentialsConfig deployerCredentialsConfig;
    private final boolean runChecks;
    private final String violationRecipients;
    private final boolean includePublishArtifacts;
    private final String scopes;
    private final boolean licenseAutoDiscovery;
    private final boolean disableLicenseAutoDiscovery;
    private final String ivyPattern;
    private final String artifactPattern;
    @Deprecated
    private final Boolean notM2Compatible = null;
    private final Boolean useMavenPatterns;
    private final IncludesExcludes artifactDeploymentPatterns;
    private final boolean discardOldBuilds;
    private final boolean asyncBuildRetention;
    private final boolean passIdentifiedDownstream;
    private final boolean discardBuildArtifacts;
    @Deprecated
    private final String matrixParams;
    private final String deploymentProperties;
    private final boolean enableIssueTrackerIntegration;
    private final boolean filterExcludedArtifactsFromBuild;
    @Deprecated
    private final ServerDetails details = null;
    private ServerDetails deployerDetails;
    private boolean deployArtifacts;
    private IncludesExcludes envVarsPatterns;
    private String aggregationBuildStatus;
    private boolean aggregateBuildIssues;
    private boolean blackDuckRunChecks;
    private String blackDuckAppName;
    private String blackDuckAppVersion;
    private String blackDuckReportRecipients;
    private String blackDuckScopes;
    private boolean blackDuckIncludePublishedArtifacts;
    private boolean autoCreateMissingComponentRequests;
    private boolean autoDiscardStaleComponentRequests;
    private String artifactoryCombinationFilter;
    private String customBuildName;
    private boolean overrideBuildName;
    @Deprecated
    private Credentials overridingDeployerCredentials;

    @DataBoundConstructor
    public ArtifactoryIvyFreeStyleConfigurator(ServerDetails details, ServerDetails deployerDetails, CredentialsConfig deployerCredentialsConfig, boolean deployArtifacts, String remotePluginLocation, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean deployBuildInfo, boolean runChecks, String violationRecipients, boolean includePublishArtifacts, String scopes, boolean disableLicenseAutoDiscovery, String ivyPattern, String artifactPattern, Boolean useMavenPatterns, Boolean notM2Compatible, IncludesExcludes artifactDeploymentPatterns, boolean discardOldBuilds, boolean asyncBuildRetention, boolean passIdentifiedDownstream, boolean discardBuildArtifacts, String matrixParams, String deploymentProperties, boolean enableIssueTrackerIntegration, boolean aggregateBuildIssues, String aggregationBuildStatus, boolean blackDuckRunChecks, String blackDuckAppName, String blackDuckAppVersion, String blackDuckReportRecipients, String blackDuckScopes, boolean blackDuckIncludePublishedArtifacts, boolean autoCreateMissingComponentRequests, boolean autoDiscardStaleComponentRequests, boolean filterExcludedArtifactsFromBuild, String artifactoryCombinationFilter, String customBuildName, boolean overrideBuildName) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails != null ? deployerDetails : details;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.deployArtifacts = deployArtifacts;
        this.remotePluginLocation = remotePluginLocation;
        this.includeEnvVars = includeEnvVars;
        this.envVarsPatterns = envVarsPatterns;
        this.deployBuildInfo = deployBuildInfo;
        this.runChecks = runChecks;
        this.violationRecipients = violationRecipients;
        this.includePublishArtifacts = includePublishArtifacts;
        this.scopes = scopes;
        this.disableLicenseAutoDiscovery = disableLicenseAutoDiscovery;
        this.ivyPattern = ivyPattern;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
        this.artifactPattern = this.clearApostrophes(artifactPattern);
        this.useMavenPatterns = useMavenPatterns != null ? useMavenPatterns : notM2Compatible != null && notM2Compatible == false;
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
        this.discardOldBuilds = discardOldBuilds;
        this.asyncBuildRetention = asyncBuildRetention;
        this.passIdentifiedDownstream = passIdentifiedDownstream;
        this.deploymentProperties = deploymentProperties != null ? deploymentProperties : matrixParams;
        this.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.licenseAutoDiscovery = !disableLicenseAutoDiscovery;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.blackDuckRunChecks = blackDuckRunChecks;
        this.blackDuckAppName = blackDuckAppName;
        this.blackDuckAppVersion = blackDuckAppVersion;
        this.blackDuckReportRecipients = blackDuckReportRecipients;
        this.blackDuckScopes = blackDuckScopes;
        this.blackDuckIncludePublishedArtifacts = blackDuckIncludePublishedArtifacts;
        this.autoCreateMissingComponentRequests = autoCreateMissingComponentRequests;
        this.autoDiscardStaleComponentRequests = autoDiscardStaleComponentRequests;
        this.artifactoryCombinationFilter = artifactoryCombinationFilter;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
    }

    private String clearApostrophes(String artifactPattern) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)artifactPattern, (String)"\""), (String)"\"");
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails != null ? this.deployerDetails : this.details;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties != null ? this.deploymentProperties : this.matrixParams;
    }

    public boolean isPassIdentifiedDownstream() {
        return this.passIdentifiedDownstream;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    @Override
    public String getViolationRecipients() {
        return this.violationRecipients;
    }

    public String getArtifactPattern() {
        return this.clearApostrophes(this.artifactPattern);
    }

    public String getIvyPattern() {
        return this.ivyPattern;
    }

    public IncludesExcludes getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    @Override
    public boolean isRunChecks() {
        return this.runChecks;
    }

    @Override
    public boolean isIncludePublishArtifacts() {
        return this.includePublishArtifacts;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    @Override
    public boolean isLicenseAutoDiscovery() {
        return this.licenseAutoDiscovery;
    }

    public boolean isDisableLicenseAutoDiscovery() {
        return this.disableLicenseAutoDiscovery;
    }

    @Override
    public String getScopes() {
        return this.scopes;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeployReleaseRepository().getRepoKey() : null;
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return null;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getUrl() : null;
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public boolean isUseMavenPatterns() {
        if (this.useMavenPatterns != null) {
            return this.useMavenPatterns;
        }
        return this.notM2Compatible != null && this.notM2Compatible == false;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    @Override
    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    @Override
    public boolean isBlackDuckRunChecks() {
        return this.blackDuckRunChecks;
    }

    @Override
    public String getBlackDuckAppName() {
        return this.blackDuckAppName;
    }

    @Override
    public String getBlackDuckAppVersion() {
        return this.blackDuckAppVersion;
    }

    @Override
    public String getBlackDuckReportRecipients() {
        return this.blackDuckReportRecipients;
    }

    @Override
    public String getBlackDuckScopes() {
        return this.blackDuckScopes;
    }

    @Override
    public boolean isBlackDuckIncludePublishedArtifacts() {
        return this.blackDuckIncludePublishedArtifacts;
    }

    @Override
    public boolean isAutoCreateMissingComponentRequests() {
        return this.autoCreateMissingComponentRequests;
    }

    @Override
    public boolean isAutoDiscardStaleComponentRequests() {
        return this.autoDiscardStaleComponentRequests;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    @Override
    public String getArtifactoryCombinationFilter() {
        return this.artifactoryCombinationFilter;
    }

    @Override
    public boolean isMultiConfProject() {
        return this.getDescriptor().isMultiConfProject();
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        if (this.isOverrideBuildName()) {
            return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project, this.getCustomBuildName());
        }
        return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project);
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, final Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        Ant antBuild;
        listener.getLogger().println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        PublisherContext.Builder publisherBuilder = this.getBuilder();
        RepositoriesUtils.validateServerConfig(build, listener, this.getArtifactoryServer(), this.getArtifactoryUrl());
        int totalBuilds = 1;
        if (this.isMultiConfProject(build)) {
            totalBuilds = ((MatrixProject)build.getParent().getParent()).getActiveConfigurations().size();
            if (this.isDeployArtifacts()) {
                MultiConfigurationUtils.validateCombinationFilter(build, listener, this.getArtifactoryCombinationFilter());
                boolean isFiltered = MultiConfigurationUtils.isfiltrated(build, this.getArtifactoryCombinationFilter());
                if (isFiltered) {
                    publisherBuilder.skipBuildInfoDeploy(true).deployArtifacts(false);
                }
            }
        }
        if ((antBuild = this.getLastAntBuild(build.getProject())) != null) {
            new ConcurrentJobsHelper.ConcurrentBuildSetupSync(build, totalBuilds){

                @Override
                public void setUp() {
                    ConcurrentJobsHelper.ConcurrentBuild concurrentBuild = ConcurrentJobsHelper.getConcurrentBuild(build);
                    String targets = antBuild.getTargets() != null ? antBuild.getTargets().replace(ArtifactoryIvyFreeStyleConfigurator.this.getAntArgs(), "") : "";
                    concurrentBuild.putParam("targets", targets);
                    ArtifactoryIvyFreeStyleConfigurator.this.setTargetsField(antBuild, targets + " " + ArtifactoryIvyFreeStyleConfigurator.this.getAntArgs());
                }
            };
        }
        build.setResult(Result.SUCCESS);
        final PublisherContext finalPublisherContext = publisherBuilder.build();
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                super.buildEnvVars(env);
                try {
                    String actualDependencyDirPath = ArtifactoryIvyFreeStyleConfigurator.this.actualDependencyDirPath(build, launcher);
                    env.put("ARTIFACTORY_CACHE_LIBS", actualDependencyDirPath);
                    ExtractorUtils.addBuilderInfoArguments(env, (Run)build, (TaskListener)listener, finalPublisherContext, null, build.getWorkspace(), launcher);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean tearDown(final AbstractBuild build2, BuildListener listener2) throws IOException, InterruptedException {
                Result result = build2.getResult();
                if (antBuild != null) {
                    new ConcurrentJobsHelper.ConcurrentBuildTearDownSync(build2, result){

                        @Override
                        public void tearDown() {
                            ConcurrentJobsHelper.ConcurrentBuild concurrentBuild = ConcurrentJobsHelper.getConcurrentBuild(build2);
                            String targets = concurrentBuild.getParam("targets");
                            targets = targets.replace(ArtifactoryIvyFreeStyleConfigurator.this.getAntArgs(), "");
                            ArtifactoryIvyFreeStyleConfigurator.this.setTargetsField(antBuild, targets);
                        }
                    };
                }
                if (!finalPublisherContext.isSkipBuildInfoDeploy() && (result == null || result.isBetterOrEqualTo(Result.SUCCESS))) {
                    String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(ArtifactoryIvyFreeStyleConfigurator.this, (Run)build2);
                    build2.getActions().add(0, new BuildInfoResultAction(ArtifactoryIvyFreeStyleConfigurator.this.getArtifactoryUrl(), (Run)build2, buildName));
                    build2.getActions().add(new UnifiedPromoteBuildAction((Run)build2, ArtifactoryIvyFreeStyleConfigurator.this));
                    if (PluginsUtils.isPushToBintrayEnabled()) {
                        build2.getActions().add(new BintrayPublishAction<ArtifactoryIvyFreeStyleConfigurator>(build2, ArtifactoryIvyFreeStyleConfigurator.this));
                    }
                }
                if (Result.ABORTED.equals(result)) {
                    ConcurrentJobsHelper.removeConcurrentBuildJob(build2);
                }
                return true;
            }
        };
    }

    private String actualDependencyDirPath(AbstractBuild build, Launcher launcher) throws IOException, InterruptedException {
        File localDependencyFile = Which.jarFile(ArtifactoryBuildListener.class);
        FilePath actualDependencyDir = PluginDependencyHelper.getActualDependencyDirectory(localDependencyFile, ActionableHelper.getNode(launcher).getRootPath());
        String actualDependencyDirPath = actualDependencyDir.getRemote();
        actualDependencyDirPath = actualDependencyDirPath.replace('\\', '/');
        actualDependencyDirPath = "\"" + actualDependencyDirPath + "\"";
        return actualDependencyDirPath;
    }

    private void setTargetsField(Ant builder, String targets) {
        try {
            Field targetsField = builder.getClass().getDeclaredField("targets");
            targetsField.setAccessible(true);
            targetsField.set(builder, targets);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getAntArgs() {
        String lib = "-lib ${ARTIFACTORY_CACHE_LIBS} ";
        String listener = "-listener org.jfrog.build.extractor.listener.ArtifactoryBuildListener";
        return lib + listener;
    }

    private Ant getLastAntBuild(AbstractProject project) {
        if (project instanceof Project) {
            List<Ant> ants = ActionableHelper.getBuilder((Project)project, Ant.class);
            return (Ant)Iterables.getLast(ants, null);
        }
        return null;
    }

    private PublisherContext.Builder getBuilder() {
        return new PublisherContext.Builder().artifactoryServer(this.getArtifactoryServer()).serverDetails(this.getDeployerDetails()).deployerOverrider(this).runChecks(this.isRunChecks()).includePublishArtifacts(this.isIncludePublishArtifacts()).violationRecipients(this.getViolationRecipients()).scopes(this.getScopes()).licenseAutoDiscovery(this.isLicenseAutoDiscovery()).discardOldBuilds(this.isDiscardOldBuilds()).deployArtifacts(this.isDeployArtifacts()).includesExcludes(this.getArtifactDeploymentPatterns()).skipBuildInfoDeploy(!this.isDeployBuildInfo()).includeEnvVars(this.isIncludeEnvVars()).envVarsPatterns(this.getEnvVarsPatterns()).discardBuildArtifacts(this.isDiscardBuildArtifacts()).asyncBuildRetention(this.isAsyncBuildRetention()).deploymentProperties(this.getDeploymentProperties()).maven2Compatible(this.isUseMavenPatterns()).artifactsPattern(this.getArtifactPattern()).ivyPattern(this.getIvyPattern()).enableIssueTrackerIntegration(this.isEnableIssueTrackerIntegration()).aggregateBuildIssues(this.isAggregateBuildIssues()).aggregationBuildStatus(this.getAggregationBuildStatus()).integrateBlackDuck(this.isBlackDuckRunChecks(), this.getBlackDuckAppName(), this.getBlackDuckAppVersion(), this.getBlackDuckReportRecipients(), this.getBlackDuckScopes(), this.isBlackDuckIncludePublishedArtifacts(), this.isAutoCreateMissingComponentRequests(), this.isAutoDiscardStaleComponentRequests()).filterExcludedArtifactsFromBuild(this.isFilterExcludedArtifactsFromBuild()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).overrideBuildName(this.isOverrideBuildName()).customBuildName(this.getCustomBuildName());
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName(), this.getDescriptor().getArtifactoryServers());
    }

    public List<Repository> getReleaseRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeploySnapshotRepository().getKeyFromSelect());
    }

    private boolean isMultiConfProject(AbstractBuild build) {
        return build.getProject().getClass().equals(MatrixConfiguration.class);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        private AbstractProject<?, ?> item;

        public DescriptorImpl() {
            super(ArtifactoryIvyFreeStyleConfigurator.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            this.item = item;
            return item.getClass().isAssignableFrom(FreeStyleProject.class) || item.getClass().isAssignableFrom(MatrixProject.class) || Jenkins.getInstance().getPlugin("jenkins-multijob-plugin") != null && item.getClass().isAssignableFrom(MultiJobProject.class);
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            RefreshServerResponse response = new RefreshServerResponse();
            CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
            ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url, RepositoriesUtils.getArtifactoryServers());
            try {
                List<String> releaseRepositoryKeysFirst = RepositoriesUtils.getLocalRepositories(url, credentialsConfig, artifactoryServer, this.item);
                Collections.sort(releaseRepositoryKeysFirst);
                List<Repository> releaseRepositoryList = RepositoriesUtils.createRepositoriesList(releaseRepositoryKeysFirst);
                response.setRepositories(releaseRepositoryList);
                response.setSuccess(true);
            }
            catch (Exception e) {
                response.setResponseMessage(e.getMessage());
                response.setSuccess(false);
            }
            return response;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginCredentials(project);
        }

        public String getDisplayName() {
            return "Ant/Ivy-Artifactory Integration";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this, "ivy");
            this.save();
            return true;
        }

        public boolean isMultiConfProject() {
            return this.item.getClass().isAssignableFrom(MatrixProject.class);
        }

        public FormValidation doCheckViolationRecipients(@QueryParameter String value) {
            return FormValidations.validateEmails(value);
        }

        public FormValidation doCheckArtifactoryCombinationFilter(@QueryParameter String value) throws IOException, InterruptedException {
            return FormValidations.validateArtifactoryCombinationFilter(value);
        }

        public List<ArtifactoryServer> getArtifactoryServers() {
            return RepositoriesUtils.getArtifactoryServers();
        }

        public boolean isUseCredentialsPlugin() {
            return PluginsUtils.isUseCredentialsPlugin();
        }

        public boolean isJiraPluginEnabled() {
            return Jenkins.getInstance().getPlugin("jira") != null;
        }
    }
}

