/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.gradle;

import com.google.common.base.Charsets;
import hudson.FilePath;
import hudson.remoting.Which;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jfrog.hudson.util.PluginDependencyHelper;

public class GradleInitScriptWriter {
    private FilePath rootPath;

    public GradleInitScriptWriter(FilePath rootPath) {
        this.rootPath = rootPath;
    }

    public String generateInitScript() throws URISyntaxException, IOException, InterruptedException {
        StringBuilder initScript = new StringBuilder();
        InputStream templateStream = this.getClass().getResourceAsStream("/initscripttemplate.gradle");
        String templateAsString = IOUtils.toString((InputStream)templateStream, (String)Charsets.UTF_8.name());
        File localGradleExtractorJar = Which.jarFile((URL)this.getClass().getResource("/initscripttemplate.gradle"));
        FilePath dependencyDir = PluginDependencyHelper.getActualDependencyDirectory(localGradleExtractorJar, this.rootPath);
        String absoluteDependencyDirPath = dependencyDir.getRemote();
        absoluteDependencyDirPath = absoluteDependencyDirPath.replace("\\", "/");
        String str = templateAsString.replace("${pluginLibDir}", absoluteDependencyDirPath);
        initScript.append(str);
        return initScript.toString();
    }
}

