/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.gradle;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.BuildableItem;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.gradle.Gradle;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BintrayPublish.BintrayPublishAction;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.MultiConfigurationAware;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.UserPluginInfoParam;
import org.jfrog.hudson.VirtualRepository;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.action.ArtifactoryProjectAction;
import org.jfrog.hudson.gradle.GradleInitScriptWriter;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.gradle.BaseGradleReleaseAction;
import org.jfrog.hudson.release.gradle.GradleReleaseAction;
import org.jfrog.hudson.release.gradle.GradleReleaseApiAction;
import org.jfrog.hudson.release.gradle.GradleReleaseWrapper;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ConcurrentJobsHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.FormValidations;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.ResolverContext;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ArtifactoryGradleConfigurator
extends BuildWrapper
implements DeployerOverrider,
ResolverOverrider,
BuildInfoAwareConfigurator,
MultiConfigurationAware {
    public final boolean deployMaven;
    public final boolean deployIvy;
    public final String remotePluginLocation;
    public final boolean deployBuildInfo;
    public final boolean includeEnvVars;
    private final CredentialsConfig deployerCredentialsConfig;
    private final CredentialsConfig resolverCredentialsConfig;
    private final boolean runChecks;
    private final String violationRecipients;
    private final boolean includePublishArtifacts;
    private final String scopes;
    private final boolean licenseAutoDiscovery;
    private final boolean disableLicenseAutoDiscovery;
    private final String ivyPattern;
    private final boolean enableIssueTrackerIntegration;
    private final boolean aggregateBuildIssues;
    private final String artifactPattern;
    @Deprecated
    private final Boolean notM2Compatible = null;
    private final Boolean useMavenPatterns;
    private final IncludesExcludes artifactDeploymentPatterns;
    private final boolean discardOldBuilds;
    private final boolean passIdentifiedDownstream;
    private final GradleReleaseWrapper releaseWrapper;
    private final boolean discardBuildArtifacts;
    private final boolean asyncBuildRetention;
    @Deprecated
    private final String matrixParams;
    private final String deploymentProperties;
    @Deprecated
    private final Boolean skipInjectInitScript = null;
    private final Boolean useArtifactoryGradlePlugin;
    private final boolean allowPromotionOfNonStagedBuilds;
    private final boolean allowBintrayPushOfNonStageBuilds;
    private final boolean blackDuckRunChecks;
    private final String blackDuckAppName;
    private final String blackDuckAppVersion;
    private final boolean filterExcludedArtifactsFromBuild;
    private final ServerDetails resolverDetails;
    private String defaultPromotionTargetRepository;
    @Deprecated
    private ServerDetails details = null;
    private ServerDetails deployerDetails;
    private boolean deployArtifacts;
    private IncludesExcludes envVarsPatterns;
    private String aggregationBuildStatus;
    private String blackDuckReportRecipients;
    private String blackDuckScopes;
    private boolean blackDuckIncludePublishedArtifacts;
    private boolean autoCreateMissingComponentRequests;
    private boolean autoDiscardStaleComponentRequests;
    private String artifactoryCombinationFilter;
    private String customBuildName;
    private boolean overrideBuildName;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private Credentials overridingResolverCredentials;

    @DataBoundConstructor
    public ArtifactoryGradleConfigurator(ServerDetails details, ServerDetails deployerDetails, ServerDetails resolverDetails, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, boolean deployMaven, boolean deployIvy, boolean deployArtifacts, String remotePluginLocation, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean deployBuildInfo, boolean runChecks, String violationRecipients, boolean includePublishArtifacts, String scopes, boolean disableLicenseAutoDiscovery, String ivyPattern, String artifactPattern, Boolean useMavenPatterns, Boolean notM2Compatible, IncludesExcludes artifactDeploymentPatterns, boolean discardOldBuilds, boolean passIdentifiedDownstream, GradleReleaseWrapper releaseWrapper, boolean discardBuildArtifacts, boolean asyncBuildRetention, String matrixParams, String deploymentProperties, Boolean skipInjectInitScript, Boolean useArtifactoryGradlePlugin, boolean enableIssueTrackerIntegration, boolean aggregateBuildIssues, String aggregationBuildStatus, boolean allowPromotionOfNonStagedBuilds, String defaultPromotionTargetRepository, boolean allowBintrayPushOfNonStageBuilds, boolean blackDuckRunChecks, String blackDuckAppName, String blackDuckAppVersion, String blackDuckReportRecipients, String blackDuckScopes, boolean blackDuckIncludePublishedArtifacts, boolean autoCreateMissingComponentRequests, boolean autoDiscardStaleComponentRequests, boolean filterExcludedArtifactsFromBuild, String artifactoryCombinationFilter, String customBuildName, boolean overrideBuildName) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails != null ? deployerDetails : details;
        this.resolverDetails = resolverDetails;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.deployMaven = deployMaven;
        this.deployIvy = deployIvy;
        this.deployArtifacts = deployArtifacts;
        this.remotePluginLocation = remotePluginLocation;
        this.includeEnvVars = includeEnvVars;
        this.envVarsPatterns = envVarsPatterns;
        this.deployBuildInfo = deployBuildInfo;
        this.runChecks = runChecks;
        this.violationRecipients = violationRecipients;
        this.includePublishArtifacts = includePublishArtifacts;
        this.scopes = scopes;
        this.disableLicenseAutoDiscovery = disableLicenseAutoDiscovery;
        this.ivyPattern = ivyPattern;
        this.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
        this.artifactPattern = this.cleanString(artifactPattern);
        this.useMavenPatterns = useMavenPatterns != null ? useMavenPatterns : notM2Compatible != null && notM2Compatible == false;
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
        this.discardOldBuilds = discardOldBuilds;
        this.passIdentifiedDownstream = passIdentifiedDownstream;
        this.releaseWrapper = releaseWrapper;
        this.asyncBuildRetention = asyncBuildRetention;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.deploymentProperties = deploymentProperties != null ? deploymentProperties : matrixParams;
        this.useArtifactoryGradlePlugin = useArtifactoryGradlePlugin != null ? useArtifactoryGradlePlugin : skipInjectInitScript;
        this.licenseAutoDiscovery = !disableLicenseAutoDiscovery;
        this.allowPromotionOfNonStagedBuilds = allowPromotionOfNonStagedBuilds;
        this.defaultPromotionTargetRepository = defaultPromotionTargetRepository;
        this.blackDuckRunChecks = blackDuckRunChecks;
        this.allowBintrayPushOfNonStageBuilds = allowBintrayPushOfNonStageBuilds;
        this.blackDuckAppName = blackDuckAppName;
        this.blackDuckAppVersion = blackDuckAppVersion;
        this.blackDuckReportRecipients = blackDuckReportRecipients;
        this.blackDuckScopes = blackDuckScopes;
        this.blackDuckIncludePublishedArtifacts = blackDuckIncludePublishedArtifacts;
        this.autoCreateMissingComponentRequests = autoCreateMissingComponentRequests;
        this.autoDiscardStaleComponentRequests = autoDiscardStaleComponentRequests;
        this.artifactoryCombinationFilter = artifactoryCombinationFilter;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
    }

    public GradleReleaseWrapper getReleaseWrapper() {
        return this.releaseWrapper;
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails != null ? this.deployerDetails : this.details;
    }

    public ServerDetails getResolverDetails() {
        return this.resolverDetails;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties != null ? this.deploymentProperties : this.matrixParams;
    }

    public boolean isPassIdentifiedDownstream() {
        return this.passIdentifiedDownstream;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    public boolean isUseArtifactoryGradlePlugin() {
        if (this.useArtifactoryGradlePlugin != null) {
            return this.useArtifactoryGradlePlugin;
        }
        if (this.skipInjectInitScript != null) {
            return this.skipInjectInitScript;
        }
        return false;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    @Override
    public String getViolationRecipients() {
        return this.violationRecipients;
    }

    public String getArtifactPattern() {
        return this.cleanString(this.artifactPattern);
    }

    public String getIvyPattern() {
        return this.ivyPattern;
    }

    public IncludesExcludes getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    @Override
    public boolean isRunChecks() {
        return this.runChecks;
    }

    @Override
    public boolean isIncludePublishArtifacts() {
        return this.includePublishArtifacts;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    @Override
    public boolean isLicenseAutoDiscovery() {
        return this.licenseAutoDiscovery;
    }

    public boolean isDisableLicenseAutoDiscovery() {
        return this.disableLicenseAutoDiscovery;
    }

    @Override
    public String getScopes() {
        return this.scopes;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeployReleaseRepository().getRepoKey() : null;
    }

    public String getUserPluginKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getUserPluginKey() : null;
    }

    public String getDownloadReleaseRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getResolveReleaseRepository().getRepoKey() : null;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryResolverName() {
        return this.resolverDetails != null ? this.resolverDetails.artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getUrl() : null;
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public boolean isDeployMaven() {
        return this.deployMaven;
    }

    public boolean isDeployIvy() {
        return this.deployIvy;
    }

    public boolean isUseMavenPatterns() {
        if (this.useMavenPatterns != null) {
            return this.useMavenPatterns;
        }
        return this.notM2Compatible != null && this.notM2Compatible == false;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    @Override
    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public boolean isAllowPromotionOfNonStagedBuilds() {
        return this.allowPromotionOfNonStagedBuilds;
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return this.defaultPromotionTargetRepository;
    }

    public void setDefaultPromotionTargetRepository(String defaultPromotionTargetRepository) {
        this.defaultPromotionTargetRepository = defaultPromotionTargetRepository;
    }

    public boolean isAllowBintrayPushOfNonStageBuilds() {
        return this.allowBintrayPushOfNonStageBuilds;
    }

    @Override
    public boolean isBlackDuckRunChecks() {
        return this.blackDuckRunChecks;
    }

    @Override
    public String getBlackDuckAppName() {
        return this.blackDuckAppName;
    }

    @Override
    public String getBlackDuckAppVersion() {
        return this.blackDuckAppVersion;
    }

    @Override
    public String getBlackDuckReportRecipients() {
        return this.blackDuckReportRecipients;
    }

    @Override
    public String getBlackDuckScopes() {
        return this.blackDuckScopes;
    }

    @Override
    public boolean isBlackDuckIncludePublishedArtifacts() {
        return this.blackDuckIncludePublishedArtifacts;
    }

    @Override
    public boolean isAutoCreateMissingComponentRequests() {
        return this.autoCreateMissingComponentRequests;
    }

    @Override
    public boolean isAutoDiscardStaleComponentRequests() {
        return this.autoDiscardStaleComponentRequests;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    @Override
    public String getArtifactoryCombinationFilter() {
        return this.artifactoryCombinationFilter;
    }

    @Override
    public boolean isMultiConfProject() {
        return this.getDescriptor().isMultiConfProject();
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    private String cleanString(String artifactPattern) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)artifactPattern, (String)"\""), (String)"\"");
    }

    public Action getProjectAction(AbstractProject job) {
        return super.getProjectAction(job);
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        List<ArtifactoryProjectAction> action = null;
        action = this.isOverrideBuildName() ? ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project, this.getCustomBuildName()) : ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project);
        if (this.getReleaseWrapper() != null) {
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.addAll(action);
            actions.add(new GradleReleaseAction(project));
            actions.add(new GradleReleaseApiAction(project));
            return actions;
        }
        return action;
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, final Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        Gradle gradleBuild;
        final PrintStream log = listener.getLogger();
        log.println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        PublisherContext.Builder publisherBuilder = this.getBuilder();
        RepositoriesUtils.validateServerConfig(build, listener, this.getArtifactoryServer(), this.getArtifactoryUrl());
        int totalBuilds = 1;
        if (this.isMultiConfProject(build)) {
            totalBuilds = ((MatrixProject)build.getParent().getParent()).getActiveConfigurations().size();
            if (this.isDeployArtifacts()) {
                if (StringUtils.isBlank((String)this.getArtifactoryCombinationFilter())) {
                    String error = "The field \"Combination Matches\" is empty, but is defined as mandatory!";
                    log.println(error);
                    build.setResult(Result.FAILURE);
                    throw new IllegalArgumentException(error);
                }
                boolean isFiltered = MultiConfigurationUtils.isfiltrated(build, this.getArtifactoryCombinationFilter());
                if (isFiltered) {
                    publisherBuilder.skipBuildInfoDeploy(true).deployArtifacts(false);
                }
            }
        }
        if (this.isRelease(build)) {
            this.releaseWrapper.setUp(build, launcher, listener);
        }
        if ((gradleBuild = this.getLastGradleBuild(build.getProject())) != null) {
            new ConcurrentJobsHelper.ConcurrentBuildSetupSync(build, totalBuilds){

                @Override
                public void setUp() {
                    ConcurrentJobsHelper.ConcurrentBuild concurrentBuild = ConcurrentJobsHelper.getConcurrentBuild(build);
                    String switches = gradleBuild.getSwitches() != null ? gradleBuild.getSwitches().replace("${ARTIFACTORY_INIT_SCRIPT}", "") : "";
                    String tasks = gradleBuild.getTasks() != null ? gradleBuild.getTasks().replace("${ARTIFACTORY_TASKS}", "") : "";
                    concurrentBuild.putParam("switches", switches);
                    concurrentBuild.putParam("tasks", tasks);
                    if (!ArtifactoryGradleConfigurator.this.isUseArtifactoryGradlePlugin()) {
                        ArtifactoryGradleConfigurator.this.setTargetsField(gradleBuild, "switches", switches + " ${ARTIFACTORY_INIT_SCRIPT}");
                    }
                    if (!StringUtils.contains((String)gradleBuild.getTasks(), (String)"artifactoryPublish")) {
                        tasks = ArtifactoryGradleConfigurator.this.isRelease(build) && StringUtils.isNotBlank((String)ArtifactoryGradleConfigurator.this.releaseWrapper.getAlternativeTasks()) ? "${ARTIFACTORY_TASKS}" : tasks + " ${ARTIFACTORY_TASKS}";
                        ArtifactoryGradleConfigurator.this.setTargetsField(gradleBuild, "tasks", tasks);
                    }
                }
            };
        } else {
            log.println("[Warning] No Gradle build configured");
        }
        final PublisherContext.Builder finalPublisherBuilder = publisherBuilder;
        return new BuildWrapper.Environment(){
            String initScriptPath;

            public void buildEnvVars(Map<String, String> env) {
                String alternativeGoals;
                GradleInitScriptWriter writer = new GradleInitScriptWriter(ActionableHelper.getNode(launcher).getRootPath());
                FilePath workspace = build.getWorkspace();
                try {
                    FilePath initScript = workspace.createTextTempFile("init-artifactory", "gradle", writer.generateInitScript(), false);
                    ActionableHelper.deleteFilePathOnExit(initScript);
                    this.initScriptPath = initScript.getRemote();
                    this.initScriptPath = this.initScriptPath.replace('\\', '/');
                    env.put("ARTIFACTORY_INIT_SCRIPT", " --init-script " + this.initScriptPath);
                }
                catch (Exception e) {
                    log.println("Error occurred while writing Gradle Init Script: " + e.getMessage());
                    build.setResult(Result.FAILURE);
                }
                String tasks = "";
                if (ArtifactoryGradleConfigurator.this.isRelease(build) && StringUtils.isNotBlank((String)(alternativeGoals = ArtifactoryGradleConfigurator.this.releaseWrapper.getAlternativeTasks()))) {
                    tasks = alternativeGoals;
                }
                env.put("ARTIFACTORY_TASKS", tasks + " " + "artifactoryPublish");
                ServerDetails serverDetails = ArtifactoryGradleConfigurator.this.getDeployerDetails();
                serverDetails = this.releaseActionOverride(env, serverDetails);
                finalPublisherBuilder.serverDetails(serverDetails);
                ServerDetails resolverServerDetails = ArtifactoryGradleConfigurator.this.getResolverDetails();
                ResolverContext resolverContext = null;
                if (StringUtils.isNotBlank((String)resolverServerDetails.getResolveReleaseRepository().getRepoKey())) {
                    CredentialsConfig resolverCredentials = CredentialManager.getPreferredResolver(ArtifactoryGradleConfigurator.this, ArtifactoryGradleConfigurator.this.getArtifactoryServer());
                    resolverContext = new ResolverContext(ArtifactoryGradleConfigurator.this.getArtifactoryResolverServer(), resolverServerDetails, resolverCredentials.getCredentials((Item)build.getProject()), ArtifactoryGradleConfigurator.this);
                }
                try {
                    ExtractorUtils.addBuilderInfoArguments(env, (Run)build, (TaskListener)listener, finalPublisherBuilder.build(), resolverContext, build.getWorkspace(), launcher);
                }
                catch (Exception e) {
                    log.println(e.getMessage());
                    throw new RuntimeException(e);
                }
            }

            public boolean tearDown(final AbstractBuild build2, BuildListener listener2) throws IOException, InterruptedException {
                boolean success = false;
                boolean releaseSuccess = true;
                Result result = build2.getResult();
                if (ArtifactoryGradleConfigurator.this.isRelease(build2)) {
                    releaseSuccess = ArtifactoryGradleConfigurator.this.releaseWrapper.tearDown(build2, listener2);
                }
                if (gradleBuild != null) {
                    new ConcurrentJobsHelper.ConcurrentBuildTearDownSync(build2, result){

                        @Override
                        public void tearDown() {
                            ConcurrentJobsHelper.ConcurrentBuild concurrentBuild = ConcurrentJobsHelper.getConcurrentBuild(build2);
                            String switches = concurrentBuild.getParam("switches");
                            String tasks = concurrentBuild.getParam("tasks");
                            switches = switches.replace("${ARTIFACTORY_INIT_SCRIPT}", "");
                            tasks = tasks.replace("${ARTIFACTORY_TASKS}", "");
                            ArtifactoryGradleConfigurator.this.setTargetsField(gradleBuild, "switches", switches);
                            ArtifactoryGradleConfigurator.this.setTargetsField(gradleBuild, "tasks", tasks);
                            try {
                                ActionableHelper.deleteFilePath(build2.getWorkspace(), initScriptPath);
                            }
                            catch (IOException e) {
                                log.println(e.getStackTrace());
                            }
                        }
                    };
                }
                if (result != null && result.isBetterOrEqualTo(Result.SUCCESS)) {
                    if (ArtifactoryGradleConfigurator.this.isDeployBuildInfo()) {
                        String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(ArtifactoryGradleConfigurator.this, (Run)build2);
                        build2.getActions().add(new BuildInfoResultAction(ArtifactoryGradleConfigurator.this.getArtifactoryUrl(), (Run)build2, buildName));
                        ArtifactoryGradleConfigurator configurator = ActionableHelper.getBuildWrapper((BuildableItem)build2.getProject(), ArtifactoryGradleConfigurator.class);
                        if (configurator != null) {
                            if (ArtifactoryGradleConfigurator.this.isAllowPromotionOfNonStagedBuilds()) {
                                build2.getActions().add(new UnifiedPromoteBuildAction((Run)build2, ArtifactoryGradleConfigurator.this));
                            }
                            if (PluginsUtils.isPushToBintrayEnabled() && ArtifactoryGradleConfigurator.this.isAllowBintrayPushOfNonStageBuilds()) {
                                build2.getActions().add(new BintrayPublishAction<ArtifactoryGradleConfigurator>(build2, ArtifactoryGradleConfigurator.this));
                            }
                        }
                    }
                    success = true;
                }
                if (Result.ABORTED.equals(result)) {
                    ConcurrentJobsHelper.removeConcurrentBuildJob(build2);
                }
                return success && releaseSuccess;
            }

            private ServerDetails releaseActionOverride(Map<String, String> env, ServerDetails serverDetails) {
                ReleaseAction releaseAction = ActionableHelper.getLatestAction((Run)build, ReleaseAction.class);
                if (releaseAction != null) {
                    releaseAction.addVars(env);
                    String stagingRepository = releaseAction.getStagingRepositoryKey();
                    if (StringUtils.isBlank((String)stagingRepository)) {
                        stagingRepository = ArtifactoryGradleConfigurator.this.getRepositoryKey();
                    }
                    serverDetails = new ServerDetails(serverDetails.artifactoryName, serverDetails.getArtifactoryUrl(), new RepositoryConf(stagingRepository, stagingRepository, false), serverDetails.getDeploySnapshotRepository(), serverDetails.getResolveReleaseRepository(), serverDetails.getResolveSnapshotRepository());
                }
                return serverDetails;
            }
        };
    }

    private PublisherContext.Builder getBuilder() {
        return new PublisherContext.Builder().artifactoryServer(this.getArtifactoryServer()).deployerOverrider(this).runChecks(this.isRunChecks()).includePublishArtifacts(this.isIncludePublishArtifacts()).violationRecipients(this.getViolationRecipients()).scopes(this.getScopes()).licenseAutoDiscovery(this.isLicenseAutoDiscovery()).discardOldBuilds(this.isDiscardOldBuilds()).deployArtifacts(this.isDeployArtifacts()).includesExcludes(this.getArtifactDeploymentPatterns()).skipBuildInfoDeploy(!this.isDeployBuildInfo()).includeEnvVars(this.isIncludeEnvVars()).envVarsPatterns(this.getEnvVarsPatterns()).discardBuildArtifacts(this.isDiscardBuildArtifacts()).asyncBuildRetention(this.isAsyncBuildRetention()).deploymentProperties(this.getDeploymentProperties()).artifactsPattern(this.getArtifactPattern()).ivyPattern(this.getIvyPattern()).deployIvy(this.isDeployIvy()).deployMaven(this.isDeployMaven()).maven2Compatible(this.isUseMavenPatterns()).enableIssueTrackerIntegration(this.isEnableIssueTrackerIntegration()).aggregateBuildIssues(this.isAggregateBuildIssues()).aggregationBuildStatus(this.getAggregationBuildStatus()).integrateBlackDuck(this.isBlackDuckRunChecks(), this.getBlackDuckAppName(), this.getBlackDuckAppVersion(), this.getBlackDuckReportRecipients(), this.getBlackDuckScopes(), this.isBlackDuckIncludePublishedArtifacts(), this.isAutoCreateMissingComponentRequests(), this.isAutoDiscardStaleComponentRequests()).filterExcludedArtifactsFromBuild(this.isFilterExcludedArtifactsFromBuild()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).overrideBuildName(this.isOverrideBuildName()).customBuildName(this.getCustomBuildName());
    }

    public boolean isRelease(AbstractBuild build) {
        boolean actionExists = build.getAction(GradleReleaseAction.class) != null || build.getAction(GradleReleaseApiAction.class) != null;
        return this.getReleaseWrapper() != null && actionExists;
    }

    private Gradle getLastGradleBuild(AbstractProject project) {
        if (project instanceof Project) {
            List<Gradle> gradles = ActionableHelper.getBuilder((Project)project, Gradle.class);
            return (Gradle)Iterables.getLast(gradles, null);
        }
        return null;
    }

    private void setTargetsField(Gradle builder, String fieldName, String value) {
        try {
            Field targetsField = builder.getClass().getDeclaredField(fieldName);
            targetsField.setAccessible(true);
            targetsField.set(builder, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName(), this.getDescriptor().getArtifactoryServers());
    }

    public ArtifactoryServer getArtifactoryResolverServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryResolverName(), this.getDescriptor().getArtifactoryServers());
    }

    public List<Repository> getReleaseRepositories() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeployReleaseRepository().getKeyFromSelect());
    }

    public List<VirtualRepository> getVirtualRepositories() {
        return RepositoriesUtils.collectVirtualRepositories(null, this.resolverDetails.getResolveSnapshotRepository().getKeyFromSelect());
    }

    @Override
    public boolean isOverridingDefaultResolver() {
        return this.resolverCredentialsConfig != null && this.resolverCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingResolverCredentials() {
        return this.overridingResolverCredentials;
    }

    @Override
    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public List<UserPluginInfo> getStagingUserPluginInfo() {
        ArtifactoryServer artifactoryServer = this.getArtifactoryServer();
        return artifactoryServer.getStagingUserPluginInfo(this, null);
    }

    public PluginSettings getSelectedStagingPlugin() {
        return this.getDeployerDetails().getStagingPlugin();
    }

    private boolean isMultiConfProject(AbstractBuild build) {
        return build.getProject().getClass().equals(MatrixConfiguration.class);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension
    public static final class ReleaseRunListener
    extends RunListener<AbstractBuild> {
        public void onCompleted(AbstractBuild run, TaskListener listener) {
            if (!(run instanceof FreeStyleBuild)) {
                return;
            }
            BaseGradleReleaseAction releaseAction = (BaseGradleReleaseAction)run.getAction(GradleReleaseAction.class);
            if (releaseAction == null) {
                releaseAction = (BaseGradleReleaseAction)run.getAction(GradleReleaseApiAction.class);
            }
            if (releaseAction == null) {
                return;
            }
            ArtifactoryGradleConfigurator wrapper = ActionableHelper.getBuildWrapper((BuildableItem)((BuildableItemWithBuildWrappers)run.getProject()), ArtifactoryGradleConfigurator.class);
            Result result = run.getResult();
            boolean successRun = result.isBetterOrEqualTo(Result.SUCCESS);
            if (!wrapper.isAllowPromotionOfNonStagedBuilds() && successRun) {
                run.addAction((Action)new UnifiedPromoteBuildAction((Run)run, wrapper));
            }
            if (PluginsUtils.isPushToBintrayEnabled() && !wrapper.isAllowBintrayPushOfNonStageBuilds() && successRun) {
                run.addAction(new BintrayPublishAction<ArtifactoryGradleConfigurator>(run, wrapper));
            }
            try {
                wrapper.getReleaseWrapper().getScmCoordinator().buildCompleted();
            }
            catch (Exception e) {
                run.setResult(Result.FAILURE);
                listener.error("[RELEASE] Failed on build completion");
                e.printStackTrace(listener.getLogger());
            }
            releaseAction.reset();
            run.getActions().remove(releaseAction);
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        private AbstractProject<?, ?> item;

        public DescriptorImpl() {
            super(ArtifactoryGradleConfigurator.class);
            this.load();
        }

        protected DescriptorImpl(Class<? extends BuildWrapper> clazz) {
            super(clazz);
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            this.item = item;
            return item.getClass().isAssignableFrom(FreeStyleProject.class) || item.getClass().isAssignableFrom(MatrixProject.class) || Jenkins.getInstance().getPlugin("jenkins-multijob-plugin") != null && item.getClass().isAssignableFrom(MultiJobProject.class);
        }

        private List<Repository> refreshRepositories(ArtifactoryServer artifactoryServer, CredentialsConfig credentialsConfig) throws IOException {
            List<String> releaseRepositoryKeysFirst = RepositoriesUtils.getLocalRepositories(artifactoryServer.getUrl(), credentialsConfig, artifactoryServer, this.item);
            Collections.sort(releaseRepositoryKeysFirst);
            List<Repository> releaseRepositories = RepositoriesUtils.createRepositoriesList(releaseRepositoryKeysFirst);
            return releaseRepositories;
        }

        private List<VirtualRepository> refreshVirtualRepositories(ArtifactoryServer artifactoryServer, CredentialsConfig credentialsConfig) throws IOException {
            List<VirtualRepository> virtualRepositories = RepositoriesUtils.getVirtualRepositoryKeys(artifactoryServer.getUrl(), credentialsConfig, artifactoryServer, this.item);
            Collections.sort(virtualRepositories);
            return virtualRepositories;
        }

        private List<PluginSettings> refreshUserPlugins(ArtifactoryServer artifactoryServer, final CredentialsConfig credentialsConfigs) {
            List<UserPluginInfo> pluginInfoList = artifactoryServer.getStagingUserPluginInfo(new DeployerOverrider(){

                @Override
                public boolean isOverridingDefaultDeployer() {
                    return credentialsConfigs != null && credentialsConfigs.isCredentialsProvided();
                }

                @Override
                public Credentials getOverridingDeployerCredentials() {
                    return null;
                }

                @Override
                public CredentialsConfig getDeployerCredentialsConfig() {
                    return credentialsConfigs;
                }
            }, (Item)this.item);
            ArrayList<PluginSettings> list = new ArrayList<PluginSettings>(pluginInfoList.size());
            for (UserPluginInfo p : pluginInfoList) {
                HashMap paramsMap = Maps.newHashMap();
                List<UserPluginInfoParam> params = p.getPluginParams();
                for (UserPluginInfoParam param : params) {
                    paramsMap.put((String)param.getKey(), (String)param.getDefaultValue());
                }
                PluginSettings plugin = new PluginSettings(p.getPluginName(), paramsMap);
                list.add(plugin);
            }
            return list;
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            RefreshServerResponse response = new RefreshServerResponse();
            CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
            try {
                ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url, this.getArtifactoryServers());
                List<Repository> releaseRepositories = this.refreshRepositories(artifactoryServer, credentialsConfig);
                List<PluginSettings> userPluginKeys = this.refreshUserPlugins(artifactoryServer, credentialsConfig);
                response.setRepositories(releaseRepositories);
                response.setUserPlugins(userPluginKeys);
                response.setSuccess(true);
            }
            catch (Exception e) {
                response.setResponseMessage(e.getMessage());
                response.setSuccess(false);
            }
            return response;
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshResolversFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            RefreshServerResponse response = new RefreshServerResponse();
            CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
            ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url, RepositoriesUtils.getArtifactoryServers());
            try {
                List<VirtualRepository> virtualRepositories = this.refreshVirtualRepositories(artifactoryServer, credentialsConfig);
                response.setVirtualRepositories(virtualRepositories);
                response.setSuccess(true);
            }
            catch (Exception e) {
                response.setResponseMessage(e.getMessage());
                response.setSuccess(false);
            }
            return response;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginCredentials(project);
        }

        public String getDisplayName() {
            return "Gradle-Artifactory Integration";
        }

        public boolean isPushToBintrayEnabled() {
            return PluginsUtils.isPushToBintrayEnabled();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this, "gradle");
            this.save();
            return true;
        }

        public boolean isMultiConfProject() {
            return this.item.getClass().isAssignableFrom(MatrixProject.class);
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ArtifactoryGradleConfigurator wrapper = (ArtifactoryGradleConfigurator)super.newInstance(req, formData);
            return wrapper;
        }

        public FormValidation doCheckViolationRecipients(@QueryParameter String value) {
            return FormValidations.validateEmails(value);
        }

        public FormValidation doCheckArtifactoryCombinationFilter(@QueryParameter String value) throws IOException, InterruptedException {
            return FormValidations.validateArtifactoryCombinationFilter(value);
        }

        public List<ArtifactoryServer> getArtifactoryServers() {
            return RepositoriesUtils.getArtifactoryServers();
        }

        public boolean isUseCredentialsPlugin() {
            return PluginsUtils.isUseCredentialsPlugin();
        }

        public boolean isJiraPluginEnabled() {
            return Jenkins.getInstance().getPlugin("jira") != null;
        }
    }
}

