/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import com.google.common.collect.Lists;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.retention.Utils;
import org.jfrog.hudson.AbstractBuildInfoDeployer;
import org.jfrog.hudson.generic.ArtifactoryGenericConfigurator;
import org.jfrog.hudson.util.BuildRetentionFactory;
import org.jfrog.hudson.util.ExtractorUtils;

public class GenericBuildInfoDeployer
extends AbstractBuildInfoDeployer {
    private final Run build;
    private ArtifactoryGenericConfigurator configurator;
    private Build buildInfo;

    public GenericBuildInfoDeployer(ArtifactoryGenericConfigurator configurator, ArtifactoryBuildInfoClient client, Run build, TaskListener listener, List<Artifact> deployedArtifacts, List<BuildDependency> buildDependencies, List<Dependency> publishedDependencies) throws IOException, NoSuchAlgorithmException, InterruptedException {
        super(configurator, build, listener, client);
        this.configurator = configurator;
        this.build = build;
        this.buildInfo = this.createBuildInfo("Generic", "", BuildType.GENERIC);
        this.createDeployDetailsAndAddToBuildInfo(deployedArtifacts, publishedDependencies);
        this.buildInfo.setBuildDependencies(buildDependencies);
    }

    public void deploy() throws IOException {
        String url = this.configurator.getArtifactoryServer().getUrl() + "/api/build";
        this.listener.getLogger().println("Deploying build info to: " + url);
        BuildRetention retention = this.getBuildRetention();
        Utils.sendBuildAndBuildRetention((ArtifactoryBuildInfoClient)this.client, (Build)this.buildInfo, (BuildRetention)retention, (boolean)this.configurator.isAsyncBuildRetention());
    }

    private BuildRetention getBuildRetention() {
        BuildRetention buildRetention = null;
        if (this.configurator.isDiscardOldBuilds()) {
            buildRetention = BuildRetentionFactory.createBuildRetention(this.build, this.configurator.isDiscardBuildArtifacts());
        }
        return buildRetention;
    }

    private void createDeployDetailsAndAddToBuildInfo(List<Artifact> deployedArtifacts, List<Dependency> publishedDependencies) throws IOException, NoSuchAlgorithmException {
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(ExtractorUtils.sanitizeBuildName(this.build.getParent().getDisplayName()) + ":" + this.build.getNumber()).artifacts(deployedArtifacts);
        moduleBuilder.dependencies(publishedDependencies);
        this.buildInfo.setModules((List)Lists.newArrayList((Object[])new Module[]{moduleBuilder.build()}));
    }
}

