/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.PublishedItemsHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.UploadSpecHelper;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.generic.ArtifactoryGenericConfigurator;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.SpecUtils;

public class GenericArtifactsDeployer {
    private static final String SHA1 = "SHA1";
    private static final String MD5 = "MD5";
    private Run build;
    private ArtifactoryGenericConfigurator configurator;
    private BuildListener listener;
    private CredentialsConfig credentialsConfig;
    private EnvVars env;
    private List<Artifact> artifactsToDeploy = Lists.newArrayList();

    public GenericArtifactsDeployer(Run build, ArtifactoryGenericConfigurator configurator, BuildListener listener, CredentialsConfig credentialsConfig) throws IOException, InterruptedException, NoSuchAlgorithmException {
        this.build = build;
        this.configurator = configurator;
        this.listener = listener;
        this.credentialsConfig = credentialsConfig;
        this.env = build.getEnvironment((TaskListener)listener);
    }

    public List<Artifact> getDeployedArtifacts() {
        return this.artifactsToDeploy;
    }

    public void deploy() throws IOException, InterruptedException {
        FilePath workingDir = this.build.getExecutor().getCurrentWorkspace();
        ArrayListMultimap<String, String> propertiesToAdd = this.getbuildPropertiesMap();
        ArtifactoryServer artifactoryServer = this.configurator.getArtifactoryServer();
        if (this.configurator.isUseSpecs()) {
            String spec = SpecUtils.getSpecStringFromSpecConf(this.configurator.getUploadSpec(), this.env, workingDir, this.listener.getLogger());
            this.artifactsToDeploy = (List)workingDir.act((FilePath.FileCallable)new FilesDeployerCallable((TaskListener)this.listener, spec, artifactoryServer, this.credentialsConfig.getCredentials((Item)this.build.getParent()), propertiesToAdd, ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy)));
        } else {
            String deployPattern = Util.replaceMacro((String)this.configurator.getDeployPattern(), (Map)this.env);
            deployPattern = StringUtils.replace((String)deployPattern, (String)"\r\n", (String)"\n");
            Multimap pairs = PublishedItemsHelper.getPublishedItemsPatternPairs((String)(deployPattern = StringUtils.replace((String)deployPattern, (String)",", (String)"\n")));
            if (pairs.isEmpty()) {
                return;
            }
            String repositoryKey = Util.replaceMacro((String)this.configurator.getRepositoryKey(), (Map)this.env);
            this.artifactsToDeploy = (List)workingDir.act((FilePath.FileCallable)new FilesDeployerCallable((TaskListener)this.listener, (Multimap<String, String>)pairs, artifactoryServer, this.credentialsConfig.getCredentials((Item)this.build.getParent()), repositoryKey, propertiesToAdd, ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy)));
        }
    }

    private ArrayListMultimap<String, String> getbuildPropertiesMap() {
        String revision;
        ArrayListMultimap properties = ArrayListMultimap.create();
        String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(this.configurator, this.build);
        properties.put((Object)"build.name", (Object)buildName);
        properties.put((Object)"build.number", (Object)BuildUniqueIdentifierHelper.getBuildNumber(this.build));
        properties.put((Object)"build.timestamp", (Object)(this.build.getTimestamp().getTime().getTime() + ""));
        Cause.UpstreamCause parent = ActionableHelper.getUpstreamCause(this.build);
        if (parent != null) {
            properties.put((Object)"build.parentName", (Object)ExtractorUtils.sanitizeBuildName(parent.getUpstreamProject()));
            properties.put((Object)"build.parentNumber", (Object)(parent.getUpstreamBuild() + ""));
        }
        if (StringUtils.isNotBlank((String)(revision = ExtractorUtils.getVcsRevision((Map<String, String>)this.env)))) {
            properties.put((Object)"vcs.revision", (Object)revision);
        }
        this.addDeploymentProperties((Multimap<String, String>)properties);
        return properties;
    }

    private void addDeploymentProperties(Multimap<String, String> properties) {
        String[] deploymentProperties = StringUtils.split((String)this.configurator.getDeploymentProperties(), (String)";");
        if (deploymentProperties == null) {
            return;
        }
        for (String property : deploymentProperties) {
            String[] split = StringUtils.split((String)property, (char)'=');
            if (split.length != 2) continue;
            String value = Util.replaceMacro((String)split[1], (Map)this.env);
            properties.put((Object)split[0].replace(" ", ""), (Object)value);
        }
    }

    public static class FilesDeployerCallable
    extends MasterToSlaveFileCallable<List<Artifact>> {
        private String repositoryKey;
        private TaskListener listener;
        private Multimap<String, String> patternPairs;
        private ArtifactoryServer server;
        private Credentials credentials;
        private ArrayListMultimap<String, String> buildProperties;
        private ProxyConfiguration proxyConfiguration;
        private PatternType patternType = PatternType.ANT;
        private String spec;
        private Set<DeployDetails> deployableArtifacts;

        public FilesDeployerCallable(TaskListener listener, Multimap<String, String> patternPairs, ArtifactoryServer server, Credentials credentials, String repositoryKey, ArrayListMultimap<String, String> buildProperties, ProxyConfiguration proxyConfiguration) {
            this.listener = listener;
            this.patternPairs = patternPairs;
            this.server = server;
            this.credentials = credentials;
            this.repositoryKey = repositoryKey;
            this.buildProperties = buildProperties;
            this.proxyConfiguration = proxyConfiguration;
        }

        public FilesDeployerCallable(TaskListener listener, String spec, ArtifactoryServer server, Credentials credentials, ArrayListMultimap<String, String> buildProperties, ProxyConfiguration proxyConfiguration) {
            this.listener = listener;
            this.spec = spec;
            this.server = server;
            this.credentials = credentials;
            this.buildProperties = buildProperties;
            this.proxyConfiguration = proxyConfiguration;
        }

        public FilesDeployerCallable(TaskListener listener, Set<DeployDetails> deployableArtifacts, ArtifactoryServer server, Credentials credentials, ProxyConfiguration proxyConfiguration) {
            this.listener = listener;
            this.deployableArtifacts = deployableArtifacts;
            this.server = server;
            this.credentials = credentials;
            this.proxyConfiguration = proxyConfiguration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Artifact> invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
            Set<Object> artifactsToDeploy;
            JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
            ArtifactoryBuildInfoClient client = this.server.createArtifactoryClient(this.credentials.getUsername(), this.credentials.getPassword(), this.proxyConfiguration, log);
            if (StringUtils.isNotEmpty((String)this.spec)) {
                SpecsHelper specsHelper = new SpecsHelper((Log)log);
                try {
                    List list = specsHelper.uploadArtifactsBySpec(this.spec, workspace, this.buildProperties, client);
                    return list;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed uploading artifacts by spec", e);
                }
                finally {
                    client.close();
                }
            }
            if (this.deployableArtifacts != null) {
                artifactsToDeploy = this.deployableArtifacts;
            } else {
                artifactsToDeploy = Sets.newHashSet();
                Multimap<String, File> targetPathToFilesMap = this.buildTargetPathToFiles(workspace);
                for (Map.Entry entry : targetPathToFilesMap.entries()) {
                    artifactsToDeploy.addAll(this.buildDeployDetailsFromFileEntry(entry));
                }
            }
            try {
                this.deploy(client, (Set<DeployDetails>)artifactsToDeploy);
                List<Artifact> list = this.convertDeployDetailsToArtifacts((Set<DeployDetails>)artifactsToDeploy);
                return list;
            }
            finally {
                client.close();
            }
        }

        private List<Artifact> convertDeployDetailsToArtifacts(Set<DeployDetails> details) {
            ArrayList result = Lists.newArrayList();
            for (DeployDetails detail : details) {
                String ext = FilenameUtils.getExtension((String)detail.getFile().getName());
                Artifact artifact = new ArtifactBuilder(detail.getFile().getName()).md5(detail.getMd5()).sha1(detail.getSha1()).type(ext).build();
                result.add(artifact);
            }
            return result;
        }

        public void deploy(ArtifactoryBuildInfoClient client, Set<DeployDetails> artifactsToDeploy) throws IOException {
            for (DeployDetails deployDetail : artifactsToDeploy) {
                StringBuilder deploymentPathBuilder = new StringBuilder(this.server.getUrl());
                deploymentPathBuilder.append("/").append(deployDetail.getTargetRepository());
                if (!deployDetail.getArtifactPath().startsWith("/")) {
                    deploymentPathBuilder.append("/");
                }
                deploymentPathBuilder.append(deployDetail.getArtifactPath());
                client.deployArtifact(deployDetail);
            }
        }

        private Multimap<String, File> buildTargetPathToFiles(File workspace) throws IOException {
            HashMultimap result = HashMultimap.create();
            if (this.patternPairs == null) {
                return result;
            }
            for (Map.Entry entry : this.patternPairs.entries()) {
                String targetPath;
                String pattern = (String)entry.getKey();
                Multimap publishingData = PublishedItemsHelper.buildPublishingData((File)workspace, (String)pattern, (String)(targetPath = (String)entry.getValue()));
                if (publishingData != null) {
                    this.listener.getLogger().println("For pattern: " + pattern + " " + publishingData.size() + " artifacts were found");
                    result.putAll(publishingData);
                    continue;
                }
                this.listener.getLogger().println("For pattern: " + pattern + " no artifacts were found");
            }
            return result;
        }

        private Set<DeployDetails> buildDeployDetailsFromFileEntry(Map.Entry<String, File> fileEntry) throws IOException {
            HashSet result = Sets.newHashSet();
            String targetPath = fileEntry.getKey();
            File artifactFile = fileEntry.getValue();
            String path = this.patternType == PatternType.ANT ? PublishedItemsHelper.calculateTargetPath((String)targetPath, (File)artifactFile) : UploadSpecHelper.wildcardCalculateTargetPath((String)targetPath, (File)artifactFile);
            path = StringUtils.replace((String)path, (String)"//", (String)"/");
            Map checksums = Maps.newHashMap();
            try {
                checksums = FileChecksumCalculator.calculateChecksums((File)artifactFile, (String[])new String[]{GenericArtifactsDeployer.SHA1, GenericArtifactsDeployer.MD5});
            }
            catch (NoSuchAlgorithmException e) {
                this.listener.getLogger().println("Could not find checksum algorithm for SHA1 or MD5");
            }
            DeployDetails.Builder builder = new DeployDetails.Builder().file(artifactFile).artifactPath(path).targetRepository(this.repositoryKey).md5((String)checksums.get(GenericArtifactsDeployer.MD5)).sha1((String)checksums.get(GenericArtifactsDeployer.SHA1)).addProperties(this.buildProperties);
            result.add(builder.build());
            return result;
        }

        public static enum PatternType {
            ANT,
            WILDCARD;

        }
    }
}

