/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.action;

import com.google.common.collect.Lists;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.maven.MavenBuild;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Project;
import hudson.model.Run;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.action.ArtifactoryProjectAction;
import org.jfrog.hudson.util.publisher.PublisherFindImpl;
import org.jfrog.hudson.util.publisher.PublisherFlexible;

public abstract class ActionableHelper
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static MavenArtifactRecord getLatestMavenArtifactRecord(MavenBuild mavenBuild) {
        return ActionableHelper.getLatestAction((Run)mavenBuild, MavenArtifactRecord.class);
    }

    public static <T extends Action> T getLatestAction(Run build, Class<T> actionClass) {
        List records = build.getActions(actionClass);
        if (records == null || records.isEmpty()) {
            return null;
        }
        return (T)((Action)records.get(records.size() - 1));
    }

    public static <T extends Publisher> T getPublisher(AbstractProject<?, ?> project, Class<T> type) {
        Object publisher = new PublisherFindImpl<T>().find(project, type);
        if (publisher != null) {
            return publisher;
        }
        publisher = new PublisherFlexible<T>().find(project, type);
        return publisher;
    }

    public static <T extends BuildWrapper> T getBuildWrapper(BuildableItem wrapped, Class<T> type) {
        DescribableList wrappers = ((BuildableItemWithBuildWrappers)wrapped).getBuildWrappersList();
        for (BuildWrapper wrapper : wrappers) {
            if (!type.isInstance(wrapper)) continue;
            return (T)((BuildWrapper)type.cast(wrapper));
        }
        return null;
    }

    public static <T extends Builder> List<T> getBuilder(Project<?, ?> project, Class<T> type) {
        ArrayList result = Lists.newArrayList();
        DescribableList builders = project.getBuildersList();
        for (Builder builder : builders) {
            if (!type.isInstance(builder)) continue;
            result.add(type.cast(builder));
        }
        return result;
    }

    public static Cause.UpstreamCause getUpstreamCause(Run build) {
        CauseAction action = ActionableHelper.getLatestAction(build, CauseAction.class);
        if (action != null) {
            for (Cause cause : action.getCauses()) {
                if (!(cause instanceof Cause.UpstreamCause)) continue;
                return (Cause.UpstreamCause)cause;
            }
        }
        return null;
    }

    public static String getUserCausePrincipal(Run build) {
        return ActionableHelper.getUserCausePrincipal(build, "anonymous");
    }

    public static String getUserCausePrincipal(Run build, String defaultPrincipal) {
        Cause.UserIdCause userCause = ActionableHelper.getUserCause(build);
        String principal = defaultPrincipal;
        if (userCause != null && userCause.getUserId() != null) {
            principal = userCause.getUserId();
        }
        return principal;
    }

    private static Cause.UserIdCause getUserCause(Run build) {
        CauseAction action = ActionableHelper.getLatestAction(build, CauseAction.class);
        if (action != null) {
            for (Cause cause : action.getCauses()) {
                if (!(cause instanceof Cause.UserIdCause)) continue;
                return (Cause.UserIdCause)cause;
            }
        }
        return null;
    }

    public static String getBuildUrl(Run build) {
        String root = Hudson.getInstance().getRootUrl();
        if (StringUtils.isBlank((String)root)) {
            return "";
        }
        return root + build.getUrl();
    }

    public static List<ArtifactoryProjectAction> getArtifactoryProjectAction(String artifactoryServerName, AbstractProject project) {
        if (ActionableHelper.shouldReturnEmptyList(artifactoryServerName, project)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new ArtifactoryProjectAction[]{new ArtifactoryProjectAction(artifactoryServerName, project)});
    }

    private static boolean shouldReturnEmptyList(String artifactoryServerName, AbstractProject project) {
        if (artifactoryServerName == null) {
            return true;
        }
        if (project.getAction(ArtifactoryProjectAction.class) != null) {
            return true;
        }
        return project instanceof MatrixConfiguration;
    }

    public static List<ArtifactoryProjectAction> getArtifactoryProjectAction(String artifactoryServerName, AbstractProject project, String buildName) {
        if (ActionableHelper.shouldReturnEmptyList(artifactoryServerName, project)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new ArtifactoryProjectAction[]{new ArtifactoryProjectAction(artifactoryServerName, buildName)});
    }

    public static String getArtifactoryPluginVersion() {
        String pluginsSortName = "artifactory";
        if (Jenkins.getInstance() != null && Jenkins.getInstance().getPlugin(pluginsSortName) != null && Jenkins.getInstance().getPlugin(pluginsSortName).getWrapper() != null) {
            return Jenkins.getInstance().getPlugin(pluginsSortName).getWrapper().getVersion();
        }
        return "";
    }

    public static int getDefaultConnectionRetries() {
        return 3;
    }

    public static void deleteFilePath(FilePath workspace, String path) throws IOException {
        if (StringUtils.isNotBlank((String)path)) {
            try {
                FilePath propertiesFile = new FilePath(workspace, path);
                propertiesFile.delete();
            }
            catch (Exception e) {
                throw new IOException("Could not delete temp file: " + path);
            }
        }
    }

    public static void deleteFilePathOnExit(FilePath workspace, String path) throws IOException, InterruptedException {
        FilePath filePath = new FilePath(workspace, path);
        ActionableHelper.deleteFilePathOnExit(filePath);
    }

    public static void deleteFilePathOnExit(FilePath filePath) throws IOException, InterruptedException {
        filePath.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Void>(){

            public Void invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                file.deleteOnExit();
                return null;
            }
        });
    }

    public static Node getNode(Launcher launcher) {
        Node node = null;
        Jenkins j = Jenkins.getInstance();
        for (Computer c : j.getComputers()) {
            if (c.getChannel() != launcher.getChannel()) continue;
            node = c.getNode();
            break;
        }
        return node;
    }
}

