/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.model.Item;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CredentialsConfig
implements Serializable {
    public static final CredentialsConfig EMPTY_CREDENTIALS_CONFIG = new CredentialsConfig(new Credentials("", ""), "", false);
    private Credentials credentials;
    private String credentialsId;
    private Boolean overridingCredentials = false;
    private boolean ignoreCredentialPluginDisabled;

    @DataBoundConstructor
    public CredentialsConfig(String username, String password, String credentialsId, Boolean overridingCredentials) {
        this.overridingCredentials = overridingCredentials == null ? false : overridingCredentials;
        this.credentials = new Credentials(username, password);
        this.credentialsId = credentialsId;
    }

    public CredentialsConfig(String username, String password, String credentialsId) {
        this.overridingCredentials = false;
        this.ignoreCredentialPluginDisabled = StringUtils.isNotEmpty((String)credentialsId);
        this.credentials = new Credentials(username, password);
        this.credentialsId = credentialsId;
    }

    public CredentialsConfig(Credentials credentials, String credentialsId, boolean overridingCredentials) {
        this.credentials = credentials;
        this.credentialsId = credentialsId;
        this.overridingCredentials = overridingCredentials;
    }

    public boolean isCredentialsProvided() {
        if (PluginsUtils.isCredentialsPluginEnabled() || this.ignoreCredentialPluginDisabled) {
            return StringUtils.isNotBlank((String)this.credentialsId);
        }
        return this.overridingCredentials;
    }

    public String provideUsername(Item item) {
        return this.isUsingCredentialsPlugin() ? PluginsUtils.credentialsLookup(this.credentialsId, item).getUsername() : this.credentials.getUsername();
    }

    public String providePassword(Item item) {
        return this.isUsingCredentialsPlugin() ? PluginsUtils.credentialsLookup(this.credentialsId, item).getPassword() : this.credentials.getPassword();
    }

    public Credentials getCredentials(Item item) {
        return this.isUsingCredentialsPlugin() ? PluginsUtils.credentialsLookup(this.credentialsId, item) : this.credentials;
    }

    public String getUsername() {
        if (this.credentials == null) {
            return "";
        }
        return this.credentials.getUsername();
    }

    public String getPassword() {
        if (this.credentials == null) {
            return "";
        }
        return this.credentials.getPassword();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public boolean isOverridingCredentials() {
        return this.overridingCredentials;
    }

    public boolean isIgnoreCredentialPluginDisabled() {
        return this.ignoreCredentialPluginDisabled;
    }

    public void setIgnoreCredentialPluginDisabled(boolean ignoreCredentialPluginDisabled) {
        this.ignoreCredentialPluginDisabled = ignoreCredentialPluginDisabled;
    }

    public boolean isUsingCredentialsPlugin() {
        return PluginsUtils.isCredentialsPluginEnabled() && StringUtils.isNotEmpty((String)this.credentialsId) || this.ignoreCredentialPluginDisabled;
    }
}

