/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.BintrayPublish;

import com.google.common.collect.Lists;
import hudson.model.AbstractBuild;
import hudson.model.BuildBadgeAction;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.release.BintrayUploadInfoOverride;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.bintrayResponse.BintrayResponse;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.util.VersionException;
import org.jfrog.hudson.ArtifactoryPlugin;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class BintrayPublishAction<C extends BuildInfoAwareConfigurator & DeployerOverrider>
extends TaskAction
implements BuildBadgeAction {
    private static final String MINIMAL_SUPPORTED_VERSION = "3.5.3";
    private final AbstractBuild build;
    private final C configurator;
    private boolean override;
    private String subject;
    private String repoName;
    private String packageName;
    private String versionName;
    private String signMethod;
    private List<String> licenses;
    private String passphrase;
    private String vcsUrl;

    public BintrayPublishAction(AbstractBuild build, C configurator) {
        this.build = build;
        this.configurator = configurator;
    }

    public void doSubmit(StaplerRequest req, StaplerResponse resp) throws ServletException, IOException {
        this.getACL().checkPermission(this.getPermission());
        ArtifactoryServer artifactory = this.configurator.getArtifactoryServer();
        this.resetFields();
        req.bindParameters((Object)this);
        if (!this.override) {
            this.resetOverrideFields();
        }
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer((DeployerOverrider)this.configurator, this.configurator.getArtifactoryServer());
        new PushToBintrayWorker(artifactory, credentialsConfig.getCredentials((Item)this.build.getProject())).start();
        resp.sendRedirect(".");
    }

    private void resetFields() {
        this.resetOverrideFields();
        this.resetQueryFields();
        this.override = false;
    }

    private void resetOverrideFields() {
        this.subject = null;
        this.repoName = null;
        this.packageName = null;
        this.versionName = null;
        this.licenses = Lists.newArrayList();
        this.vcsUrl = null;
    }

    private void resetQueryFields() {
        this.signMethod = null;
        this.passphrase = null;
    }

    public void doIndex(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        req.getView((Object)this, this.getCurrentAction()).forward((ServletRequest)req, (ServletResponse)resp);
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean hasPushToBintrayPermission() {
        return this.getACL().hasPermission(this.getPermission()) && PluginsUtils.isPushToBintrayEnabled();
    }

    public synchronized String getCurrentAction() {
        return this.workerThread == null ? "form.jelly" : "progress.jelly";
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        if (StringUtils.isNotBlank((String)subject)) {
            this.subject = subject.trim();
        }
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        if (StringUtils.isNotEmpty((String)repoName)) {
            this.repoName = repoName.trim();
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        if (StringUtils.isNotEmpty((String)packageName)) {
            this.packageName = packageName;
        }
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        if (StringUtils.isNotEmpty((String)versionName)) {
            this.versionName = versionName;
        }
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(String signMethod) {
        if (StringUtils.isNotEmpty((String)signMethod)) {
            this.signMethod = signMethod;
        }
    }

    public String getLicenses() {
        return StringUtils.join(this.licenses, (String)",");
    }

    public void setLicenses(String licenses) {
        if (StringUtils.isNotBlank((String)licenses)) {
            String[] licenseList;
            this.licenses = Lists.newArrayList();
            for (String s : licenseList = licenses.split(",")) {
                if ((s = s.trim()).isEmpty()) continue;
                this.licenses.add(s);
            }
        } else {
            this.licenses = null;
        }
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        if (StringUtils.isNotEmpty((String)passphrase)) {
            this.passphrase = passphrase.trim();
        }
    }

    public String getVcsUrl() {
        return this.vcsUrl;
    }

    public void setVcsUrl(String vcsUrl) {
        if (StringUtils.isNotEmpty((String)vcsUrl)) {
            this.vcsUrl = vcsUrl.trim();
        }
    }

    public AbstractBuild getBuild() {
        return this.build;
    }

    protected Permission getPermission() {
        return ArtifactoryPlugin.PUSH_TO_BINTRAY;
    }

    protected ACL getACL() {
        return this.build.getACL();
    }

    public String getIconFileName() {
        return "/plugin/artifactory/images/bintray.png";
    }

    public String getDisplayName() {
        return "Push to Bintray (deprecated)";
    }

    public String getUrlName() {
        if (this.hasPushToBintrayPermission()) {
            return "bintray";
        }
        return null;
    }

    private boolean isValidArtifactoryVersion(ArtifactoryBuildInfoClient client) throws VersionException {
        ArtifactoryVersion version = client.verifyCompatibleArtifactoryVersion();
        return version.isAtLeast(new ArtifactoryVersion(MINIMAL_SUPPORTED_VERSION));
    }

    public final class PushToBintrayWorker
    extends TaskThread {
        private final ArtifactoryServer artifactoryServer;
        private final Credentials deployer;

        public PushToBintrayWorker(ArtifactoryServer artifactoryServer, Credentials deployer) {
            super((TaskAction)BintrayPublishAction.this, TaskThread.ListenerAndText.forMemory(null));
            this.artifactoryServer = artifactoryServer;
            this.deployer = deployer;
        }

        protected void perform(TaskListener listener) throws IOException {
            long started = System.currentTimeMillis();
            BintrayUploadInfoOverride uploadInfoOverride = new BintrayUploadInfoOverride(BintrayPublishAction.this.subject, BintrayPublishAction.this.repoName, BintrayPublishAction.this.packageName, BintrayPublishAction.this.versionName, BintrayPublishAction.this.licenses, BintrayPublishAction.this.vcsUrl);
            PrintStream logger = listener.getLogger();
            ArtifactoryBuildInfoClient client = this.artifactoryServer.createArtifactoryClient(this.deployer.getUsername(), this.deployer.getPassword(), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));
            if (BintrayPublishAction.this.override && !uploadInfoOverride.isValid()) {
                logger.print("Please fill in all mandatory fields when pushing to Bintray without descriptor file\n");
            } else {
                try {
                    logger.println("Publishing to Bintray...");
                    if (BintrayPublishAction.this.isValidArtifactoryVersion(client)) {
                        String buildName = BintrayPublishAction.this.configurator.isOverrideBuildName() ? BintrayPublishAction.this.configurator.getCustomBuildName() : BuildUniqueIdentifierHelper.getBuildName((Run)BintrayPublishAction.this.build);
                        String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber((Run)BintrayPublishAction.this.build);
                        BintrayResponse response = client.pushToBintray(buildName, buildNumber, BintrayPublishAction.this.signMethod, BintrayPublishAction.this.passphrase, uploadInfoOverride);
                        logger.println(response);
                    } else {
                        logger.println("Bintray push is not supported in your Artifactory version.");
                    }
                }
                catch (Exception e) {
                    logger.println(e.getMessage());
                }
            }
            long timeToWait = 2000L - (System.currentTimeMillis() - started);
            if (timeToWait > 0L) {
                try {
                    Thread.sleep(timeToWait);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace(listener.error(ie.getMessage()));
                }
            }
            BintrayPublishAction.this.passphrase = null;
            BintrayPublishAction.this.workerThread = null;
            client.close();
        }
    }
}

